/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavProvider;
import com.ecyrd.jspwiki.dav.HTMLPagesDavProvider;
import com.ecyrd.jspwiki.dav.RawPagesDavProvider;
import com.ecyrd.jspwiki.dav.WebdavServlet;
import com.ecyrd.jspwiki.dav.WikiRootProvider;
import com.ecyrd.jspwiki.dav.methods.DavMethod;
import com.ecyrd.jspwiki.dav.methods.GetMethod;
import com.ecyrd.jspwiki.dav.methods.PropFindMethod;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public class WikiDavServlet
extends WebdavServlet {
    private static final long serialVersionUID = 1L;
    private WikiEngine m_engine;
    Logger log = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private DavProvider m_rawProvider;
    private DavProvider m_rootProvider;
    private DavProvider m_htmlProvider;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_engine = WikiEngine.getInstance(config);
        this.m_rawProvider = new RawPagesDavProvider(this.m_engine);
        this.m_rootProvider = new WikiRootProvider(this.m_engine);
        this.m_htmlProvider = new HTMLPagesDavProvider(this.m_engine);
    }

    private DavProvider pickProvider(String context) {
        if (context.equals("raw")) {
            return this.m_rawProvider;
        }
        if (context.equals("html")) {
            return this.m_htmlProvider;
        }
        return this.m_rootProvider;
    }

    public void doPropFind(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        StopWatch sw = new StopWatch();
        sw.start();
        String p = new String(req.getPathInfo().getBytes("ISO-8859-1"), "UTF-8");
        DavPath path = new DavPath(p);
        if (path.isRoot()) {
            PropFindMethod dm = new PropFindMethod(this.m_rootProvider);
            ((DavMethod)dm).execute(req, res, path);
        } else {
            String context = path.get(0);
            PropFindMethod m = new PropFindMethod(this.pickProvider(context));
            m.execute(req, res, path.subPath(1));
        }
        sw.stop();
        this.log.debug((Object)("Propfind done for path " + path + ", took " + sw));
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) {
        this.log.debug((Object)("DAV doOptions for path " + req.getPathInfo()));
        res.setHeader("DAV", "1");
        res.setHeader("Allow", "GET, PUT, POST, OPTIONS, PROPFIND, PROPPATCH, MOVE, COPY, DELETE");
        res.setStatus(200);
    }

    public void doMkCol(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getContentLength() > 0) {
            response.sendError(415, "Message may contain no body");
        } else {
            response.sendError(401, "JSPWiki is read-only.");
        }
    }

    public void doPropPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void doCopy(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(401, "JSPWiki is read-only.");
    }

    public void doMove(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(401, "JSPWiki is read-only.");
    }

    protected void doDelete(HttpServletRequest arg0, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(401, "JSPWiki is read-only.");
    }

    protected void doPost(HttpServletRequest arg0, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(401, "JSPWiki is read-only.");
    }

    protected void doPut(HttpServletRequest arg0, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(401, "JSPWiki is read-only.");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        req.setCharacterEncoding(this.m_engine.getContentEncoding());
        String p = req.getPathInfo();
        DavPath path = new DavPath(p);
        if (path.isRoot()) {
            GetMethod dm = new GetMethod(this.m_rootProvider);
            ((DavMethod)dm).execute(req, res, path);
        } else {
            GetMethod dm = new GetMethod(this.pickProvider(path.get(0)));
            ((DavMethod)dm).execute(req, res, path.subPath(1));
        }
    }
}

