/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav.items;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavProvider;
import com.ecyrd.jspwiki.dav.WikiDavProvider;
import com.ecyrd.jspwiki.dav.items.PageDavItem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.jdom.Element;

public class HTMLPageDavItem
extends PageDavItem {
    private long m_cachedLength = -1L;

    public HTMLPageDavItem(DavProvider provider, DavPath path, WikiPage page) {
        super(provider, path, page);
    }

    public String getHref() {
        return this.m_provider.getURL(this.m_path);
    }

    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    private byte[] getText() {
        WikiEngine engine = ((WikiDavProvider)this.m_provider).getEngine();
        WikiContext context = new WikiContext(engine, this.m_page);
        context.setRequestContext(WikiContext.VIEW);
        context.setVariable("jspwiki.translatorReader.runPlugins", "false");
        context.setVariable("jspwiki.runFilters", "false");
        String text = engine.getHTML(context, this.m_page);
        try {
            return text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public InputStream getInputStream() {
        byte[] text = this.getText();
        ByteArrayInputStream in = new ByteArrayInputStream(text);
        return in;
    }

    public long getLength() {
        if (this.m_cachedLength == -1L) {
            byte[] text = this.getText();
            this.m_cachedLength = text.length;
        }
        return this.m_cachedLength;
    }

    public Collection getPropertySet() {
        Collection set = this.getCommonProperties();
        set.add(new Element("getcontentlength", this.m_davns).setText(Long.toString(this.getLength())));
        set.add(new Element("getcontenttype", this.m_davns).setText("text/html; charset=\"UTF-8\""));
        return set;
    }
}

