/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav.items;

import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavProvider;
import com.ecyrd.jspwiki.dav.WikiDavProvider;
import com.ecyrd.jspwiki.dav.items.DavItem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class PageDavItem
extends DavItem {
    protected WikiPage m_page;
    protected Namespace m_dcns = Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/");
    protected Namespace m_davns = Namespace.getNamespace((String)"DAV:");

    public PageDavItem(DavProvider provider, DavPath path, WikiPage page) {
        super(provider, path);
        this.m_page = page;
    }

    public WikiPage getPage() {
        return this.m_page;
    }

    protected Collection getCommonProperties() {
        ArrayList<Element> set = new ArrayList<Element>();
        set.add(new Element("resourcetype", this.m_davns));
        set.add(new Element("creator", this.m_dcns).setText(this.m_page.getAuthor()));
        set.add(new Element("getlastmodified", this.m_davns).setText(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(this.m_page.getLastModified())));
        set.add(new Element("displayname", this.m_davns).setText(this.m_page.getName()));
        return set;
    }

    public Collection getPropertySet() {
        Collection set = this.getCommonProperties();
        set.add(new Element("getcontentlength", this.m_davns).setText(Long.toString(this.getLength())));
        set.add(new Element("getcontenttype", this.m_davns).setText(this.getContentType()));
        return set;
    }

    public String getHref() {
        return this.m_provider.getURL(this.m_path);
    }

    public String getContentType() {
        return "text/plain; charset=UTF-8";
    }

    public InputStream getInputStream() {
        String text = ((WikiDavProvider)this.m_provider).getEngine().getPureText(this.m_page);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes("UTF-8"));
            return in;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public long getLength() {
        String text = ((WikiDavProvider)this.m_provider).getEngine().getPureText(this.m_page);
        return text.length();
    }
}

