/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav.methods;

import com.ecyrd.jspwiki.dav.DavContext;
import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavProvider;
import com.ecyrd.jspwiki.dav.items.DavItem;
import com.ecyrd.jspwiki.dav.methods.DavMethod;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class PropFindMethod
extends DavMethod {
    private static Logger log = Logger.getLogger((Class)PropFindMethod.class);

    public PropFindMethod(DavProvider provider) {
        super(provider);
    }

    public void sendMultiResponse(HttpServletResponse res, Element response) throws IOException {
        res.setContentType("application/xml; charset=\"UTF-8\"");
        res.setStatus(207);
        Document doc = new Document();
        doc.setRootElement(response);
        XMLOutputter output = new XMLOutputter();
        output.setFormat(Format.getPrettyFormat());
        output.output(doc, (Writer)res.getWriter());
    }

    private Element getPropertyNames(DavContext dc) {
        log.debug((Object)("Retrieving all property names for context " + dc));
        Namespace davns = Namespace.getNamespace((String)"DAV:");
        Element root = new Element("multistatus", davns);
        DavItem di = this.m_provider.getItem(dc.getPath());
        Iterator i = di.iterator(dc.getDepth());
        while (i.hasNext()) {
            di = (DavItem)i.next();
            Element response = new Element("response", davns);
            response.addContent((Content)new Element("href", davns).setText(di.getHref()));
            Element propstat = new Element("propstat", davns);
            Collection c = di.getPropertySet();
            Element prop = new Element("prop", davns);
            Iterator j = c.iterator();
            while (j.hasNext()) {
                Element el = (Element)j.next();
                el.removeContent();
                prop.addContent((Content)el);
            }
            propstat.addContent((Content)prop);
            propstat.addContent((Content)new Element("status", davns).setText("HTTP/1.1 200 OK"));
            response.addContent((Content)propstat);
            root.addContent((Content)response);
        }
        return root;
    }

    private Element getProperties(DavContext dc, List askedprops) throws IOException {
        Namespace davns = Namespace.getNamespace((String)"DAV:");
        Element root = new Element("multistatus", davns);
        DavItem di = this.m_provider.getItem(dc.getPath());
        if (di == null) {
            throw new FileNotFoundException(dc.getPath().toString());
        }
        Iterator i = di.iterator(dc.getDepth());
        while (i.hasNext()) {
            Element ps;
            di = (DavItem)i.next();
            Element response = new Element("response", davns);
            response.addContent((Content)new Element("href", davns).setText(di.getHref()));
            Element props = new Element("prop", davns);
            Element failedprops = new Element("prop", davns);
            Collection c = di.getPropertySet();
            if (askedprops == null) {
                Iterator j = c.iterator();
                while (j.hasNext()) {
                    Element el = (Element)j.next();
                    props.addContent((Content)el);
                }
            } else {
                Iterator x = askedprops.iterator();
                while (x.hasNext()) {
                    Element askedElement = (Element)x.next();
                    boolean found = false;
                    Iterator j = c.iterator();
                    while (j.hasNext()) {
                        Element el = (Element)j.next();
                        if (!askedElement.getNamespaceURI().equals(el.getNamespaceURI()) || !askedElement.getName().equals(el.getName())) continue;
                        if (props.indexOf((Content)el) == -1) {
                            props.addContent((Content)el);
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    Element el = (Element)askedElement.clone();
                    failedprops.addContent((Content)el);
                }
            }
            if (props.getContentSize() > 0) {
                ps = new Element("propstat", davns);
                ps.addContent((Content)props);
                ps.addContent((Content)new Element("status", davns).setText("HTTP/1.1 200 OK"));
                response.addContent((Content)ps);
            }
            if (failedprops.getContentSize() > 0) {
                ps = new Element("propstat", davns);
                ps.addContent((Content)failedprops);
                ps.addContent((Content)new Element("status", davns).setText("HTTP/1.1 404 Not found"));
                response.addContent((Content)ps);
            }
            root.addContent((Content)response);
        }
        return root;
    }

    private Element getAllProps(DavContext dc) throws ProviderException, IOException {
        log.debug((Object)("Retrieving all properties for context " + dc.getPath()));
        return this.getProperties(dc, null);
    }

    public void execute(HttpServletRequest req, HttpServletResponse res, DavPath dp) throws ServletException, IOException {
        DavContext dc = new DavContext(req, dp);
        try {
            Document doc = new SAXBuilder().build((InputStream)req.getInputStream());
            XPath xpath = XPath.newInstance((String)"/D:propfind/*");
            xpath.addNamespace("D", "DAV:");
            Element firstnode = (Element)xpath.selectSingleNode((Object)doc);
            Element davresponse = null;
            System.out.println("Request=" + dc.getPath() + " depth=" + dc.getDepth());
            if (firstnode == null || firstnode.getName().equals("allprop")) {
                davresponse = this.getAllProps(dc);
            } else if (firstnode.getName().equals("propname")) {
                davresponse = this.getPropertyNames(dc);
            } else if (firstnode.getName().equals("prop")) {
                XPath ndxp = XPath.newInstance((String)"/D:propfind/D:prop/*");
                ndxp.addNamespace("D", "DAV:");
                List nodes = ndxp.selectNodes((Object)doc);
                davresponse = this.getProperties(dc, nodes);
            }
            this.sendMultiResponse(res, davresponse);
        }
        catch (JDOMException e) {
            log.info((Object)"Broken XML received", (Throwable)e);
            res.sendError(400, "Parse error");
        }
        catch (ProviderException e) {
            log.error((Object)"Provider failed", (Throwable)e);
            res.sendError(500, e.getMessage());
        }
        catch (FileNotFoundException e) {
            res.sendError(404, e.getMessage());
        }
    }
}

