/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.event;

import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class WikiEventManager {
    private static final Logger log = Logger.getLogger((Class)WikiEventManager.class);
    private static boolean c_permitMonitor = false;
    private static WikiEventListener c_monitor = null;
    private final Map m_delegates = new HashMap();
    private final Vector m_preloadCache = new Vector();
    private static WikiEventManager c_instance = null;

    private WikiEventManager() {
        c_instance = this;
        log.debug((Object)"instantiated WikiEventManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiEventManager getInstance() {
        if (c_instance == null) {
            Class clazz = WikiEventManager.class;
            synchronized (clazz) {
                WikiEventManager mgr = new WikiEventManager();
                return mgr;
            }
        }
        return c_instance;
    }

    public static final boolean addWikiEventListener(Object client, WikiEventListener listener) {
        if (client == WikiEventManager.class) {
            if (c_permitMonitor) {
                c_monitor = listener;
            }
            return c_permitMonitor;
        }
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.addWikiEventListener(listener);
    }

    public static final boolean removeWikiEventListener(Object client, WikiEventListener listener) {
        if (client == WikiEventManager.class) {
            c_monitor = null;
            return true;
        }
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.removeWikiEventListener(listener);
    }

    public static final Set getWikiEventListeners(Object client) throws UnsupportedOperationException {
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.getWikiEventListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean removeWikiEventListener(WikiEventListener listener) {
        Map sources;
        WikiEventManager mgr = WikiEventManager.getInstance();
        Map map = sources = mgr.getDelegates();
        synchronized (map) {
            Iterator it = sources.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                WikiEventDelegate delegate = (WikiEventDelegate)entry.getValue();
                if (delegate == null || !delegate.removeWikiEventListener(listener)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isListening(Object client) {
        WikiEventDelegate source = WikiEventManager.getInstance().getDelegateFor(client);
        return source != null ? source.isListening() : false;
    }

    public static void fireEvent(Object client, WikiEvent event) {
        WikiEventDelegate source = WikiEventManager.getInstance().getDelegateFor(client);
        if (source != null) {
            source.fireEvent(event);
        }
        if (c_monitor != null) {
            c_monitor.actionPerformed(event);
        }
    }

    private Map getDelegates() {
        return this.m_delegates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WikiEventDelegate getDelegateFor(Object client) {
        Map map = this.m_delegates;
        synchronized (map) {
            WikiEventDelegate delegate;
            if (client == null || client instanceof Class) {
                WikiEventDelegate delegate2 = new WikiEventDelegate(client);
                this.m_preloadCache.add(delegate2);
                this.m_delegates.put(client, delegate2);
                return delegate2;
            }
            if (!this.m_preloadCache.isEmpty()) {
                for (int i = this.m_preloadCache.size() - 1; i >= 0; --i) {
                    WikiEventDelegate delegate3 = (WikiEventDelegate)this.m_preloadCache.elementAt(i);
                    if (delegate3.getClientClass() != null && !delegate3.getClientClass().equals(client.getClass()) || this.m_delegates.keySet().contains(client)) continue;
                    this.m_preloadCache.remove(delegate3);
                    this.m_delegates.put(client, delegate3);
                    return delegate3;
                }
            }
            if ((delegate = (WikiEventDelegate)this.m_delegates.get(client)) == null) {
                delegate = new WikiEventDelegate(client);
                this.m_delegates.put(client, delegate);
            }
            return delegate;
        }
    }

    private static class WikiEventListenerComparator
    implements Comparator {
        private WikiEventListenerComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof WikiEventListener && arg1 instanceof WikiEventListener) {
                WikiEventListener w1 = (WikiEventListener)arg1;
                WikiEventListener w0 = (WikiEventListener)arg0;
                if (w1 == w0 || w0.equals(w1)) {
                    return 0;
                }
                return w1.hashCode() - w0.hashCode();
            }
            throw new ClassCastException(arg1.getClass().getName() + " != " + arg0.getClass().getName());
        }
    }

    private static final class WikiEventDelegate {
        private ArrayList m_listenerList = new ArrayList();
        private Class m_class = null;

        protected WikiEventDelegate(Object client) {
            if (client instanceof Class) {
                this.m_class = (Class)client;
            }
        }

        protected Class getClientClass() {
            return this.m_class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set getWikiEventListeners() {
            ArrayList arrayList = this.m_listenerList;
            synchronized (arrayList) {
                TreeSet<WikiEventListener> set = new TreeSet<WikiEventListener>(new WikiEventListenerComparator());
                Iterator i = this.m_listenerList.iterator();
                while (i.hasNext()) {
                    WikiEventListener l = (WikiEventListener)((WeakReference)i.next()).get();
                    if (l == null) continue;
                    set.add(l);
                }
                return Collections.unmodifiableSet(set);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addWikiEventListener(WikiEventListener listener) {
            ArrayList arrayList = this.m_listenerList;
            synchronized (arrayList) {
                return this.m_listenerList.add(new WeakReference<WikiEventListener>(listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeWikiEventListener(WikiEventListener listener) {
            ArrayList arrayList = this.m_listenerList;
            synchronized (arrayList) {
                Iterator i = this.m_listenerList.iterator();
                while (i.hasNext()) {
                    WikiEventListener l = (WikiEventListener)((WeakReference)i.next()).get();
                    if (l != listener) continue;
                    i.remove();
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isListening() {
            ArrayList arrayList = this.m_listenerList;
            synchronized (arrayList) {
                return !this.m_listenerList.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireEvent(WikiEvent event) {
            boolean needsCleanup = false;
            try {
                ArrayList arrayList = this.m_listenerList;
                synchronized (arrayList) {
                    int i;
                    for (i = 0; i < this.m_listenerList.size(); ++i) {
                        WikiEventListener listener = (WikiEventListener)((WeakReference)this.m_listenerList.get(i)).get();
                        if (listener != null) {
                            listener.actionPerformed(event);
                            continue;
                        }
                        needsCleanup = true;
                    }
                    if (needsCleanup) {
                        for (i = 0; i < this.m_listenerList.size(); ++i) {
                            WeakReference w = (WeakReference)this.m_listenerList.get(i);
                            if (w.get() != null) continue;
                            this.m_listenerList.remove(i--);
                        }
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                log.info((Object)"Concurrent modification of event list; please report this.", (Throwable)e);
            }
        }
    }
}

