/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.event;

import com.ecyrd.jspwiki.event.WikiEvent;
import java.security.Principal;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class WikiSecurityEvent
extends WikiEvent {
    private static final long serialVersionUID = -6751950399721334496L;
    public static final int LOGIN_INITIATED = 30;
    public static final int LOGIN_ANONYMOUS = 31;
    public static final int LOGIN_ASSERTED = 32;
    public static final int LOGIN_AUTHENTICATED = 40;
    public static final int LOGIN_ACCOUNT_EXPIRED = 41;
    public static final int LOGIN_CREDENTIAL_EXPIRED = 42;
    public static final int LOGIN_FAILED = 43;
    public static final int LOGOUT = 44;
    public static final int SESSION_EXPIRED = 45;
    public static final int GROUP_ADD = 46;
    public static final int GROUP_REMOVE = 47;
    public static final int GROUP_CLEAR_GROUPS = 48;
    public static final int ACCESS_ALLOWED = 51;
    public static final int ACCESS_DENIED = 52;
    public static final int PROFILE_SAVE = 53;
    public static final int PROFILE_NAME_CHANGED = 54;
    protected static final Logger log = Logger.getLogger((String)"SecurityLog");
    private final Principal m_principal;
    private final Object m_target;
    private static final int[] ERROR_EVENTS = new int[]{43};
    private static final int[] WARN_EVENTS = new int[]{41, 42};
    private static final int[] INFO_EVENTS = new int[]{40, 45, 44, 54};

    public WikiSecurityEvent(Object src, int type, Principal principal, Object target) {
        super(src, type);
        if (src == null) {
            throw new IllegalArgumentException("Argument(s) cannot be null.");
        }
        this.m_principal = principal;
        this.m_target = target;
        if (log.isEnabledFor((Priority)Level.ERROR) && ArrayUtils.contains((int[])ERROR_EVENTS, (int)type)) {
            log.error((Object)this);
        } else if (log.isEnabledFor((Priority)Level.WARN) && ArrayUtils.contains((int[])WARN_EVENTS, (int)type)) {
            log.warn((Object)this);
        } else if (log.isEnabledFor((Priority)Level.INFO) && ArrayUtils.contains((int[])INFO_EVENTS, (int)type)) {
            log.info((Object)this);
        }
        log.debug((Object)this);
    }

    public WikiSecurityEvent(Object src, int type, Object target) {
        this(src, type, null, target);
    }

    public final Object getPrincipal() {
        return this.m_principal;
    }

    public final Object getTarget() {
        return this.m_target;
    }

    public final String toString() {
        StringBuffer msg = new StringBuffer();
        msg.append("WikiSecurityEvent.");
        msg.append(this.eventName(this.getType()));
        msg.append(" [source=" + this.getSource().toString());
        if (this.m_principal != null) {
            msg.append(", princpal=" + this.m_principal.getClass().getName());
            msg.append(" " + this.m_principal.getName());
        }
        msg.append(", target=" + this.m_target);
        msg.append("]");
        return msg.toString();
    }

    public final String eventName(int type) {
        switch (type) {
            case 40: {
                return "LOGIN_AUTHENTICATED";
            }
            case 41: {
                return "LOGIN_ACCOUNT_EXPIRED";
            }
            case 42: {
                return "LOGIN_ACCOUNT_EXPIRED";
            }
            case 43: {
                return "LOGIN_FAILED";
            }
            case 44: {
                return "LOGOUT";
            }
            case 45: {
                return "SESSION_EXPIRED";
            }
            case 46: {
                return "GROUP_ADD";
            }
            case 47: {
                return "GROUP_REMOVE";
            }
            case 48: {
                return "GROUP_CLEAR_GROUPS";
            }
            case 51: {
                return "ACCESS_ALLOWED";
            }
            case 52: {
                return "ACCESS_DENIED";
            }
            case 54: {
                return "PROFILE_NAME_CHANGED";
            }
            case 53: {
                return "PROFILE_SAVE";
            }
        }
        return super.eventName();
    }

    public final String getTypeDescription() {
        switch (this.getType()) {
            case 40: {
                return "login authenticated";
            }
            case 41: {
                return "login failed: expired account";
            }
            case 42: {
                return "login failed: credential expired";
            }
            case 43: {
                return "login failed";
            }
            case 44: {
                return "user logged out";
            }
            case 45: {
                return "session expired";
            }
            case 46: {
                return "new group added";
            }
            case 47: {
                return "group removed";
            }
            case 48: {
                return "all groups cleared";
            }
            case 51: {
                return "access allowed";
            }
            case 52: {
                return "access denied";
            }
            case 54: {
                return "user profile name changed";
            }
            case 53: {
                return "user profile saved";
            }
        }
        return super.getTypeDescription();
    }
}

