/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.forms;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.forms.FormElement;
import com.ecyrd.jspwiki.forms.FormInfo;
import com.ecyrd.jspwiki.plugin.PluginException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;

public class FormSelect
extends FormElement {
    public String execute(WikiContext ctx, Map params) throws PluginException {
        FormInfo info = this.getFormInfo(ctx);
        ResourceBundle rb = ctx.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
        HashMap previousValues = null;
        if (info != null) {
            if (info.hide()) {
                return "<p>" + rb.getString("forminput.noneedtoshow") + "</p>";
            }
            previousValues = info.getSubmission();
        }
        if (previousValues == null) {
            previousValues = new HashMap();
        }
        select field = null;
        field = this.buildSelect(params, previousValues, rb);
        if (field != null) {
            return field.toString(ctx.getEngine().getContentEncoding());
        }
        return "";
    }

    private select buildSelect(Map pluginParams, Map ctxValues, ResourceBundle rb) throws PluginException {
        String[] options;
        String optionSelector;
        String inputName = (String)pluginParams.get("name");
        if (inputName == null) {
            throw new PluginException(rb.getString("formselect.namemissing"));
        }
        String inputValue = (String)pluginParams.get("value");
        String previousValue = (String)ctxValues.get(inputName);
        String optionSeparator = (String)pluginParams.get("separator");
        if (optionSeparator == null) {
            optionSeparator = (String)ctxValues.get("separator." + inputName);
        }
        if (optionSeparator == null) {
            optionSeparator = (String)ctxValues.get("select.separator");
        }
        if (optionSeparator == null) {
            optionSeparator = ";";
        }
        if ((optionSelector = (String)pluginParams.get("selector")) == null) {
            optionSelector = (String)ctxValues.get("selector." + inputName);
        }
        if (optionSelector == null) {
            optionSelector = (String)ctxValues.get("select.selector");
        }
        if (optionSelector == null) {
            optionSelector = "*";
        }
        if (optionSelector.equals(optionSeparator)) {
            optionSelector = null;
        }
        if (inputValue == null) {
            inputValue = "";
        }
        boolean contextValueOverride = false;
        if (previousValue != null) {
            if (previousValue.indexOf(optionSeparator) != -1) {
                inputValue = previousValue;
                previousValue = null;
            } else {
                contextValueOverride = true;
            }
        }
        if ((options = inputValue.split(optionSeparator)) == null) {
            options = new String[]{};
        }
        int previouslySelected = -1;
        option[] optionElements = new option[options.length];
        for (int i = 0; i < options.length; ++i) {
            int indicated = -1;
            options[i] = options[i].trim();
            if (options[i].startsWith(optionSelector)) {
                options[i] = options[i].substring(optionSelector.length());
                indicated = i;
            }
            if (previouslySelected == -1) {
                if (!contextValueOverride && indicated > 0) {
                    previouslySelected = indicated;
                } else if (previousValue != null && options[i].equals(previousValue)) {
                    previouslySelected = i;
                }
            }
            optionElements[i] = new option(options[i]);
            optionElements[i].addElement(options[i]);
        }
        if (previouslySelected > -1) {
            optionElements[previouslySelected].setSelected(true);
        }
        select field = new select("nbf_" + inputName, optionElements);
        return field;
    }
}

