/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.parser;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreoleToJSPWikiTranslator {
    public static String VAR_VERSION = "1.0.3";
    public static String VAR_CREOLE_VERSION = "1.0";
    public static String VAR_LINEBREAK_BLOGLIKE = "bloglike";
    public static String VAR_LINEBREAK_C2LIKE = "c2like";
    private static final String CREOLE_BOLD = "\\*\\*((?s:.)*?)(\\*\\*|(\n\n|\r\r|\r\n\r\n))";
    private static final String JSPWIKI_BOLD = "__$1__$3";
    private static final String CREOLE_ITALIC = "//((?s:.)*?)(//|(\n\n|\r\r|\r\n\r\n))";
    private static final String JSPWIKI_ITALIC = "''$1''$3";
    private static final String CREOLE_SIMPLELINK = "\\[\\[([^\\]]*?)\\]\\]";
    private static final String JSPWIKI_SIMPLELINK = "[$1]";
    private static final String CREOLE_LINK = "\\[\\[([^\\]]*?)\\|([^\\[\\]]*?)\\]\\]";
    private static final String JSPWIKI_LINK = "[$2|$1]";
    private static final String CREOLE_HEADER_0 = "(\n|\r|\r\n|^)=([^=\\r\\n]*)={0,2}";
    private static final String JSPWIKI_HEADER_0 = "$1!!!$2";
    private static final String CREOLE_HEADER_1 = "(\n|\r|\r\n|^)==([^=\\r\\n]*)={0,2}";
    private static final String JSPWIKI_HEADER_1 = "$1!!!$2";
    private static final String CREOLE_HEADER_2 = "(\n|\r|\r\n|^)===([^=\\r\\n]*)={0,3}";
    private static final String JSPWIKI_HEADER_2 = "$1!!$2";
    private static final String CREOLE_HEADER_3 = "(\n|\r|\r\n|^)====([^=\\r\\n]*)={0,4}";
    private static final String JSPWIKI_HEADER_3 = "$1!$2";
    private static final String CREOLE_HEADER_4 = "(\n|\r|\r\n|^)=====([^=\\r\\n]*)={0,5}";
    private static final String JSPWIKI_HEADER_4 = "$1__$2__";
    private static final String CREOLE_SIMPLEIMAGE = "\\{\\{([^\\}]*?)\\}\\}";
    private static final String JSPWIKI_SIMPLEIMAGE = "[{Image src='$1'}]";
    private static final String CREOLE_IMAGE = "\\{\\{([^\\}]*?)\\|([^\\}]*?)\\}\\}";
    private static final String JSPWIKI_IMAGE = "[{Image src='$1' caption='$2'}]";
    private static final String CREOLE_IMAGE_LINK = "\\[\\[(.*?)\\|\\{\\{(.*?)\\}\\}\\]\\]";
    private static final String JSPWIKI_IMAGE_LINK = "[{Image src='$2' link='$1'}]";
    private static final String CREOLE_IMAGE_LINK_DESC = "\\[\\[(.*?)\\|\\{\\{(.*?)\\|(.*?)\\}\\}\\]\\]";
    private static final String JSPWIKI_IMAGE_LINK_DESC = "[{Image src='$2' link='$1' caption='$3'}]";
    private static final String PREFORMATTED_PROTECTED = "\\Q{{{\\E.*?\\Q}}}\\E";
    private static final String CREOLE_TABLE = "(\n|\r|\r\n|^)(\\|[^\n\r]*)\\|(\\t| )*(\n|\r|\r\n|$)";
    private static final String CREOLE_PLUGIN = "\\<\\<((?s:.)*?)\\>\\>";
    private static final String JSPWIKI_PLUGIN = "[{$1}]";
    private static final String WWW_URL = "(\\[\\[)\\s*(www\\..*?)(\\]\\])";
    private static final String HTTP_URL = "$1http://$2$3";
    private static final String CREOLE_IMAGE_X = "\\{\\{(.*?)((\\|)(.*?)){0,1}((\\|)(.*?)){0,1}\\}\\}";
    private static final String JSPWIKI_IMAGE_X = "[{\u2016 src='$1' caption='$4' \u2015}]";
    private static final String CREOLE_LINK_IMAG_X = "\\[\\[(.*?)\\|\\{\\{(.*?)((\\|)(.*?)){0,1}((\\|)(.*?)){0,1}\\}\\}\\]\\]";
    private static final String JSPWIKI_LINK_IMAGE_X = "[{\u2016 src='$2' link='$1' caption='$5' \u2015}]";
    private static final String JSPWIKI_TABLE = "$1$2$4";
    private static final String URL_PROTECTED = "http://|ftp://|https://";
    private static final String TABLE_HEADER_PROTECTED = "((\n|\r|\r\n|^)(\\|.*?)(\n|\r|\r\n|$))";
    private static final String SIGNATURE = "--~~~";
    private static final String SIGNATURE_AND_DATE = "--~~~~";
    private static final String DEFAULT_DATEFORMAT = "yyyy-MM-dd";
    private static final String ESCAPE_PROTECTED = "~(\\*\\*|~|//|-|#|\\{\\{|}}|\\\\|~\\[~~[|]]|----|=|\\|)";
    private static Map c_protectionMap = new HashMap();
    private ArrayList m_hashList = new ArrayList();

    public String translateSignature(Properties wikiProps, String content, String username) {
        String dateFormat = wikiProps.getProperty("creole.dateFormat");
        if (dateFormat == null) {
            dateFormat = DEFAULT_DATEFORMAT;
        }
        SimpleDateFormat df = null;
        try {
            df = new SimpleDateFormat(dateFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
            df = new SimpleDateFormat(DEFAULT_DATEFORMAT);
        }
        String result = content;
        result = this.protectMarkup(result, PREFORMATTED_PROTECTED, "", "");
        result = this.protectMarkup(result, URL_PROTECTED, "", "");
        Calendar cal = Calendar.getInstance();
        result = this.translateElement(result, SIGNATURE_AND_DATE, "-- [[" + username + "]], " + df.format(cal.getTime()));
        result = this.translateElement(result, SIGNATURE, "-- [[" + username + "]]");
        result = this.unprotectMarkup(result, false);
        return result;
    }

    public String translate(Properties wikiProps, String content) {
        boolean blogLineBreaks = false;
        String imagePlugin = wikiProps.getProperty("creole.imagePlugin.name");
        String result = content;
        result = this.protectMarkup(result);
        result = CreoleToJSPWikiTranslator.translateLists(result, "*", "-", "Nothing");
        result = this.translateElement(result, CREOLE_BOLD, JSPWIKI_BOLD);
        result = this.translateElement(result, CREOLE_ITALIC, JSPWIKI_ITALIC);
        result = this.translateElement(result, WWW_URL, HTTP_URL);
        if (imagePlugin != null && !imagePlugin.equals("")) {
            result = this.replaceImageArea(wikiProps, result, CREOLE_LINK_IMAG_X, JSPWIKI_LINK_IMAGE_X, 6, imagePlugin);
            result = this.replaceImageArea(wikiProps, result, CREOLE_IMAGE_X, JSPWIKI_IMAGE_X, 5, imagePlugin);
        }
        result = this.translateElement(result, CREOLE_IMAGE_LINK_DESC, JSPWIKI_IMAGE_LINK_DESC);
        result = this.translateElement(result, CREOLE_IMAGE_LINK, JSPWIKI_IMAGE_LINK);
        result = this.translateElement(result, CREOLE_LINK, JSPWIKI_LINK);
        result = this.translateElement(result, CREOLE_SIMPLELINK, JSPWIKI_SIMPLELINK);
        result = this.translateElement(result, CREOLE_HEADER_4, JSPWIKI_HEADER_4);
        result = this.translateElement(result, CREOLE_HEADER_3, JSPWIKI_HEADER_3);
        result = this.translateElement(result, CREOLE_HEADER_2, JSPWIKI_HEADER_2);
        result = this.translateElement(result, CREOLE_HEADER_1, "$1!!!$2");
        result = this.translateElement(result, CREOLE_HEADER_0, "$1!!!$2");
        result = this.translateElement(result, CREOLE_IMAGE, JSPWIKI_IMAGE);
        result = CreoleToJSPWikiTranslator.translateLists(result, "-", "*", "#");
        result = this.translateElement(result, CREOLE_SIMPLEIMAGE, JSPWIKI_SIMPLEIMAGE);
        result = this.translateElement(result, CREOLE_TABLE, JSPWIKI_TABLE);
        result = this.replaceArea(result, TABLE_HEADER_PROTECTED, "\\|=([^\\|]*)=|\\|=([^\\|]*)", "||$1$2");
        result = this.unprotectMarkup(result, true);
        result = this.translateVariables(result, blogLineBreaks);
        return result;
    }

    private static String translateLists(String content, String sourceSymbol, String targetSymbol, String sourceSymbol2) {
        String[] lines = content.split("\n");
        StringBuffer result = new StringBuffer();
        int counter = 0;
        int inList = -1;
        for (int i = 0; i < lines.length; ++i) {
            int c;
            String line = lines[i];
            String actSourceSymbol = "";
            while ((line.startsWith(sourceSymbol) || line.startsWith(sourceSymbol2)) && (actSourceSymbol.equals("") || line.substring(0, 1).equals(actSourceSymbol))) {
                actSourceSymbol = line.substring(0, 1);
                line = line.substring(1, line.length());
                ++counter;
            }
            if (inList == -1 && counter != 1 || inList != -1 && inList + 1 < counter) {
                for (c = 0; c < counter; ++c) {
                    result.append(actSourceSymbol);
                }
                inList = -1;
            } else {
                for (c = 0; c < counter; ++c) {
                    if (actSourceSymbol.equals(sourceSymbol2)) {
                        result.append(sourceSymbol2);
                        continue;
                    }
                    result.append(targetSymbol);
                }
                inList = counter;
            }
            result.append(line);
            if (i < lines.length - 1) {
                result.append("\n");
            }
            counter = 0;
        }
        return result.toString();
    }

    private String translateVariables(String result, boolean blogLineBreaks) {
        result = result.replace("[{$creolepagefilter.version}]", VAR_VERSION);
        result = result.replace("[{$creolepagefilter.creoleversion}]", VAR_CREOLE_VERSION);
        String linebreaks = blogLineBreaks ? VAR_LINEBREAK_BLOGLIKE : VAR_LINEBREAK_C2LIKE;
        result = result.replace("[{$creolepagefilter.linebreak}]", linebreaks);
        return result;
    }

    private String unprotectMarkup(String content, boolean replacePlugins) {
        Object[] it = this.m_hashList.toArray();
        for (int i = it.length - 1; i >= 0; --i) {
            String hash = (String)it[i];
            String protectedMarkup = (String)c_protectionMap.get(hash);
            content = content.replace(hash, protectedMarkup);
            if (protectedMarkup.length() >= 3 && (protectedMarkup.length() <= 2 || protectedMarkup.substring(0, 3).equals("{{{")) || !replacePlugins) continue;
            content = this.translateElement(content, CREOLE_PLUGIN, JSPWIKI_PLUGIN);
        }
        return content;
    }

    private String protectMarkup(String content) {
        c_protectionMap.clear();
        this.m_hashList = new ArrayList();
        content = this.protectMarkup(content, PREFORMATTED_PROTECTED, "", "");
        content = this.protectMarkup(content, URL_PROTECTED, "", "");
        content = this.protectMarkup(content, ESCAPE_PROTECTED, "", "");
        content = this.protectMarkup(content, CREOLE_PLUGIN, "", "");
        return content;
    }

    private ArrayList readPlaceholderProperties(Properties wikiProps) {
        Set<Object> keySet = wikiProps.keySet();
        Object[] keys = keySet.toArray();
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i] + "";
            String value = wikiProps.getProperty(keys[i] + "");
            if (key.indexOf("creole.imagePlugin.para.%") <= -1) continue;
            String[] pair = new String[]{key.replaceAll("creole.imagePlugin.para.%", ""), value};
            result.add(pair);
        }
        return result;
    }

    private String replaceImageArea(Properties wikiProps, String content, String markupRegex, String replaceContent, int groupPos, String imagePlugin) {
        Matcher matcher = Pattern.compile(markupRegex, 40).matcher(content);
        String contentCopy = content;
        ArrayList plProperties = this.readPlaceholderProperties(wikiProps);
        while (matcher.find()) {
            String protectedMarkup = matcher.group(0);
            String paramsField = matcher.group(groupPos);
            String paramsString = "";
            if (paramsField != null) {
                String[] params = paramsField.split(",");
                for (int i = 0; i < params.length; ++i) {
                    String param = params[i].replaceAll("\\||\\s", "").toUpperCase();
                    for (int j = 0; j < plProperties.size(); ++j) {
                        String[] pair = (String[])plProperties.get(j);
                        String key = pair[0];
                        String value = pair[1];
                        String code = param.replaceAll("(?i)([0-9]+)" + key, value + "<check>" + "$1" + "</check>");
                        if ((code = code.replaceAll("(.*?)%(.*?)<check>(.*?)</check>", "$1$3$2")).equals(param)) continue;
                        paramsString = paramsString + code;
                    }
                    try {
                        Integer.parseInt(param);
                        paramsString = paramsString + " width='" + param + "px'";
                        continue;
                    }
                    catch (Exception e) {
                        if (wikiProps.getProperty("creole.imagePlugin.para." + param) == null) continue;
                        paramsString = paramsString + " " + wikiProps.getProperty("creole.imagePlugin.para." + param).replaceAll("^(\"|')(.*)(\"|')$", "$2");
                    }
                }
            }
            String temp = protectedMarkup;
            protectedMarkup = this.translateElement(protectedMarkup, markupRegex, replaceContent);
            protectedMarkup = protectedMarkup.replaceAll("\u2015", paramsString);
            protectedMarkup = protectedMarkup.replaceAll("\u2016", imagePlugin);
            protectedMarkup = protectedMarkup.replaceAll("caption=''", "");
            protectedMarkup = protectedMarkup.replaceAll("\\s+", " ");
            int pos = contentCopy.indexOf(temp);
            contentCopy = contentCopy.substring(0, pos) + protectedMarkup + contentCopy.substring(pos + temp.length(), contentCopy.length());
        }
        return contentCopy;
    }

    private String replaceArea(String content, String markupRegex, String replaceSource, String replaceTarget) {
        Matcher matcher = Pattern.compile(markupRegex, 40).matcher(content);
        String contentCopy = content;
        while (matcher.find()) {
            String protectedMarkup;
            String temp = protectedMarkup = matcher.group(0);
            protectedMarkup = protectedMarkup.replaceAll(replaceSource, replaceTarget);
            int pos = contentCopy.indexOf(temp);
            contentCopy = contentCopy.substring(0, pos) + protectedMarkup + contentCopy.substring(pos + temp.length(), contentCopy.length());
        }
        return contentCopy;
    }

    private String protectMarkup(String content, String markupRegex, String replaceSource, String replaceTarget) {
        Matcher matcher = Pattern.compile(markupRegex, 40).matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String protectedMarkup = matcher.group();
            protectedMarkup = protectedMarkup.replaceAll(replaceSource, replaceTarget);
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.reset();
                digest.update(protectedMarkup.getBytes("UTF-8"));
                String hash = this.bytesToHash(digest.digest());
                matcher.appendReplacement(result, hash);
                c_protectionMap.put(hash, protectedMarkup);
                this.m_hashList.add(hash);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String bytesToHash(byte[] b) {
        String hash = "";
        for (int i = 0; i < b.length; ++i) {
            hash = hash + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return hash;
    }

    private String translateElement(String content, String fromMarkup, String toMarkup) {
        Matcher matcher = Pattern.compile(fromMarkup, 8).matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, toMarkup);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

