/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.parser;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.StringTransmutator;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.VariableManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.acl.Acl;
import com.ecyrd.jspwiki.parser.Heading;
import com.ecyrd.jspwiki.parser.HeadingListener;
import com.ecyrd.jspwiki.parser.LinkParser;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.parser.ParseException;
import com.ecyrd.jspwiki.parser.PluginContent;
import com.ecyrd.jspwiki.parser.VariableContent;
import com.ecyrd.jspwiki.parser.WikiDocument;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.PluginManager;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.render.CleanTextRenderer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.ProcessingInstruction;
import org.jdom.Verifier;

public class JSPWikiMarkupParser
extends MarkupParser {
    private static final String OUTLINK_IMAGE = "images/out.png";
    public static final String CLASS_WIKIPAGE = "wikipage";
    public static final String CLASS_EDITPAGE = "createpage";
    public static final String CLASS_INTERWIKI = "interwiki";
    protected static final int READ = 0;
    protected static final int EDIT = 1;
    protected static final int EMPTY = 2;
    protected static final int LOCAL = 3;
    protected static final int LOCALREF = 4;
    protected static final int IMAGE = 5;
    protected static final int EXTERNAL = 6;
    protected static final int INTERWIKI = 7;
    protected static final int IMAGELINK = 8;
    protected static final int IMAGEWIKILINK = 9;
    protected static final int ATTACHMENT = 10;
    private static Logger log = Logger.getLogger((Class)JSPWikiMarkupParser.class);
    private boolean m_isbold = false;
    private boolean m_isitalic = false;
    private boolean m_istable = false;
    private boolean m_isPre = false;
    private boolean m_isEscaping = false;
    private boolean m_isdefinition = false;
    private boolean m_isPreBlock = false;
    private Stack m_styleStack = new Stack();
    private int m_genlistlevel = 0;
    private StringBuffer m_genlistBulletBuffer = new StringBuffer(10);
    private boolean m_allowPHPWikiStyleLists = true;
    private boolean m_isOpenParagraph = false;
    private List m_inlineImagePatterns;
    private LinkParser m_linkParser = new LinkParser();
    private PatternMatcher m_inlineMatcher = new Perl5Matcher();
    private StringBuffer m_plainTextBuf = new StringBuffer(20);
    private Element m_currentElement;
    public static final String PROP_INLINEIMAGEPTRN = "jspwiki.translatorReader.inlinePattern";
    public static final String PROP_CAMELCASELINKS = "jspwiki.translatorReader.camelCaseLinks";
    public static final String PROP_PLAINURIS = "jspwiki.translatorReader.plainUris";
    public static final String PROP_USEOUTLINKIMAGE = "jspwiki.translatorReader.useOutlinkImage";
    public static final String PROP_USEATTACHMENTIMAGE = "jspwiki.translatorReader.useAttachmentImage";
    public static final String PROP_USERELNOFOLLOW = "jspwiki.translatorReader.useRelNofollow";
    private boolean m_camelCaseLinks = false;
    private boolean m_wysiwygEditorMode = false;
    private boolean m_plainUris = false;
    private boolean m_useOutlinkImage = true;
    private boolean m_useAttachmentImage = true;
    private boolean m_allowHTML = false;
    private boolean m_useRelNofollow = false;
    private PatternCompiler m_compiler = new Perl5Compiler();
    static final String WIKIWORD_REGEX = "(^|[[:^alnum:]]+)([[:upper:]]+[[:lower:]]+[[:upper:]]+[[:alnum:]]*|(http://|https://|mailto:)([A-Za-z0-9_/\\.\\+\\?\\#\\-\\@=&;~%]+))";
    private PatternMatcher m_camelCaseMatcher = new Perl5Matcher();
    private Pattern m_camelCasePattern;
    private int m_rowNum = 1;
    public static final String DEFAULT_INLINEPATTERN = "*.png";
    static final String[] c_externalLinks = new String[]{"http:", "ftp:", "https:", "mailto:", "news:", "file:", "rtsp:", "mms:", "ldap:", "gopher:", "nntp:", "telnet:", "wais:", "prospero:", "z39.50s", "z39.50r", "vemmi:", "imap:", "nfs:", "acap:", "tip:", "pop:", "dav:", "opaquelocktoken:", "sip:", "sips:", "tel:", "fax:", "modem:", "soap.beep:", "soap.beeps", "xmlrpc.beep", "xmlrpc.beeps", "urn:", "go:", "h323:", "ipp:", "tftp:", "mupdate:", "pres:", "im:", "mtqp", "smb:"};
    private static final String INLINE_IMAGE_PATTERNS = "JSPWikiMarkupParser.inlineImagePatterns";
    private static final String CAMELCASE_PATTERN = "JSPWikiMarkupParser.camelCasePattern";
    private static final String[] CLASS_TYPES = new String[]{"wikipage", "createpage", "", "footnote", "footnoteref", "", "external", "interwiki", "external", "wikipage", "attachment"};
    private static Comparator c_startingComparator = new StartingComparator();
    private static final String[] BLOCK_ELEMENTS;
    private static final String[] EMPTY_ELEMENTS;
    private JSPWikiMarkupParser m_cleanTranslator;
    private String m_outlinkImageURL = null;
    private boolean m_restartitalic = false;
    private boolean m_restartbold = false;
    private boolean m_newLine;
    public static final int CHARACTER = 0;
    public static final int ELEMENT = 1;
    public static final int IGNORE = 2;

    public JSPWikiMarkupParser(WikiContext context, Reader in) {
        super(context, in);
        this.initialize();
    }

    private void initialize() {
        GlobCompiler compiler = new GlobCompiler();
        ArrayList<Pattern> compiledpatterns = (ArrayList<Pattern>)this.m_engine.getAttribute(INLINE_IMAGE_PATTERNS);
        if (compiledpatterns == null) {
            compiledpatterns = new ArrayList<Pattern>(20);
            Collection ptrns = JSPWikiMarkupParser.getImagePatterns(this.m_engine);
            Iterator i = ptrns.iterator();
            while (i.hasNext()) {
                try {
                    compiledpatterns.add(compiler.compile((String)i.next(), 8));
                }
                catch (MalformedPatternException e) {
                    log.error((Object)"Malformed pattern in properties: ", (Throwable)e);
                }
            }
            this.m_engine.setAttribute(INLINE_IMAGE_PATTERNS, compiledpatterns);
        }
        this.m_inlineImagePatterns = Collections.unmodifiableList(compiledpatterns);
        this.m_camelCasePattern = (Pattern)this.m_engine.getAttribute(CAMELCASE_PATTERN);
        if (this.m_camelCasePattern == null) {
            try {
                this.m_camelCasePattern = this.m_compiler.compile(WIKIWORD_REGEX, 32768);
            }
            catch (MalformedPatternException e) {
                log.fatal((Object)"Internal error: Someone put in a faulty pattern.", (Throwable)e);
                throw new InternalWikiException("Faulty camelcasepattern in TranslatorReader");
            }
            this.m_engine.setAttribute(CAMELCASE_PATTERN, this.m_camelCasePattern);
        }
        Properties props = this.m_engine.getWikiProperties();
        String cclinks = (String)this.m_context.getPage().getAttribute(PROP_CAMELCASELINKS);
        this.m_camelCaseLinks = cclinks != null ? TextUtil.isPositive(cclinks) : TextUtil.getBooleanProperty(props, PROP_CAMELCASELINKS, this.m_camelCaseLinks);
        Boolean wysiwygVariable = (Boolean)this.m_context.getVariable("WYSIWYG_EDITOR_MODE");
        if (wysiwygVariable != null) {
            this.m_wysiwygEditorMode = wysiwygVariable;
        }
        this.m_plainUris = JSPWikiMarkupParser.getLocalBooleanProperty(this.m_context, props, PROP_PLAINURIS, this.m_plainUris);
        this.m_useOutlinkImage = JSPWikiMarkupParser.getLocalBooleanProperty(this.m_context, props, PROP_USEOUTLINKIMAGE, this.m_useOutlinkImage);
        this.m_useAttachmentImage = JSPWikiMarkupParser.getLocalBooleanProperty(this.m_context, props, PROP_USEATTACHMENTIMAGE, this.m_useAttachmentImage);
        this.m_allowHTML = JSPWikiMarkupParser.getLocalBooleanProperty(this.m_context, props, "jspwiki.translatorReader.allowHTML", this.m_allowHTML);
        this.m_useRelNofollow = JSPWikiMarkupParser.getLocalBooleanProperty(this.m_context, props, PROP_USERELNOFOLLOW, this.m_useRelNofollow);
        if (this.m_engine.getUserManager().getUserDatabase() == null || this.m_engine.getAuthorizationManager() == null) {
            this.disableAccessRules();
        }
        this.m_context.getPage().setHasMetadata();
    }

    private static boolean getLocalBooleanProperty(WikiContext context, Properties props, String key, boolean defValue) {
        Object bool = context.getVariable(key);
        if (bool != null) {
            return TextUtil.isPositive((String)bool);
        }
        return TextUtil.getBooleanProperty(props, key, defValue);
    }

    public static Collection getImagePatterns(WikiEngine engine) {
        Properties props = engine.getWikiProperties();
        ArrayList<String> ptrnlist = new ArrayList<String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(PROP_INLINEIMAGEPTRN)) continue;
            String ptrn = TextUtil.getStringProperty(props, name, null);
            ptrnlist.add(ptrn);
        }
        if (ptrnlist.size() == 0) {
            ptrnlist.add(DEFAULT_INLINEPATTERN);
        }
        return ptrnlist;
    }

    private String linkExists(String page) {
        try {
            if (page == null || page.length() == 0) {
                return null;
            }
            return this.m_engine.getFinalPageName(page);
        }
        catch (ProviderException e) {
            log.warn((Object)"TranslatorReader got a faulty page name!", (Throwable)e);
            return page;
        }
    }

    protected String callMutatorChain(Collection list, String text) {
        if (list == null || list.size() == 0) {
            return text;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            StringTransmutator m = (StringTransmutator)i.next();
            text = m.mutate(this.m_context, text);
        }
        return text;
    }

    protected void callHeadingListenerChain(Heading param) {
        ArrayList list = this.m_headingListenerChain;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            HeadingListener h = (HeadingListener)i.next();
            h.headingAdded(this.m_context, param);
        }
    }

    protected Element createAnchor(int type, String link, String text, String section) {
        text = this.escapeHTMLEntities(text);
        section = this.escapeHTMLEntities(section);
        Element el = new Element("a");
        el.setAttribute("class", CLASS_TYPES[type]);
        el.setAttribute("href", link + section);
        el.addContent(text);
        return el;
    }

    private Element makeLink(int type, String link, String text, String section, Iterator attributes) {
        Element el = null;
        if (text == null) {
            text = link;
        }
        text = this.callMutatorChain(this.m_linkMutators, text);
        String string = section = section != null ? "#" + section : "";
        if (link.length() == 0) {
            type = 2;
        }
        ResourceBundle rb = this.m_context.getBundle("CoreResources");
        Object[] args = new Object[]{link};
        switch (type) {
            case 0: {
                el = this.createAnchor(0, this.m_context.getURL(WikiContext.VIEW, link), text, section);
                break;
            }
            case 1: {
                el = this.createAnchor(1, this.m_context.getURL(WikiContext.EDIT, link), text, "");
                el.setAttribute("title", MessageFormat.format(rb.getString("markupparser.link.create"), args));
                break;
            }
            case 2: {
                el = new Element("u").addContent(text);
                break;
            }
            case 4: {
                el = this.createAnchor(4, "#ref-" + this.m_context.getName() + "-" + link, "[" + text + "]", "");
                break;
            }
            case 3: {
                el = new Element("a").setAttribute("class", "footnote");
                el.setAttribute("name", "ref-" + this.m_context.getName() + "-" + link.substring(1));
                el.addContent("[" + text + "]");
                break;
            }
            case 5: {
                el = new Element("img").setAttribute("class", "inline");
                el.setAttribute("src", link);
                el.setAttribute("alt", text);
                break;
            }
            case 8: {
                el = new Element("img").setAttribute("class", "inline");
                el.setAttribute("src", link);
                el.setAttribute("alt", text);
                el = this.createAnchor(8, text, "", "").addContent((Content)el);
                break;
            }
            case 9: {
                String pagelink = this.m_context.getURL(WikiContext.VIEW, text);
                el = new Element("img").setAttribute("class", "inline");
                el.setAttribute("src", link);
                el.setAttribute("alt", text);
                el = this.createAnchor(9, pagelink, "", "").addContent((Content)el);
                break;
            }
            case 6: {
                el = this.createAnchor(6, link, text, section);
                if (!this.m_useRelNofollow) break;
                el.setAttribute("rel", "nofollow");
                break;
            }
            case 7: {
                el = this.createAnchor(7, link, text, section);
                break;
            }
            case 10: {
                String attlink = this.m_context.getURL(WikiContext.ATTACH, link);
                String infolink = this.m_context.getURL(WikiContext.INFO, link);
                String imglink = this.m_context.getURL(WikiContext.NONE, "images/attachment_small.png");
                el = this.createAnchor(10, attlink, text, "");
                this.pushElement(el);
                this.popElement(el.getName());
                if (this.m_useAttachmentImage) {
                    el = new Element("img").setAttribute("src", imglink);
                    el.setAttribute("border", "0");
                    el.setAttribute("alt", "(info)");
                    el = new Element("a").setAttribute("href", infolink).addContent((Content)el);
                    break;
                }
                el = null;
                break;
            }
        }
        if (el != null && attributes != null) {
            while (attributes.hasNext()) {
                Attribute attr = (Attribute)attributes.next();
                if (attr == null) continue;
                el.setAttribute(attr);
            }
        }
        if (el != null) {
            this.flushPlainText();
            this.m_currentElement.addContent((Content)el);
        }
        return el;
    }

    public static boolean isExternalLink(String link) {
        int idx = Arrays.binarySearch(c_externalLinks, link, c_startingComparator);
        return idx >= 0 && link.startsWith(c_externalLinks[idx]);
    }

    private static boolean isAccessRule(String link) {
        return link.startsWith("{ALLOW") || link.startsWith("{DENY");
    }

    private boolean isImageLink(String link) {
        if (this.m_inlineImages) {
            link = link.toLowerCase();
            Iterator i = this.m_inlineImagePatterns.iterator();
            while (i.hasNext()) {
                if (!this.m_inlineMatcher.matches(link, (Pattern)i.next())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMetadata(String link) {
        return link.startsWith("{SET");
    }

    private static final boolean isBlockLevel(String name) {
        return Arrays.binarySearch(BLOCK_ELEMENTS, name) >= 0;
    }

    private String peekAheadLine() throws IOException {
        String s = this.readUntilEOL().toString();
        if (s.length() > 10240) {
            log.warn((Object)"Line is longer than maximum allowed size (10240 characters.  Attempting to recover...");
            this.pushBack(s.substring(0, 10239));
        } else {
            try {
                this.pushBack(s);
            }
            catch (IOException e) {
                log.warn((Object)"Pushback failed: the line is probably too long.  Attempting to recover.");
            }
        }
        return s;
    }

    public static Element makeError(String error) {
        return new Element("span").setAttribute("class", "error").addContent(error);
    }

    private int flushPlainText() {
        int numChars = this.m_plainTextBuf.length();
        if (numChars > 0) {
            String buf = !this.m_allowHTML ? this.escapeHTMLEntities(this.m_plainTextBuf.toString()) : this.m_plainTextBuf.toString();
            this.m_plainTextBuf = new StringBuffer(20);
            try {
                if (this.m_camelCaseLinks && !this.m_isEscaping && buf.length() > 3) {
                    while (this.m_camelCaseMatcher.contains(buf, this.m_camelCasePattern)) {
                        MatchResult result = this.m_camelCaseMatcher.getMatch();
                        String firstPart = buf.substring(0, result.beginOffset(0));
                        String prefix = result.group(1);
                        if (prefix == null) {
                            prefix = "";
                        }
                        String camelCase = result.group(2);
                        String protocol = result.group(3);
                        String uri = protocol + result.group(4);
                        buf = buf.substring(result.endOffset(0));
                        this.m_currentElement.addContent(firstPart);
                        if (prefix.endsWith("~") || prefix.indexOf(91) != -1) {
                            if (prefix.endsWith("~")) {
                                if (this.m_wysiwygEditorMode) {
                                    this.m_currentElement.addContent("~");
                                }
                                prefix = prefix.substring(0, prefix.length() - 1);
                            }
                            if (camelCase != null) {
                                this.m_currentElement.addContent(prefix + camelCase);
                                continue;
                            }
                            if (protocol == null) continue;
                            this.m_currentElement.addContent(prefix + uri);
                            continue;
                        }
                        if (protocol != null) {
                            char c = uri.charAt(uri.length() - 1);
                            if (c == '.' || c == ',') {
                                uri = uri.substring(0, uri.length() - 1);
                                buf = c + buf;
                            }
                            this.m_currentElement.addContent(prefix);
                            this.makeDirectURILink(uri);
                            continue;
                        }
                        this.m_currentElement.addContent(prefix);
                        this.makeCamelCaseLink(camelCase);
                    }
                    this.m_currentElement.addContent(buf);
                } else {
                    this.m_currentElement.addContent(buf);
                }
            }
            catch (IllegalDataException e) {
                this.m_currentElement.addContent((Content)JSPWikiMarkupParser.makeError(this.cleanupSuspectData(e.getMessage())));
            }
        }
        return numChars;
    }

    private String escapeHTMLEntities(String buf) {
        StringBuffer tmpBuf = new StringBuffer(buf.length() + 20);
        block0: for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (ch == '<') {
                tmpBuf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                tmpBuf.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                tmpBuf.append("&quot;");
                continue;
            }
            if (ch == '&') {
                int j;
                int n = j = i < buf.length() - 1 ? i + 1 : i;
                while (j < buf.length()) {
                    char ch2 = buf.charAt(j);
                    if (ch2 == ';') {
                        tmpBuf.append(ch);
                        continue block0;
                    }
                    if (ch2 != '#' && !Character.isLetterOrDigit(ch2)) {
                        tmpBuf.append("&amp;");
                        continue block0;
                    }
                    ++j;
                }
                continue;
            }
            tmpBuf.append(ch);
        }
        return tmpBuf.toString();
    }

    private Element pushElement(Element e) {
        this.flushPlainText();
        this.m_currentElement.addContent((Content)e);
        this.m_currentElement = e;
        return e;
    }

    private Element addElement(Content e) {
        if (e != null) {
            this.flushPlainText();
            this.m_currentElement.addContent(e);
        }
        return this.m_currentElement;
    }

    private Element popElement(String s) {
        int flushedBytes = this.flushPlainText();
        Element currEl = this.m_currentElement;
        while (currEl.getParentElement() != null) {
            if (currEl.getName().equals(s) && !currEl.isRootElement()) {
                this.m_currentElement = currEl.getParentElement();
                if (flushedBytes == 0 && Arrays.binarySearch(EMPTY_ELEMENTS, s) < 0) {
                    currEl.addContent("");
                }
                return this.m_currentElement;
            }
            currEl = currEl.getParentElement();
        }
        return null;
    }

    private String readUntil(String endChars) throws IOException {
        StringBuffer sb = new StringBuffer(80);
        int ch = this.nextToken();
        while (ch != -1) {
            if (ch == 92) {
                ch = this.nextToken();
                if (ch == -1) {
                    break;
                }
            } else if (endChars.indexOf((char)ch) != -1) {
                this.pushBack(ch);
                break;
            }
            sb.append((char)ch);
            ch = this.nextToken();
        }
        return sb.toString();
    }

    private String readWhile(String endChars) throws IOException {
        StringBuffer sb = new StringBuffer(80);
        int ch = this.nextToken();
        while (ch != -1) {
            if (endChars.indexOf((char)ch) == -1) {
                this.pushBack(ch);
                break;
            }
            sb.append((char)ch);
            ch = this.nextToken();
        }
        return sb.toString();
    }

    private JSPWikiMarkupParser getCleanTranslator() {
        if (this.m_cleanTranslator == null) {
            WikiContext dummyContext = new WikiContext(this.m_engine, this.m_context.getHttpRequest(), this.m_context.getPage());
            this.m_cleanTranslator = new JSPWikiMarkupParser(dummyContext, null);
            this.m_cleanTranslator.m_allowHTML = true;
        }
        return this.m_cleanTranslator;
    }

    private String makeHeadingAnchor(String baseName, String title, Heading hd) {
        hd.m_titleText = title;
        title = MarkupParser.wikifyLink(title);
        hd.m_titleSection = this.m_engine.encodeName(title);
        hd.m_titleAnchor = "section-" + this.m_engine.encodeName(baseName) + "-" + hd.m_titleSection;
        hd.m_titleAnchor = hd.m_titleAnchor.replace('%', '_');
        hd.m_titleAnchor = hd.m_titleAnchor.replace('/', '_');
        return hd.m_titleAnchor;
    }

    private String makeSectionTitle(String title) {
        String outTitle;
        title = title.trim();
        try {
            JSPWikiMarkupParser dtr = this.getCleanTranslator();
            dtr.setInputReader(new StringReader(title));
            CleanTextRenderer ctt = new CleanTextRenderer(this.m_context, dtr.parse());
            outTitle = ctt.getString();
        }
        catch (IOException e) {
            log.fatal((Object)"CleanTranslator not working", (Throwable)e);
            throw new InternalWikiException("CleanTranslator not working as expected, when cleaning title" + e.getMessage());
        }
        return outTitle;
    }

    public Element makeHeading(int level, String title, Heading hd) {
        Element el = null;
        String pageName = this.m_context.getPage().getName();
        String outTitle = this.makeSectionTitle(title);
        hd.m_level = level;
        switch (level) {
            case 1: {
                el = new Element("h4").setAttribute("id", this.makeHeadingAnchor(pageName, outTitle, hd));
                break;
            }
            case 2: {
                el = new Element("h3").setAttribute("id", this.makeHeadingAnchor(pageName, outTitle, hd));
                break;
            }
            case 3: {
                el = new Element("h2").setAttribute("id", this.makeHeadingAnchor(pageName, outTitle, hd));
                break;
            }
            default: {
                throw new InternalWikiException("Illegal heading type " + level);
            }
        }
        return el;
    }

    private Element makeCamelCaseLink(String wikiname) {
        this.callMutatorChain(this.m_localLinkMutatorChain, wikiname);
        String matchedLink = this.linkExists(wikiname);
        if (matchedLink != null) {
            this.makeLink(0, matchedLink, wikiname, null, null);
        } else {
            this.makeLink(1, wikiname, wikiname, null, null);
        }
        return this.m_currentElement;
    }

    private Element outlinkImage() {
        Element el = null;
        if (this.m_useOutlinkImage) {
            if (this.m_outlinkImageURL == null) {
                this.m_outlinkImageURL = this.m_context.getURL(WikiContext.NONE, OUTLINK_IMAGE);
            }
            el = new Element("img").setAttribute("class", "outlink");
            el.setAttribute("src", this.m_outlinkImageURL);
            el.setAttribute("alt", "");
        }
        return el;
    }

    private Element makeDirectURILink(String url) {
        Element result;
        String last = null;
        if (url.endsWith(",") || url.endsWith(".")) {
            last = url.substring(url.length() - 1);
            url = url.substring(0, url.length() - 1);
        }
        this.callMutatorChain(this.m_externalLinkMutatorChain, url);
        if (this.isImageLink(url)) {
            result = this.handleImageLink(StringUtils.replace((String)url, (String)"&amp;", (String)"&"), url, false);
        } else {
            result = this.makeLink(6, StringUtils.replace((String)url, (String)"&amp;", (String)"&"), url, null, null);
            this.addElement((Content)this.outlinkImage());
        }
        if (last != null) {
            this.m_plainTextBuf.append(last);
        }
        return result;
    }

    private Element handleImageLink(String reallink, String link, boolean hasLinkText) {
        String possiblePage = MarkupParser.cleanLink(link);
        if (JSPWikiMarkupParser.isExternalLink(link) && hasLinkText) {
            return this.makeLink(8, reallink, link, null, null);
        }
        if (this.linkExists(possiblePage) != null && hasLinkText) {
            this.callMutatorChain(this.m_localLinkMutatorChain, possiblePage);
            return this.makeLink(9, reallink, link, null, null);
        }
        return this.makeLink(5, reallink, link, null, null);
    }

    private Element handleAccessRule(String ruleLine) {
        if (this.m_wysiwygEditorMode) {
            this.m_currentElement.addContent("[" + ruleLine + "]");
        }
        if (!this.m_parseAccessRules) {
            return this.m_currentElement;
        }
        WikiPage page = this.m_context.getPage();
        if (ruleLine.startsWith("{")) {
            ruleLine = ruleLine.substring(1);
        }
        if (ruleLine.endsWith("}")) {
            ruleLine = ruleLine.substring(0, ruleLine.length() - 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("page=" + page.getName() + ", ACL = " + ruleLine));
        }
        try {
            Acl acl = this.m_engine.getAclManager().parseAcl(page, ruleLine);
            page.setAcl(acl);
            if (log.isDebugEnabled()) {
                log.debug((Object)((Object)acl).toString());
            }
        }
        catch (WikiSecurityException wse) {
            return JSPWikiMarkupParser.makeError(wse.getMessage());
        }
        return this.m_currentElement;
    }

    private Element handleMetadata(String link) {
        if (this.m_wysiwygEditorMode) {
            this.m_currentElement.addContent("[" + link + "]");
        }
        try {
            String args = link.substring(link.indexOf(32), link.length() - 1);
            String name = args.substring(0, args.indexOf(61));
            String val = args.substring(args.indexOf(61) + 1, args.length());
            name = name.trim();
            val = val.trim();
            if (val.startsWith("'")) {
                val = val.substring(1);
            }
            if (val.endsWith("'")) {
                val = val.substring(0, val.length() - 1);
            }
            if (name.length() > 0 && val.length() > 0) {
                val = this.m_engine.getVariableManager().expandVariables(this.m_context, val);
                this.m_context.getPage().setAttribute(name, val);
            }
        }
        catch (Exception e) {
            ResourceBundle rb = this.m_context.getBundle("CoreResources");
            Object[] args = new Object[]{link};
            return JSPWikiMarkupParser.makeError(MessageFormat.format(rb.getString("markupparser.error.invalidset"), args));
        }
        return this.m_currentElement;
    }

    private void disableOutputEscaping() {
        this.addElement((Content)new ProcessingInstruction("javax.xml.transform.disable-output-escaping", ""));
    }

    private Element handleHyperlinks(String linktext, int pos) {
        ResourceBundle rb = this.m_context.getBundle("CoreResources");
        StringBuffer sb = new StringBuffer(linktext.length() + 80);
        if (JSPWikiMarkupParser.isAccessRule(linktext)) {
            return this.handleAccessRule(linktext);
        }
        if (JSPWikiMarkupParser.isMetadata(linktext)) {
            return this.handleMetadata(linktext);
        }
        if (PluginManager.isPluginLink(linktext)) {
            block36: {
                try {
                    PluginContent pluginContent = this.m_engine.getPluginManager().parsePluginLine(this.m_context, linktext, pos);
                    this.addElement((Content)pluginContent);
                    pluginContent.executeParse(this.m_context);
                }
                catch (PluginException e) {
                    log.info((Object)("Failed to insert plugin: " + e.getMessage()));
                    if (this.m_wysiwygEditorMode) break block36;
                    ResourceBundle rbPlugin = this.m_context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
                    Object[] args = new Object[]{e.getMessage()};
                    return this.addElement((Content)JSPWikiMarkupParser.makeError(MessageFormat.format(rbPlugin.getString("plugin.error.insertionfailed"), args)));
                }
            }
            return this.m_currentElement;
        }
        try {
            LinkParser.Link link = this.m_linkParser.parse(linktext);
            linktext = link.getText();
            String linkref = link.getReference();
            if (VariableManager.isVariableLink(linktext)) {
                VariableContent el = new VariableContent(linktext);
                this.addElement((Content)el);
            } else if (JSPWikiMarkupParser.isExternalLink(linkref)) {
                this.callMutatorChain(this.m_externalLinkMutatorChain, linkref);
                if (this.isImageLink(linkref)) {
                    this.handleImageLink(linkref, linktext, link.hasReference());
                } else {
                    this.makeLink(6, linkref, linktext, null, link.getAttributes());
                    this.addElement((Content)this.outlinkImage());
                }
            } else if (link.isInterwikiLink()) {
                String extWiki = link.getExternalWiki();
                String wikiPage = link.getExternalWikiPage();
                if (this.m_wysiwygEditorMode) {
                    this.makeLink(7, extWiki + ":" + wikiPage, linktext, null, link.getAttributes());
                } else {
                    String urlReference = this.m_engine.getInterWikiURL(extWiki);
                    if (urlReference != null) {
                        urlReference = TextUtil.replaceString(urlReference, "%s", wikiPage);
                        if (this.isImageLink(urlReference = this.callMutatorChain(this.m_externalLinkMutatorChain, urlReference))) {
                            this.handleImageLink(urlReference, linktext, link.hasReference());
                        } else {
                            this.makeLink(7, urlReference, linktext, null, link.getAttributes());
                        }
                        if (JSPWikiMarkupParser.isExternalLink(urlReference)) {
                            this.addElement((Content)this.outlinkImage());
                        }
                    } else {
                        Object[] args = new Object[]{extWiki};
                        this.addElement((Content)JSPWikiMarkupParser.makeError(MessageFormat.format(rb.getString("markupparser.error.nointerwikiref"), args)));
                    }
                }
            } else if (linkref.startsWith("#")) {
                this.makeLink(3, linkref, linktext, null, link.getAttributes());
            } else if (TextUtil.isNumber(linkref)) {
                this.makeLink(4, linkref, linktext, null, link.getAttributes());
            } else {
                int hashMark = -1;
                String attachment = this.findAttachment(linkref);
                if (attachment != null) {
                    this.callMutatorChain(this.m_attachmentLinkMutatorChain, attachment);
                    if (this.isImageLink(linkref)) {
                        attachment = this.m_context.getURL(WikiContext.ATTACH, attachment);
                        sb.append(this.handleImageLink(attachment, linktext, link.hasReference()));
                    } else {
                        this.makeLink(10, attachment, linktext, null, link.getAttributes());
                    }
                } else {
                    hashMark = linkref.indexOf(35);
                    if (hashMark != -1) {
                        String namedSection = linkref.substring(hashMark + 1);
                        linkref = linkref.substring(0, hashMark);
                        linkref = MarkupParser.cleanLink(linkref);
                        this.callMutatorChain(this.m_localLinkMutatorChain, linkref);
                        String matchedLink = this.linkExists(linkref);
                        if (matchedLink != null) {
                            String sectref = "section-" + this.m_engine.encodeName(matchedLink) + "-" + JSPWikiMarkupParser.wikifyLink(namedSection);
                            sectref = sectref.replace('%', '_');
                            this.makeLink(0, matchedLink, linktext, sectref, link.getAttributes());
                        } else {
                            this.makeLink(1, linkref, linktext, null, link.getAttributes());
                        }
                    } else {
                        linkref = MarkupParser.cleanLink(linkref);
                        this.callMutatorChain(this.m_localLinkMutatorChain, linkref);
                        String matchedLink = this.linkExists(linkref);
                        if (matchedLink != null) {
                            this.makeLink(0, matchedLink, linktext, null, link.getAttributes());
                        } else {
                            this.makeLink(1, linkref, linktext, null, link.getAttributes());
                        }
                    }
                }
            }
        }
        catch (ParseException e) {
            log.info((Object)"Parser failure: ", (Throwable)e);
            Object[] args = new Object[]{e.getMessage()};
            this.addElement((Content)JSPWikiMarkupParser.makeError(MessageFormat.format(rb.getString("markupparser.error.parserfailure"), args)));
        }
        return this.m_currentElement;
    }

    private String findAttachment(String linktext) {
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        Attachment att = null;
        try {
            att = mgr.getAttachmentInfo(this.m_context, linktext);
        }
        catch (ProviderException e) {
            log.warn((Object)"Finding attachments failed: ", (Throwable)e);
            return null;
        }
        if (att != null) {
            return att.getName();
        }
        if (linktext.indexOf(47) != -1) {
            return linktext;
        }
        return null;
    }

    private void pushBack(String s) throws IOException {
        for (int i = s.length() - 1; i >= 0; --i) {
            this.pushBack(s.charAt(i));
        }
    }

    private Element handleBackslash() throws IOException {
        int ch = this.nextToken();
        if (ch == 92) {
            int ch2 = this.nextToken();
            if (ch2 == 92) {
                this.pushElement(new Element("br").setAttribute("clear", "all"));
                return this.popElement("br");
            }
            this.pushBack(ch2);
            this.pushElement(new Element("br"));
            return this.popElement("br");
        }
        this.pushBack(ch);
        return null;
    }

    private Element handleUnderscore() throws IOException {
        int ch = this.nextToken();
        Element el = null;
        if (ch == 95) {
            el = this.m_isbold ? this.popElement("b") : this.pushElement(new Element("b"));
            this.m_isbold = !this.m_isbold;
        } else {
            this.pushBack(ch);
        }
        return el;
    }

    private Element handleApostrophe() throws IOException {
        int ch = this.nextToken();
        Element el = null;
        if (ch == 39) {
            el = this.m_isitalic ? this.popElement("i") : this.pushElement(new Element("i"));
            this.m_isitalic = !this.m_isitalic;
        } else {
            this.pushBack(ch);
        }
        return el;
    }

    private Element handleOpenbrace(boolean isBlock) throws IOException {
        int ch = this.nextToken();
        if (ch == 123) {
            int ch2 = this.nextToken();
            if (ch2 == 123) {
                this.m_isPre = true;
                this.m_isEscaping = true;
                this.m_isPreBlock = isBlock;
                if (isBlock) {
                    this.startBlockLevel();
                    return this.pushElement(new Element("pre"));
                }
                return this.pushElement(new Element("span").setAttribute("style", "font-family:monospace; white-space:pre;"));
            }
            this.pushBack(ch2);
            return this.pushElement(new Element("tt"));
        }
        this.pushBack(ch);
        return null;
    }

    private Element handleClosebrace() throws IOException {
        int ch2 = this.nextToken();
        if (ch2 == 125) {
            int ch3 = this.nextToken();
            if (ch3 == 125) {
                if (this.m_isPre) {
                    if (this.m_isPreBlock) {
                        this.popElement("pre");
                    } else {
                        this.popElement("span");
                    }
                    this.m_isPre = false;
                    this.m_isEscaping = false;
                    return this.m_currentElement;
                }
                this.m_plainTextBuf.append("}}}");
                return this.m_currentElement;
            }
            this.pushBack(ch3);
            if (!this.m_isEscaping) {
                return this.popElement("tt");
            }
        }
        this.pushBack(ch2);
        return null;
    }

    private Element handleDash() throws IOException {
        int ch = this.nextToken();
        if (ch == 45) {
            int ch2 = this.nextToken();
            if (ch2 == 45) {
                int ch3 = this.nextToken();
                if (ch3 == 45) {
                    while ((ch = this.nextToken()) == 45) {
                    }
                    this.pushBack(ch);
                    this.startBlockLevel();
                    this.pushElement(new Element("hr"));
                    return this.popElement("hr");
                }
                this.pushBack(ch3);
            }
            this.pushBack(ch2);
        }
        this.pushBack(ch);
        return null;
    }

    private Element handleHeading() throws IOException {
        Element el = null;
        int ch = this.nextToken();
        Heading hd = new Heading();
        if (ch == 33) {
            int ch2 = this.nextToken();
            if (ch2 == 33) {
                String title = this.peekAheadLine();
                el = this.makeHeading(3, title, hd);
            } else {
                this.pushBack(ch2);
                String title = this.peekAheadLine();
                el = this.makeHeading(2, title, hd);
            }
        } else {
            this.pushBack(ch);
            String title = this.peekAheadLine();
            el = this.makeHeading(1, title, hd);
        }
        this.callHeadingListenerChain(hd);
        if (el != null) {
            this.pushElement(el);
        }
        return el;
    }

    private StringBuffer readUntilEOL() throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer(256);
        while ((ch = this.nextToken()) != -1) {
            buf.append((char)ch);
            if (ch != 10) continue;
            break;
        }
        return buf;
    }

    private void startBlockLevel() {
        this.popElement("i");
        this.popElement("b");
        this.popElement("tt");
        if (this.m_isOpenParagraph) {
            this.m_isOpenParagraph = false;
            this.popElement("p");
            this.m_plainTextBuf.append("\n");
        }
        this.m_restartitalic = this.m_isitalic;
        this.m_restartbold = this.m_isbold;
        this.m_isitalic = false;
        this.m_isbold = false;
    }

    private static String getListType(char c) {
        if (c == '*') {
            return "ul";
        }
        if (c == '#') {
            return "ol";
        }
        throw new InternalWikiException("Parser got faulty list type: " + c);
    }

    private Element handleGeneralList() throws IOException {
        this.startBlockLevel();
        String strBullets = this.readWhile("*#");
        int numBullets = strBullets.length();
        if (this.m_allowPHPWikiStyleLists && !strBullets.substring(0, Math.min(numBullets, this.m_genlistlevel)).equals(this.m_genlistBulletBuffer.substring(0, Math.min(numBullets, this.m_genlistlevel)))) {
            strBullets = numBullets <= this.m_genlistlevel ? (numBullets > 1 ? this.m_genlistBulletBuffer.substring(0, numBullets - 1) : "") + strBullets.substring(numBullets - 1, numBullets) : this.m_genlistBulletBuffer + strBullets.substring(this.m_genlistlevel, numBullets);
        }
        if (strBullets.substring(0, Math.min(numBullets, this.m_genlistlevel)).equals(this.m_genlistBulletBuffer.substring(0, Math.min(numBullets, this.m_genlistlevel)))) {
            if (numBullets > this.m_genlistlevel) {
                this.pushElement(new Element(JSPWikiMarkupParser.getListType(strBullets.charAt(this.m_genlistlevel++))));
                while (this.m_genlistlevel < numBullets) {
                    this.pushElement(new Element("li"));
                    this.pushElement(new Element(JSPWikiMarkupParser.getListType(strBullets.charAt(this.m_genlistlevel))));
                    ++this.m_genlistlevel;
                }
            } else if (numBullets < this.m_genlistlevel) {
                this.popElement("li");
                while (this.m_genlistlevel > numBullets) {
                    this.popElement(JSPWikiMarkupParser.getListType(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
                    if (this.m_genlistlevel > 0) {
                        this.popElement("li");
                    }
                    --this.m_genlistlevel;
                }
            } else if (this.m_genlistlevel > 0) {
                this.popElement("li");
            }
        } else {
            int numEqualBullets;
            int numCheckBullets = Math.min(numBullets, this.m_genlistlevel);
            for (numEqualBullets = 0; numEqualBullets < numCheckBullets && strBullets.charAt(numEqualBullets) == this.m_genlistBulletBuffer.charAt(numEqualBullets); ++numEqualBullets) {
            }
            while (this.m_genlistlevel > numEqualBullets) {
                this.popElement(JSPWikiMarkupParser.getListType(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
                if (this.m_genlistlevel > 0) {
                    this.popElement("li");
                }
                --this.m_genlistlevel;
            }
            this.pushElement(new Element(JSPWikiMarkupParser.getListType(strBullets.charAt(numEqualBullets++))));
            for (int i = numEqualBullets; i < numBullets; ++i) {
                this.pushElement(new Element("li"));
                this.pushElement(new Element(JSPWikiMarkupParser.getListType(strBullets.charAt(i))));
            }
            this.m_genlistlevel = numBullets;
        }
        this.pushElement(new Element("li"));
        this.readWhile(" ");
        this.m_genlistBulletBuffer.setLength(0);
        this.m_genlistBulletBuffer.append(strBullets);
        return this.m_currentElement;
    }

    private Element unwindGeneralList() {
        while (this.m_genlistlevel > 0) {
            this.popElement("li");
            this.popElement(JSPWikiMarkupParser.getListType(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
            --this.m_genlistlevel;
        }
        this.m_genlistBulletBuffer.setLength(0);
        return null;
    }

    private Element handleDefinitionList() throws IOException {
        if (!this.m_isdefinition) {
            this.m_isdefinition = true;
            this.startBlockLevel();
            this.pushElement(new Element("dl"));
            return this.pushElement(new Element("dt"));
        }
        return null;
    }

    private Element handleOpenbracket() throws IOException {
        StringBuffer sb = new StringBuffer(40);
        int pos = this.getPosition();
        int ch = this.nextToken();
        boolean isPlugin = false;
        if (ch == 91) {
            if (this.m_wysiwygEditorMode) {
                sb.append('[');
            }
            sb.append((char)ch);
            while ((ch = this.nextToken()) == 91) {
                sb.append((char)ch);
            }
        }
        if (ch == 123) {
            isPlugin = true;
        }
        this.pushBack(ch);
        if (sb.length() > 0) {
            this.m_plainTextBuf.append(sb);
            return this.m_currentElement;
        }
        ch = this.nextToken();
        int nesting = 1;
        while (ch != -1) {
            int ch2 = this.nextToken();
            this.pushBack(ch2);
            if (isPlugin) {
                if (ch == 91 && ch2 == 123) {
                    ++nesting;
                } else {
                    if (nesting == 0 && ch == 93 && sb.charAt(sb.length() - 1) == '}') break;
                    if (ch == 125 && ch2 == 93) {
                        --nesting;
                    }
                }
            } else if (ch == 93) break;
            sb.append((char)ch);
            ch = this.nextToken();
        }
        if (ch == -1) {
            log.debug((Object)"Warning: unterminated link detected!");
            this.m_isEscaping = true;
            this.m_plainTextBuf.append(sb);
            this.flushPlainText();
            this.m_isEscaping = false;
            return this.m_currentElement;
        }
        return this.handleHyperlinks(sb.toString(), pos);
    }

    private String readBraceContent(char opening, char closing) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer(40);
        int braceLevel = 1;
        while ((ch = this.nextToken()) != -1) {
            if (ch == 92) continue;
            if (ch == opening) {
                ++braceLevel;
            } else if (ch == closing && --braceLevel == 0) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private Element handleDiv(boolean newLine) throws IOException {
        int ch = this.nextToken();
        Element el = null;
        if (ch == 37) {
            String style = null;
            String clazz = null;
            ch = this.nextToken();
            if (ch == 40) {
                style = this.readBraceContent('(', ')');
            } else if (Character.isLetter((char)ch)) {
                this.pushBack(ch);
                clazz = this.readUntil(" \t\n\r");
                ch = this.nextToken();
                if (ch == 10 || ch == 13) {
                    this.pushBack(ch);
                }
            } else {
                this.pushBack(ch);
                try {
                    Boolean isSpan = (Boolean)this.m_styleStack.pop();
                    if (isSpan != null) {
                        el = isSpan.booleanValue() ? this.popElement("span") : this.popElement("div");
                    }
                }
                catch (EmptyStackException e) {
                    log.debug((Object)("Page '" + this.m_context.getName() + "' closes a %%-block that has not been opened."));
                    return this.m_currentElement;
                }
                return el;
            }
            try {
                style = StringEscapeUtils.unescapeHtml((String)style);
                if (style != null && style.indexOf("javascript:") != -1) {
                    log.debug((Object)("Attempt to output javascript within CSS:" + style));
                    ResourceBundle rb = this.m_context.getBundle("CoreResources");
                    return this.addElement((Content)JSPWikiMarkupParser.makeError(rb.getString("markupparser.error.javascriptattempt")));
                }
            }
            catch (NumberFormatException e) {
                ResourceBundle rb = this.m_context.getBundle("CoreResources");
                Object[] args = new Object[]{e.getMessage()};
                String msg = MessageFormat.format(rb.getString("markupparser.error.parserfailure"), args);
                return this.addElement((Content)JSPWikiMarkupParser.makeError(msg));
            }
            String eol = this.peekAheadLine();
            if (eol.trim().length() > 0) {
                el = new Element("span");
                this.m_styleStack.push(Boolean.TRUE);
            } else {
                this.startBlockLevel();
                el = new Element("div");
                this.m_styleStack.push(Boolean.FALSE);
            }
            if (style != null) {
                el.setAttribute("style", style);
            }
            if (clazz != null) {
                el.setAttribute("class", clazz);
            }
            el = this.pushElement(el);
            return el;
        }
        this.pushBack(ch);
        return el;
    }

    private Element handleSlash(boolean newLine) throws IOException {
        int ch = this.nextToken();
        this.pushBack(ch);
        if (ch == 37 && !this.m_styleStack.isEmpty()) {
            return this.handleDiv(newLine);
        }
        return null;
    }

    private Element handleBar(boolean newLine) throws IOException {
        int ch;
        Element el = null;
        if (!this.m_istable && !newLine) {
            return null;
        }
        if (newLine) {
            if (!this.m_istable) {
                this.startBlockLevel();
                el = this.pushElement(new Element("table").setAttribute("class", "wikitable").setAttribute("border", "1"));
                this.m_istable = true;
                this.m_rowNum = 0;
            }
            ++this.m_rowNum;
            Element tr = this.m_rowNum % 2 != 0 ? new Element("tr").setAttribute("class", "odd") : new Element("tr");
            el = this.pushElement(tr);
        }
        if ((ch = this.nextToken()) == 124) {
            if (!newLine && (el = this.popElement("th")) == null) {
                this.popElement("td");
            }
            el = this.pushElement(new Element("th"));
        } else {
            if (!newLine && (el = this.popElement("td")) == null) {
                this.popElement("th");
            }
            el = this.pushElement(new Element("td"));
            this.pushBack(ch);
        }
        return el;
    }

    private Element handleTilde() throws IOException {
        int ch = this.nextToken();
        if (ch == 32) {
            if (this.m_wysiwygEditorMode) {
                this.m_plainTextBuf.append("~ ");
            }
            return this.m_currentElement;
        }
        if (ch == 124 || ch == 126 || ch == 92 || ch == 42 || ch == 35 || ch == 45 || ch == 33 || ch == 39 || ch == 95 || ch == 91 || ch == 123 || ch == 93 || ch == 125 || ch == 37) {
            if (this.m_wysiwygEditorMode) {
                this.m_plainTextBuf.append('~');
            }
            this.m_plainTextBuf.append((char)ch);
            this.m_plainTextBuf.append(this.readWhile("" + (char)ch));
            return this.m_currentElement;
        }
        this.pushBack(ch);
        return null;
    }

    private void fillBuffer(Element startElement) throws IOException {
        int ch;
        this.m_currentElement = startElement;
        boolean quitReading = false;
        this.m_newLine = true;
        this.disableOutputEscaping();
        while (!quitReading && (ch = this.nextToken()) != -1) {
            if (this.m_isEscaping) {
                if (ch == 125) {
                    if (this.handleClosebrace() != null) continue;
                    this.m_plainTextBuf.append((char)ch);
                    continue;
                }
                if (ch == -1) {
                    quitReading = true;
                    continue;
                }
                if (ch == 13) continue;
                if (ch == 60) {
                    this.m_plainTextBuf.append("&lt;");
                    continue;
                }
                if (ch == 62) {
                    this.m_plainTextBuf.append("&gt;");
                    continue;
                }
                if (ch == 38) {
                    this.m_plainTextBuf.append("&amp;");
                    continue;
                }
                if (ch == 126) {
                    String braces = this.readWhile("}");
                    if (braces.length() >= 3) {
                        this.m_plainTextBuf.append("}}}");
                        braces = braces.substring(3);
                    } else {
                        this.m_plainTextBuf.append((char)ch);
                    }
                    for (int i = braces.length() - 1; i >= 0; --i) {
                        this.pushBack(braces.charAt(i));
                    }
                    continue;
                }
                this.m_plainTextBuf.append((char)ch);
                continue;
            }
            if (this.m_newLine && ch != 42 && ch != 35 && ch != 32 && this.m_genlistlevel > 0) {
                this.m_plainTextBuf.append(this.unwindGeneralList());
            }
            if (this.m_newLine && ch != 124 && this.m_istable) {
                this.popElement("table");
                this.m_istable = false;
            }
            int skip = 2;
            try {
                skip = this.parseToken(ch);
            }
            catch (IllegalDataException e) {
                log.info((Object)("Page " + this.m_context.getPage().getName() + " contains data which cannot be added to DOM tree: " + e.getMessage()));
                JSPWikiMarkupParser.makeError("Error: " + this.cleanupSuspectData(e.getMessage()));
            }
            switch (skip) {
                case 1: {
                    this.m_newLine = false;
                    break;
                }
                case 0: {
                    this.m_plainTextBuf.append((char)ch);
                    this.m_newLine = false;
                    break;
                }
            }
        }
        this.popElement("domroot");
    }

    private String cleanupSuspectData(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Verifier.isXMLCharacter((int)c)) {
                sb.append(c);
                continue;
            }
            sb.append("0x" + Integer.toString(c, 16).toUpperCase());
        }
        return sb.toString();
    }

    protected int parseToken(int ch) throws IOException {
        Element el = null;
        switch (ch) {
            case 13: {
                return 2;
            }
            case 10: {
                this.popElement("dl");
                this.popElement("h2");
                this.popElement("h3");
                this.popElement("h4");
                if (this.m_istable) {
                    this.popElement("tr");
                }
                this.m_isdefinition = false;
                if (this.m_newLine) {
                    this.startBlockLevel();
                    String nextLine = this.peekAheadLine();
                    if (nextLine.length() == 0 || nextLine.length() > 0 && !nextLine.startsWith("{{{") && !nextLine.startsWith("----") && !nextLine.startsWith("%%") && "*#!;".indexOf(nextLine.charAt(0)) == -1) {
                        this.pushElement(new Element("p"));
                        this.m_isOpenParagraph = true;
                        if (this.m_restartitalic) {
                            this.pushElement(new Element("i"));
                            this.m_isitalic = true;
                            this.m_restartitalic = false;
                        }
                        if (this.m_restartbold) {
                            this.pushElement(new Element("b"));
                            this.m_isbold = true;
                            this.m_restartbold = false;
                        }
                    }
                } else {
                    this.m_plainTextBuf.append("\n");
                    this.m_newLine = true;
                }
                return 2;
            }
            case 92: {
                el = this.handleBackslash();
                break;
            }
            case 95: {
                el = this.handleUnderscore();
                break;
            }
            case 39: {
                el = this.handleApostrophe();
                break;
            }
            case 123: {
                el = this.handleOpenbrace(this.m_newLine);
                break;
            }
            case 125: {
                el = this.handleClosebrace();
                break;
            }
            case 45: {
                if (!this.m_newLine) break;
                el = this.handleDash();
                break;
            }
            case 33: {
                if (!this.m_newLine) break;
                el = this.handleHeading();
                break;
            }
            case 59: {
                if (!this.m_newLine) break;
                el = this.handleDefinitionList();
                break;
            }
            case 58: {
                if (!this.m_isdefinition) break;
                this.popElement("dt");
                el = this.pushElement(new Element("dd"));
                this.m_isdefinition = false;
                break;
            }
            case 91: {
                el = this.handleOpenbracket();
                break;
            }
            case 42: {
                if (!this.m_newLine) break;
                this.pushBack(42);
                el = this.handleGeneralList();
                break;
            }
            case 35: {
                if (!this.m_newLine) break;
                this.pushBack(35);
                el = this.handleGeneralList();
                break;
            }
            case 124: {
                el = this.handleBar(this.m_newLine);
                break;
            }
            case 126: {
                el = this.handleTilde();
                break;
            }
            case 37: {
                el = this.handleDiv(this.m_newLine);
                break;
            }
            case 47: {
                el = this.handleSlash(this.m_newLine);
                break;
            }
        }
        return el != null ? 1 : 0;
    }

    public WikiDocument parse() throws IOException {
        WikiDocument d = new WikiDocument(this.m_context.getPage());
        d.setContext(this.m_context);
        Element rootElement = new Element("domroot");
        d.setRootElement(rootElement);
        this.fillBuffer(rootElement);
        this.paragraphify(rootElement);
        return d;
    }

    private void paragraphify(Element rootElement) {
        List kids = rootElement.getContent();
        if (rootElement.getChild("p") != null) {
            String name;
            Content c;
            ArrayList<Content> ls = new ArrayList<Content>();
            int idxOfFirstContent = 0;
            int count = 0;
            Iterator i = kids.iterator();
            while (!(!i.hasNext() || (c = (Content)i.next()) instanceof Element && JSPWikiMarkupParser.isBlockLevel(name = ((Element)c).getName()))) {
                if (!(c instanceof ProcessingInstruction)) {
                    ls.add(c);
                    if (idxOfFirstContent == 0) {
                        idxOfFirstContent = count;
                    }
                }
                ++count;
            }
            if (ls.size() > 0) {
                Element newel = new Element("p");
                Iterator i2 = ls.iterator();
                while (i2.hasNext()) {
                    Content c2 = (Content)i2.next();
                    c2.detach();
                    newel.addContent(c2);
                }
                if (newel.getTextTrim().length() > 0 || !newel.getChildren().isEmpty()) {
                    rootElement.addContent(idxOfFirstContent, (Content)newel);
                }
            }
        }
    }

    static {
        Arrays.sort(c_externalLinks);
        BLOCK_ELEMENTS = new String[]{"address", "blockquote", "div", "dl", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "noscript", "ol", "p", "pre", "table", "ul"};
        EMPTY_ELEMENTS = new String[]{"area", "base", "br", "col", "hr", "img", "input", "link", "meta", "p", "param"};
    }

    private static class StartingComparator
    implements Comparator {
        private StartingComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            String s1 = (String)arg0;
            String s2 = (String)arg1;
            if (s1.length() > s2.length() ? s1.startsWith(s2) && s2.length() > 1 : s2.startsWith(s1) && s1.length() > 1) {
                return 0;
            }
            return s1.compareTo(s2);
        }
    }
}

