/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.parser;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.parser.JSPWikiMarkupParser;
import com.ecyrd.jspwiki.parser.WikiDocument;
import com.ecyrd.jspwiki.plugin.PluginException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.jdom.Text;

public class PluginContent
extends Text {
    private static final String BLANK = "";
    private static final String CMDLINE = "_cmdline";
    private static final String ELEMENT_BR = "<br/>";
    private static final String EMITTABLE_PLUGINS = "Image|FormOpen|FormClose|FormInput|FormTextarea|FormSelect";
    private static final String LINEBREAK = "\n";
    private static final String PLUGIN_START = "[{";
    private static final String PLUGIN_END = "}]";
    private static final String SPACE = " ";
    private static final long serialVersionUID = 1L;
    private String m_pluginName;
    private Map m_params;

    public PluginContent(String pluginName, Map parameters) {
        this.m_pluginName = pluginName;
        this.m_params = parameters;
    }

    public String getPluginName() {
        return this.m_pluginName;
    }

    public Object getParameter(String name) {
        return this.m_params.get(name);
    }

    public Map getParameters() {
        return this.m_params;
    }

    public String getValue() {
        return this.getText();
    }

    public String getText() {
        String result;
        WikiDocument doc = (WikiDocument)this.getDocument();
        if (doc == null) {
            return this.getPluginName();
        }
        WikiContext context = doc.getContext();
        Boolean wysiwygVariable = (Boolean)context.getVariable("WYSIWYG_EDITOR_MODE");
        boolean wysiwygEditorMode = false;
        if (wysiwygVariable != null) {
            wysiwygEditorMode = wysiwygVariable;
        }
        try {
            if (wysiwygEditorMode && !this.m_pluginName.matches(EMITTABLE_PLUGINS)) {
                result = PLUGIN_START + this.m_pluginName + SPACE;
                String cmdLine = ((String)this.m_params.get(CMDLINE)).replaceAll(LINEBREAK, ELEMENT_BR);
                result = result + cmdLine + PLUGIN_END;
            } else {
                Boolean b = (Boolean)context.getVariable("_PluginContent.execute");
                if (b != null && !b.booleanValue()) {
                    return BLANK;
                }
                WikiEngine engine = context.getEngine();
                HashMap parsedParams = new HashMap();
                Iterator i = this.m_params.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object val = e.getValue();
                    if (val instanceof String) {
                        val = engine.getVariableManager().expandVariables(context, (String)val);
                    }
                    parsedParams.put(e.getKey(), val);
                }
                result = engine.getPluginManager().execute(context, this.m_pluginName, parsedParams);
            }
        }
        catch (Exception e) {
            if (wysiwygEditorMode) {
                result = BLANK;
            }
            ResourceBundle rb = context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
            Object[] args = new Object[]{e.getMessage()};
            result = JSPWikiMarkupParser.makeError(MessageFormat.format(rb.getString("plugin.error.insertionfailed"), args)).getText();
        }
        return result;
    }

    public void executeParse(WikiContext m_context) throws PluginException {
        m_context.getEngine().getPluginManager().executeParse(this, m_context);
    }
}

