/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.StringTransmutator;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.parser.WikiDocument;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.render.RenderingManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class AbstractReferralPlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger((Class)AbstractReferralPlugin.class);
    public static final int ALL_ITEMS = -1;
    public static final String PARAM_MAXWIDTH = "maxwidth";
    public static final String PARAM_SEPARATOR = "separator";
    public static final String PARAM_AFTER = "after";
    public static final String PARAM_BEFORE = "before";
    public static final String PARAM_EXCLUDE = "exclude";
    public static final String PARAM_INCLUDE = "include";
    protected int m_maxwidth = Integer.MAX_VALUE;
    protected String m_before = "";
    protected String m_separator = "";
    protected String m_after = "\\\\";
    protected Pattern[] m_exclude;
    protected Pattern[] m_include;
    protected WikiEngine m_engine;

    public void initialize(WikiContext context, Map params) throws PluginException {
        int i;
        String[] ptrns;
        GlobCompiler pc;
        String s;
        this.m_engine = context.getEngine();
        this.m_maxwidth = TextUtil.parseIntParameter((String)params.get(PARAM_MAXWIDTH), Integer.MAX_VALUE);
        if (this.m_maxwidth < 0) {
            this.m_maxwidth = 0;
        }
        if ((s = (String)params.get(PARAM_SEPARATOR)) != null) {
            this.m_separator = s;
            this.m_after = "";
        }
        if ((s = (String)params.get(PARAM_BEFORE)) != null) {
            this.m_before = s;
        }
        if ((s = (String)params.get(PARAM_AFTER)) != null) {
            this.m_after = s;
        }
        if ((s = (String)params.get(PARAM_EXCLUDE)) != null) {
            try {
                pc = new GlobCompiler();
                ptrns = StringUtils.split((String)s, (String)",");
                this.m_exclude = new Pattern[ptrns.length];
                for (i = 0; i < ptrns.length; ++i) {
                    this.m_exclude[i] = pc.compile(ptrns[i]);
                }
            }
            catch (MalformedPatternException e) {
                throw new PluginException("Exclude-parameter has a malformed pattern: " + e.getMessage());
            }
        }
        if ((s = (String)params.get(PARAM_INCLUDE)) != null) {
            try {
                pc = new GlobCompiler();
                ptrns = StringUtils.split((String)s, (String)",");
                this.m_include = new Pattern[ptrns.length];
                for (i = 0; i < ptrns.length; ++i) {
                    this.m_include[i] = pc.compile(ptrns[i]);
                }
            }
            catch (MalformedPatternException e) {
                throw new PluginException("Include-parameter has a malformed pattern: " + e.getMessage());
            }
        }
    }

    protected Collection filterCollection(Collection c) {
        ArrayList<String> result = new ArrayList<String>();
        Perl5Matcher pm = new Perl5Matcher();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            int j;
            boolean includeThis;
            String pageName = (String)i.next();
            boolean bl = includeThis = this.m_include == null;
            if (this.m_include != null) {
                for (j = 0; j < this.m_include.length; ++j) {
                    if (!pm.matches(pageName, this.m_include[j])) continue;
                    includeThis = true;
                    break;
                }
            }
            if (this.m_exclude != null) {
                for (j = 0; j < this.m_exclude.length; ++j) {
                    if (!pm.matches(pageName, this.m_exclude[j])) continue;
                    includeThis = false;
                    break;
                }
            }
            if (!includeThis) continue;
            result.add(pageName);
        }
        return result;
    }

    protected String wikitizeCollection(Collection links, String separator, int numItems) {
        int count;
        if (links == null || links.isEmpty()) {
            return "";
        }
        StringBuffer output = new StringBuffer();
        Iterator it = links.iterator();
        for (count = 0; it.hasNext() && (count < numItems || numItems == -1); ++count) {
            String value = (String)it.next();
            if (count > 0) {
                output.append(this.m_after);
                output.append(this.m_separator);
            }
            output.append(this.m_before);
            output.append("[" + this.m_engine.beautifyTitle(value) + "|" + value + "]");
        }
        if (count > 0) {
            output.append(this.m_after);
        }
        return output.toString();
    }

    protected String makeHTML(WikiContext context, String wikitext) {
        String result = "";
        RenderingManager mgr = this.m_engine.getRenderingManager();
        try {
            MarkupParser parser = mgr.getParser(context, wikitext);
            parser.addLinkTransmutator(new CutMutator(this.m_maxwidth));
            parser.enableImageInlining(false);
            WikiDocument doc = parser.parse();
            result = mgr.getHTML(context, doc);
        }
        catch (IOException e) {
            log.error((Object)"Failed to convert page data to HTML", (Throwable)e);
        }
        return result;
    }

    private static class CutMutator
    implements StringTransmutator {
        private int m_length;

        public CutMutator(int length) {
            this.m_length = length;
        }

        public String mutate(WikiContext context, String text) {
            if (text.length() > this.m_length) {
                return text.substring(0, this.m_length) + "...";
            }
            return text;
        }
    }
}

