/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.filters.RedirectException;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class BugReportHandler
implements WikiPlugin {
    private static Logger log = Logger.getLogger((Class)BugReportHandler.class);
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String VERSION = "version";
    public static final String MAPPINGS = "map";
    public static final String PAGE = "page";
    public static final String DEFAULT_DATEFORMAT = "dd-MMM-yyyy HH:mm:ss zzz";

    public String execute(WikiContext context, Map params) throws PluginException {
        String submitter = null;
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATEFORMAT);
        ResourceBundle rb = context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
        String title = (String)params.get(TITLE);
        String description = (String)params.get(DESCRIPTION);
        String version = (String)params.get(VERSION);
        Principal wup = context.getCurrentUser();
        if (wup != null) {
            submitter = wup.getName();
        }
        if (title == null) {
            throw new PluginException(rb.getString("bugreporthandler.titlerequired"));
        }
        if (title.length() == 0) {
            return "";
        }
        if (description == null) {
            description = "";
        }
        if (version == null) {
            version = "unknown";
        }
        Properties mappings = this.parseMappings((String)params.get(MAPPINGS));
        try {
            StringWriter str = new StringWriter();
            PrintWriter out = new PrintWriter(str);
            Date d = new Date();
            out.println("|" + mappings.getProperty(TITLE, "Title") + "|" + title);
            out.println("|" + mappings.getProperty("date", "Date") + "|" + format.format(d));
            out.println("|" + mappings.getProperty(VERSION, "Version") + "|" + version);
            if (submitter != null) {
                out.println("|" + mappings.getProperty("submitter", "Submitter") + "|" + submitter);
            }
            Iterator i = params.entrySet().iterator();
            while (i.hasNext()) {
                String head;
                Map.Entry entry = i.next();
                if (entry.getKey().equals(TITLE) || entry.getKey().equals(DESCRIPTION) || entry.getKey().equals(VERSION) || entry.getKey().equals(MAPPINGS) || entry.getKey().equals(PAGE) || entry.getKey().toString().startsWith("_") || (head = mappings.getProperty((String)entry.getKey(), (String)entry.getKey())).length() <= 0) continue;
                out.println("|" + head + "|" + entry.getValue());
            }
            out.println();
            out.println(description);
            out.close();
            String pageName = this.findNextPage(context, title, (String)params.get(PAGE));
            WikiPage newPage = new WikiPage(context.getEngine(), pageName);
            WikiContext newContext = (WikiContext)context.clone();
            newContext.setPage(newPage);
            context.getEngine().saveText(newContext, str.toString());
            MessageFormat formatter = new MessageFormat("");
            formatter.applyPattern(rb.getString("bugreporthandler.new"));
            String[] args = new String[]{"<a href=\"" + context.getViewURL(pageName) + "\">" + pageName + "</a>"};
            return formatter.format(args);
        }
        catch (RedirectException e) {
            log.info((Object)("Saving not allowed, reason: '" + e.getMessage() + "', can't redirect to " + e.getRedirect()));
            throw new PluginException("Saving not allowed, reason: " + e.getMessage());
        }
        catch (WikiException e) {
            log.error((Object)"Unable to save page!", (Throwable)e);
            return rb.getString("bugreporthandler.unable");
        }
    }

    private synchronized String findNextPage(WikiContext context, String title, String baseName) {
        String basicPageName = (baseName != null ? baseName : "Bug") + MarkupParser.cleanLink(title);
        WikiEngine engine = context.getEngine();
        String pageName = basicPageName;
        long lastbug = 2L;
        while (engine.pageExists(pageName)) {
            pageName = basicPageName + lastbug++;
        }
        return pageName;
    }

    private Properties parseMappings(String mappings) {
        Properties props = new Properties();
        if (mappings == null) {
            return props;
        }
        StringTokenizer tok = new StringTokenizer(mappings, ";");
        while (tok.hasMoreTokens()) {
            String value;
            String key;
            String t = tok.nextToken();
            int colon = t.indexOf("=");
            if (colon > 0) {
                key = t.substring(0, colon);
                value = t.substring(colon + 1);
            } else {
                key = t;
                value = "";
            }
            props.setProperty(key, value);
        }
        return props;
    }
}

