/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.PageManager;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class IndexPlugin
implements WikiPlugin {
    protected static final Logger log = Logger.getLogger((Class)IndexPlugin.class);
    public static final String INITIALS_COLOR = "red";
    private static final int DEFAULT_ITEMS_PER_LINE = 0;
    private static final String PARAM_ITEMS_PER_LINE = "itemsPerLine";
    private static final String PARAM_INCLUDE = "include";
    private static final String PARAM_EXCLUDE = "exclude";
    private int m_currentNofPagesOnLine = 0;
    private int m_itemsPerLine;
    protected String m_previousPageFirstLetter = "";
    protected StringWriter m_bodyPart = new StringWriter();
    protected StringWriter m_headerPart = new StringWriter();
    private Pattern m_includePattern;
    private Pattern m_excludePattern;

    public String execute(WikiContext wikiContext, Map params) throws PluginException {
        GlobCompiler compiler = new GlobCompiler();
        this.m_itemsPerLine = TextUtil.parseIntParameter((String)params.get(PARAM_ITEMS_PER_LINE), 0);
        try {
            String ptrn = (String)params.get(PARAM_INCLUDE);
            if (ptrn == null) {
                ptrn = "*";
            }
            this.m_includePattern = compiler.compile(ptrn);
            ptrn = (String)params.get(PARAM_EXCLUDE);
            if (ptrn == null) {
                ptrn = "";
            }
            this.m_excludePattern = compiler.compile(ptrn);
        }
        catch (MalformedPatternException e) {
            throw new PluginException("Illegal pattern detected.");
        }
        Collection allPages = IndexPlugin.getAllPagesSortedByName(wikiContext);
        this.buildIndexPageHeaderAndBody(wikiContext, allPages);
        StringBuffer res = new StringBuffer();
        res.append("<div class=\"index\">\n");
        res.append("<div class=\"header\">\n");
        res.append(this.m_headerPart.toString());
        res.append("</div>\n");
        res.append("<div class=\"body\">\n");
        res.append(this.m_bodyPart.toString());
        res.append("</div>\n</div>\n");
        return res.toString();
    }

    private void buildIndexPageHeaderAndBody(WikiContext context, Collection allPages) {
        Perl5Matcher matcher = new Perl5Matcher();
        Iterator i = allPages.iterator();
        while (i.hasNext()) {
            WikiPage curPage = (WikiPage)i.next();
            if (!matcher.matches(curPage.getName(), this.m_includePattern) || matcher.matches(curPage.getName(), this.m_excludePattern)) continue;
            ++this.m_currentNofPagesOnLine;
            String pageNameFirstLetter = curPage.getName().substring(0, 1).toUpperCase();
            boolean sameFirstLetterAsPreviousPage = this.m_previousPageFirstLetter.equals(pageNameFirstLetter);
            if (!sameFirstLetterAsPreviousPage) {
                this.addLetterToIndexHeader(pageNameFirstLetter);
                this.addLetterHeaderWithLine(pageNameFirstLetter);
                this.m_currentNofPagesOnLine = 1;
                this.m_previousPageFirstLetter = pageNameFirstLetter;
            }
            this.addPageToIndex(context, curPage);
            this.breakLineIfTooLong();
        }
    }

    static Collection getAllPagesSortedByName(WikiContext wikiContext) {
        WikiEngine engine = wikiContext.getEngine();
        PageManager pageManager = engine.getPageManager();
        if (pageManager == null) {
            return null;
        }
        TreeSet result = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                WikiPage page1 = (WikiPage)o1;
                WikiPage page2 = (WikiPage)o2;
                return page1.getName().compareTo(page2.getName());
            }
        });
        try {
            Collection allPages = pageManager.getAllPages();
            result.addAll(allPages);
        }
        catch (ProviderException e) {
            log.fatal((Object)"PageProvider is unable to list pages: ", (Throwable)e);
        }
        return result;
    }

    private void addLetterToIndexHeader(String firstLetter) {
        boolean noLetterYetInTheIndex;
        boolean bl = noLetterYetInTheIndex = !"".equals(this.m_previousPageFirstLetter);
        if (noLetterYetInTheIndex) {
            this.m_headerPart.write(" - ");
        }
        this.m_headerPart.write("<a href=\"#" + firstLetter + "\">" + firstLetter + "</a>");
    }

    private void addLetterHeaderWithLine(String firstLetter) {
        this.m_bodyPart.write("\n<br /><br /><span class=\"section\"><a name=\"" + firstLetter + "\">" + firstLetter + "</a></span>" + "<hr />\n");
    }

    protected void addPageToIndex(WikiContext context, WikiPage curPage) {
        boolean notFirstPageOnLine;
        boolean bl = notFirstPageOnLine = 2 <= this.m_currentNofPagesOnLine;
        if (notFirstPageOnLine) {
            this.m_bodyPart.write(",&nbsp; ");
        }
        this.m_bodyPart.write("<a href=\"" + context.getURL(WikiContext.VIEW, curPage.getName()) + "\">" + context.getEngine().beautifyTitleNoBreak(curPage.getName()) + "</a>");
    }

    protected void breakLineIfTooLong() {
        boolean limitReached;
        boolean bl = limitReached = this.m_itemsPerLine == this.m_currentNofPagesOnLine;
        if (limitReached) {
            this.m_bodyPart.write("<br />\n");
            this.m_currentNofPagesOnLine = 0;
        }
    }
}

