/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.modules.ModuleManager;
import com.ecyrd.jspwiki.modules.WikiModuleInfo;
import com.ecyrd.jspwiki.parser.PluginContent;
import com.ecyrd.jspwiki.plugin.InitializablePlugin;
import com.ecyrd.jspwiki.plugin.ParserStagePlugin;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.util.ClassUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.lang.ClassUtils;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.pre;
import org.apache.ecs.xhtml.ul;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class PluginManager
extends ModuleManager {
    private static final String PLUGIN_INSERT_PATTERN = "\\{?(INSERT)?\\s*([\\w\\._]+)[ \\t]*(WHERE)?[ \\t]*";
    private static Logger log = Logger.getLogger((Class)PluginManager.class);
    public static final String DEFAULT_PACKAGE = "com.ecyrd.jspwiki.plugin";
    public static final String DEFAULT_FORMS_PACKAGE = "com.ecyrd.jspwiki.forms";
    public static final String PROP_SEARCHPATH = "jspwiki.plugin.searchPath";
    public static final String PARAM_BODY = "_body";
    public static final String PARAM_CMDLINE = "_cmdline";
    public static final String PARAM_BOUNDS = "_bounds";
    public static final String PARAM_DEBUG = "debug";
    private ArrayList m_searchPath = new ArrayList();
    private Pattern m_pluginPattern;
    private boolean m_pluginsEnabled = true;
    private Map m_pluginClassMap = new HashMap();

    public PluginManager(WikiEngine engine, Properties props) {
        super(engine);
        String packageNames = props.getProperty(PROP_SEARCHPATH);
        if (packageNames != null) {
            StringTokenizer tok = new StringTokenizer(packageNames, ",");
            while (tok.hasMoreTokens()) {
                this.m_searchPath.add(tok.nextToken().trim());
            }
        }
        this.registerPlugins();
        this.m_searchPath.add(DEFAULT_PACKAGE);
        this.m_searchPath.add(DEFAULT_FORMS_PACKAGE);
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_pluginPattern = compiler.compile(PLUGIN_INSERT_PATTERN);
        }
        catch (MalformedPatternException e) {
            log.fatal((Object)"Internal error: someone messed with pluginmanager patterns.", (Throwable)e);
            throw new InternalWikiException("PluginManager patterns are broken");
        }
    }

    public void enablePlugins(boolean enabled) {
        this.m_pluginsEnabled = enabled;
    }

    public boolean pluginsEnabled() {
        return this.m_pluginsEnabled;
    }

    public static boolean isPluginLink(String link) {
        return link.startsWith("{INSERT") || link.startsWith("{") && !link.startsWith("{$");
    }

    private Class findPluginClass(String classname) throws ClassNotFoundException {
        return ClassUtil.findClass(this.m_searchPath, classname);
    }

    private String stackTrace(Map params, Throwable t) {
        div d = new div();
        d.setClass(PARAM_DEBUG);
        d.addElement("Plugin execution failed, stack trace follows:");
        StringWriter out = new StringWriter();
        t.printStackTrace(new PrintWriter(out));
        d.addElement((org.apache.ecs.Element)new pre(out.toString()));
        d.addElement((org.apache.ecs.Element)new b("Parameters to the plugin"));
        ul list = new ul();
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            list.addElement((org.apache.ecs.Element)new li(key + "'='" + e.getValue()));
        }
        d.addElement((org.apache.ecs.Element)list);
        return d.toString();
    }

    public String execute(WikiContext context, String classname, Map params) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return "";
        }
        ResourceBundle rb = context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
        Object[] args = new Object[]{classname};
        try {
            WikiPlugin plugin;
            boolean debug = TextUtil.isPositive((String)params.get(PARAM_DEBUG));
            WikiPluginInfo pluginInfo = (WikiPluginInfo)this.m_pluginClassMap.get(classname);
            if (pluginInfo == null) {
                pluginInfo = WikiPluginInfo.newInstance(this.findPluginClass(classname));
                this.registerPlugin(pluginInfo);
            }
            if (!this.checkCompatibility(pluginInfo)) {
                String msg = "Plugin '" + pluginInfo.getName() + "' not compatible with this version of JSPWiki";
                log.info((Object)msg);
                return msg;
            }
            try {
                plugin = pluginInfo.newPluginInstance();
            }
            catch (InstantiationException e) {
                throw new PluginException(MessageFormat.format(rb.getString("plugin.error.cannotinstantiate"), args), e);
            }
            catch (IllegalAccessException e) {
                throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notallowed"), args), e);
            }
            catch (Exception e) {
                throw new PluginException(MessageFormat.format(rb.getString("plugin.error.instantationfailed"), args), e);
            }
            try {
                return plugin.execute(context, params);
            }
            catch (PluginException e) {
                if (debug) {
                    return this.stackTrace(params, e);
                }
                throw (PluginException)e.fillInStackTrace();
            }
            catch (Throwable t) {
                log.info((Object)"Plugin failed while executing:", t);
                if (debug) {
                    return this.stackTrace(params, t);
                }
                throw new PluginException(rb.getString("plugin.error.pluginfailed"), t);
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.couldnotfind"), args), e);
        }
        catch (ClassCastException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notawikiplugin"), args), e);
        }
    }

    public Map parseArgs(String argstring) throws IOException {
        HashMap<String, String> arglist = new HashMap<String, String>();
        if (argstring == null) {
            return arglist;
        }
        arglist.put(PARAM_CMDLINE, argstring);
        StringReader in = new StringReader(argstring);
        StreamTokenizer tok = new StreamTokenizer(in);
        String param = null;
        String value = null;
        tok.eolIsSignificant(true);
        boolean potentialEmptyLine = false;
        boolean quit = false;
        while (!quit) {
            String s;
            int type = tok.nextToken();
            switch (type) {
                case -1: {
                    quit = true;
                    s = null;
                    break;
                }
                case -3: {
                    s = tok.sval;
                    potentialEmptyLine = false;
                    break;
                }
                case 10: {
                    quit = potentialEmptyLine;
                    potentialEmptyLine = true;
                    s = null;
                    break;
                }
                case -2: {
                    s = Integer.toString(new Double(tok.nval).intValue());
                    potentialEmptyLine = false;
                    break;
                }
                case 39: {
                    s = tok.sval;
                    break;
                }
                default: {
                    s = null;
                }
            }
            if (s == null) continue;
            if (param == null) {
                param = s;
                continue;
            }
            value = s;
            arglist.put(param, value);
            param = null;
        }
        if (potentialEmptyLine) {
            StringWriter out = new StringWriter();
            FileUtil.copyContents(in, out);
            String bodyContent = out.toString();
            if (bodyContent != null) {
                arglist.put(PARAM_BODY, bodyContent);
            }
        }
        return arglist;
    }

    public String execute(WikiContext context, String commandline) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return "";
        }
        ResourceBundle rb = context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
        Object[] obArgs = new Object[]{commandline};
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            if (matcher.contains(commandline, this.m_pluginPattern)) {
                MatchResult res = matcher.getMatch();
                String plugin = res.group(2);
                String args = commandline.substring(res.endOffset(0), commandline.length() - (commandline.charAt(commandline.length() - 1) == '}' ? 1 : 0));
                Map arglist = this.parseArgs(args);
                return this.execute(context, plugin, arglist);
            }
        }
        catch (NoSuchElementException e) {
            String msg = "Missing parameter in plugin definition: " + commandline;
            log.warn((Object)msg, (Throwable)e);
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.missingparameter"), obArgs));
        }
        catch (IOException e) {
            String msg = "Zyrf.  Problems with parsing arguments: " + commandline;
            log.warn((Object)msg, (Throwable)e);
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.parsingarguments"), obArgs));
        }
        return commandline;
    }

    public PluginContent parsePluginLine(WikiContext context, String commandline, int pos) throws PluginException {
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            if (matcher.contains(commandline, this.m_pluginPattern)) {
                MatchResult res = matcher.getMatch();
                String plugin = res.group(2);
                String args = commandline.substring(res.endOffset(0), commandline.length() - (commandline.charAt(commandline.length() - 1) == '}' ? 1 : 0));
                Map arglist = this.parseArgs(args);
                if (pos != -1) {
                    int end = pos + commandline.length() + 2;
                    int[] bounds = new int[]{pos, end};
                    arglist.put(PARAM_BOUNDS, bounds);
                }
                PluginContent result = new PluginContent(plugin, arglist);
                return result;
            }
        }
        catch (ClassCastException e) {
            log.error((Object)"Invalid type offered in parsing plugin arguments.", (Throwable)e);
            throw new InternalWikiException("Oops, someone offered !String!");
        }
        catch (NoSuchElementException e) {
            String msg = "Missing parameter in plugin definition: " + commandline;
            log.warn((Object)msg, (Throwable)e);
            throw new PluginException(msg);
        }
        catch (IOException e) {
            String msg = "Zyrf.  Problems with parsing arguments: " + commandline;
            log.warn((Object)msg, (Throwable)e);
            throw new PluginException(msg);
        }
        return null;
    }

    private void registerPlugin(WikiPluginInfo pluginClass) {
        String name = pluginClass.getName();
        if (name != null) {
            log.debug((Object)("Registering plugin [name]: " + name));
            this.m_pluginClassMap.put(name, pluginClass);
        }
        if ((name = pluginClass.getAlias()) != null) {
            log.debug((Object)("Registering plugin [shortName]: " + name));
            this.m_pluginClassMap.put(name, pluginClass);
        }
        if ((name = pluginClass.getClassName()) != null) {
            log.debug((Object)("Registering plugin [className]: " + name));
            this.m_pluginClassMap.put(name, pluginClass);
        }
        pluginClass.initializePlugin(this.m_engine);
    }

    private void registerPlugins() {
        log.info((Object)"Registering plugins");
        SAXBuilder builder = new SAXBuilder();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("ini/jspwiki_module.xml");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    log.debug((Object)("Processing XML: " + resource));
                    Document doc = builder.build(resource);
                    List plugins = XPath.selectNodes((Object)doc, (String)"/modules/plugin");
                    Iterator i = plugins.iterator();
                    while (i.hasNext()) {
                        Element pluginEl = (Element)i.next();
                        String className = pluginEl.getAttributeValue("class");
                        WikiPluginInfo pluginInfo = WikiPluginInfo.newInstance(className, pluginEl);
                        if (pluginInfo == null) continue;
                        this.registerPlugin(pluginInfo);
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Couldn't load ini/jspwiki_module.xml resources: " + resource), (Throwable)e);
                }
                catch (JDOMException e) {
                    log.error((Object)"Error parsing XML for plugin: ini/jspwiki_module.xml");
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Couldn't load all ini/jspwiki_module.xml resources", (Throwable)e);
        }
    }

    public Collection modules() {
        TreeSet<WikiModuleInfo> ls = new TreeSet<WikiModuleInfo>();
        Iterator i = this.m_pluginClassMap.values().iterator();
        while (i.hasNext()) {
            WikiModuleInfo wmi = (WikiModuleInfo)i.next();
            if (ls.contains(wmi)) continue;
            ls.add(wmi);
        }
        return ls;
    }

    public void executeParse(PluginContent content, WikiContext context) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return;
        }
        ResourceBundle rb = context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
        Object[] args = new Object[]{content.getPluginName()};
        Map params = content.getParameters();
        try {
            WikiPluginInfo pluginInfo = (WikiPluginInfo)this.m_pluginClassMap.get(content.getPluginName());
            if (pluginInfo == null) {
                pluginInfo = WikiPluginInfo.newInstance(this.findPluginClass(content.getPluginName()));
                this.registerPlugin(pluginInfo);
            }
            if (!this.checkCompatibility(pluginInfo)) {
                String msg = "Plugin '" + pluginInfo.getName() + "' not compatible with this version of JSPWiki";
                log.info((Object)msg);
                return;
            }
            WikiPlugin plugin = pluginInfo.newPluginInstance();
            if (plugin instanceof ParserStagePlugin) {
                ((ParserStagePlugin)((Object)plugin)).executeParser(content, context, params);
            }
        }
        catch (InstantiationException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.cannotinstantiate"), args), e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notallowed"), args), e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.couldnotfind"), args));
        }
        catch (ClassCastException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notawikiplugin"), args), e);
        }
        catch (Exception e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.instantationfailed"), args), e);
        }
    }

    public static final class WikiPluginInfo
    extends WikiModuleInfo {
        private String m_className;
        private String m_alias;
        private Class m_clazz;
        private boolean m_initialized = false;

        protected static WikiPluginInfo newInstance(String className, Element el) {
            if (className == null || className.length() == 0) {
                return null;
            }
            WikiPluginInfo info = new WikiPluginInfo(className);
            info.initializeFromXML(el);
            return info;
        }

        protected void initializePlugin(WikiEngine engine) {
            if (!this.m_initialized) {
                this.m_initialized = true;
                try {
                    WikiPlugin p = this.newPluginInstance();
                    if (p instanceof InitializablePlugin) {
                        ((InitializablePlugin)((Object)p)).initialize(engine);
                    }
                }
                catch (Exception e) {
                    log.info((Object)("Cannot initialize plugin " + this.m_className), (Throwable)e);
                }
            }
        }

        protected void initializeFromXML(Element el) {
            super.initializeFromXML(el);
            this.m_alias = el.getChildText("alias");
        }

        protected static WikiPluginInfo newInstance(Class clazz) {
            WikiPluginInfo info = new WikiPluginInfo(clazz.getName());
            return info;
        }

        private WikiPluginInfo(String className) {
            super(className);
            this.setClassName(className);
        }

        private void setClassName(String fullClassName) {
            this.m_name = ClassUtils.getShortClassName((String)fullClassName);
            this.m_className = fullClassName;
        }

        public String getClassName() {
            return this.m_className;
        }

        public String getAlias() {
            return this.m_alias;
        }

        public WikiPlugin newPluginInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            if (this.m_clazz == null) {
                this.m_clazz = Class.forName(this.m_className);
            }
            return (WikiPlugin)this.m_clazz.newInstance();
        }

        public String getIncludeText(String type) {
            try {
                if (type.equals("script")) {
                    return this.getScriptText();
                }
                if (type.equals("stylesheet")) {
                    return this.getStylesheetText();
                }
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
            return null;
        }

        private String getScriptText() throws IOException {
            if (this.m_scriptText != null) {
                return this.m_scriptText;
            }
            if (this.m_scriptLocation == null) {
                return "";
            }
            try {
                this.m_scriptText = this.getTextResource(this.m_scriptLocation);
            }
            catch (IOException ex) {
                this.m_scriptText = "";
                throw ex;
            }
            return this.m_scriptText;
        }

        private String getStylesheetText() throws IOException {
            if (this.m_stylesheetText != null) {
                return this.m_stylesheetText;
            }
            if (this.m_stylesheetLocation == null) {
                return "";
            }
            try {
                this.m_stylesheetText = this.getTextResource(this.m_stylesheetLocation);
            }
            catch (IOException ex) {
                this.m_stylesheetText = "";
                throw ex;
            }
            return this.m_stylesheetText;
        }

        public String toString() {
            return "Plugin :[name=" + this.m_name + "][className=" + this.m_className + "]";
        }
    }
}

