/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.ReferenceManager;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class ReferredPagesPlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger((Class)ReferredPagesPlugin.class);
    private WikiEngine m_engine;
    private int m_depth;
    private HashSet m_exists = new HashSet();
    private StringBuffer m_result = new StringBuffer(1024);
    private PatternMatcher m_matcher = new Perl5Matcher();
    private Pattern m_includePattern;
    private Pattern m_excludePattern;
    private boolean m_formatCompact = true;
    private boolean m_formatSort = false;
    public static final String PARAM_ROOT = "page";
    public static final String PARAM_DEPTH = "depth";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_INCLUDE = "include";
    public static final String PARAM_EXCLUDE = "exclude";
    public static final String PARAM_FORMAT = "format";
    public static final int MIN_DEPTH = 1;
    public static final int MAX_DEPTH = 8;

    public String execute(WikiContext context, Map params) throws PluginException {
        String excludePattern;
        String includePattern;
        String format;
        this.m_engine = context.getEngine();
        WikiPage page = context.getPage();
        if (page == null) {
            return "";
        }
        String rootname = (String)params.get(PARAM_ROOT);
        if (rootname == null) {
            rootname = page.getName();
        }
        if ((format = (String)params.get(PARAM_FORMAT)) == null) {
            format = "";
        }
        if (format.indexOf("full") >= 0) {
            this.m_formatCompact = false;
        }
        if (format.indexOf("sort") >= 0) {
            this.m_formatSort = true;
        }
        this.m_depth = TextUtil.parseIntParameter((String)params.get(PARAM_DEPTH), 1);
        if (this.m_depth > 8) {
            this.m_depth = 8;
        }
        if ((includePattern = (String)params.get(PARAM_INCLUDE)) == null) {
            includePattern = ".*";
        }
        if ((excludePattern = (String)params.get(PARAM_EXCLUDE)) == null) {
            excludePattern = "^$";
        }
        log.debug((Object)("Fetching referred pages for " + rootname + " with a depth of " + this.m_depth + " with include pattern of " + includePattern + " with exclude pattern of " + excludePattern));
        String href = context.getViewURL(rootname);
        String title = "ReferredPagesPlugin: depth[" + this.m_depth + "] include[" + includePattern + "] exclude[" + excludePattern + "] format[" + (this.m_formatCompact ? "compact" : "full") + (this.m_formatSort ? " sort" : "") + "]";
        this.m_result.append("<div class=\"ReferredPagesPlugin\">\n");
        this.m_result.append("<a class=\"wikipage\" href=\"" + href + "\" title=\"" + title + "\">" + rootname + "</a>\n");
        this.m_exists.add(rootname);
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_includePattern = compiler.compile(includePattern);
            this.m_excludePattern = compiler.compile(excludePattern);
        }
        catch (MalformedPatternException e) {
            if (this.m_includePattern == null) {
                throw new PluginException("Illegal include pattern detected.");
            }
            if (this.m_excludePattern == null) {
                throw new PluginException("Illegal exclude pattern detected.");
            }
            throw new PluginException("Illegal internal pattern detected.");
        }
        this.getReferredPages(context, rootname, 0);
        this.m_result.append("</div>\n");
        return this.m_result.toString();
    }

    protected void getReferredPages(WikiContext context, String pagename, int depth) {
        if (depth >= this.m_depth) {
            return;
        }
        if (pagename == null) {
            return;
        }
        if (!this.m_engine.pageExists(pagename)) {
            return;
        }
        ReferenceManager mgr = this.m_engine.getReferenceManager();
        Collection allPages = mgr.findRefersTo(pagename);
        this.handleLinks(context, allPages, ++depth, pagename);
    }

    protected void handleLinks(WikiContext context, Collection links, int depth, String pagename) {
        boolean isUL = false;
        HashSet<String> localLinkSet = new HashSet<String>();
        localLinkSet.add(pagename);
        ArrayList allLinks = new ArrayList();
        if (links != null) {
            allLinks.addAll(links);
        }
        if (this.m_formatSort) {
            Collections.sort(allLinks);
        }
        Iterator i = allLinks.iterator();
        while (i.hasNext()) {
            String link = (String)i.next();
            if (localLinkSet.contains(link)) continue;
            localLinkSet.add(link);
            if (!this.m_engine.pageExists(link) || this.m_matcher.matches(link, this.m_excludePattern) || !this.m_matcher.matches(link, this.m_includePattern)) continue;
            if (this.m_exists.contains(link)) {
                if (this.m_formatCompact) continue;
                if (!isUL) {
                    isUL = true;
                    this.m_result.append("<ul>\n");
                }
                this.m_result.append("<li> " + link + " </li>\n");
                this.getReferredPages(context, link, depth);
                continue;
            }
            if (!isUL) {
                isUL = true;
                this.m_result.append("<ul>\n");
            }
            String href = context.getURL(WikiContext.VIEW, link);
            this.m_result.append("<li><a class=\"wikipage\" href=\"" + href + "\">" + link + "</a></li>\n");
            this.m_exists.add(link);
            this.getReferredPages(context, link, depth);
        }
        if (isUL) {
            this.m_result.append("</ul>\n");
        }
    }
}

