/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.ReferenceManager;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.AbstractReferralPlugin;
import com.ecyrd.jspwiki.plugin.PluginException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ReferringPagesPlugin
extends AbstractReferralPlugin {
    private static Logger log = Logger.getLogger((Class)ReferringPagesPlugin.class);
    public static final String PARAM_MAX = "max";
    public static final String PARAM_EXTRAS = "extras";
    public static final String PARAM_PAGE = "page";

    public String execute(WikiContext context, Map params) throws PluginException {
        WikiPage page;
        ReferenceManager refmgr = context.getEngine().getReferenceManager();
        String pageName = (String)params.get(PARAM_PAGE);
        ResourceBundle rb = context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
        if (pageName == null) {
            pageName = context.getPage().getName();
        }
        if ((page = context.getEngine().getPage(pageName)) != null) {
            Collection links = refmgr.findReferrers(page.getName());
            String wikitext = "";
            super.initialize(context, params);
            int items = TextUtil.parseIntParameter((String)params.get(PARAM_MAX), -1);
            String extras = (String)params.get(PARAM_EXTRAS);
            if (extras == null) {
                extras = rb.getString("referringpagesplugin.more");
            }
            log.debug((Object)("Fetching referring pages for " + page.getName() + " with a max of " + items));
            if (links != null && links.size() > 0) {
                links = this.filterCollection(links);
                wikitext = this.wikitizeCollection(links, this.m_separator, items);
                if (items < links.size() && items > 0) {
                    Object[] args = new Object[]{"" + (links.size() - items), context.getURL(WikiContext.INFO, page.getName())};
                    extras = MessageFormat.format(extras, args);
                    wikitext = wikitext + extras;
                }
            }
            if (links == null || links.size() == 0) {
                wikitext = rb.getString("referringpagesplugin.nobody");
            }
            return this.makeHTML(context, wikitext);
        }
        return "";
    }
}

