/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WeblogPlugin;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class WeblogArchivePlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger((Class)WeblogArchivePlugin.class);
    public static final String PARAM_PAGE = "page";
    private SimpleDateFormat m_monthUrlFormat;

    public String execute(WikiContext context, Map params) throws PluginException {
        WikiEngine engine = context.getEngine();
        String weblogName = (String)params.get(PARAM_PAGE);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        this.m_monthUrlFormat = new SimpleDateFormat("'" + context.getURL(WikiContext.VIEW, weblogName, "weblog.startDate='ddMMyy'&amp;weblog.days=%d") + "'");
        StringBuffer sb = new StringBuffer();
        sb.append("<div class=\"weblogarchive\">\n");
        try {
            SortedSet months = this.collectMonths(engine, weblogName);
            int year = 0;
            sb.append("<ul>\n");
            if (months.size() > 0) {
                year = ((Calendar)months.iterator().next()).get(1);
                sb.append("<li class=\"archiveyear\">" + year + "</li>\n");
            }
            Iterator i = months.iterator();
            while (i.hasNext()) {
                Calendar cal = (Calendar)i.next();
                if (cal.get(1) != year) {
                    year = cal.get(1);
                    sb.append("<li class=\"archiveyear\">" + year + "</li>\n");
                }
                sb.append("  <li>");
                sb.append(this.getMonthLink(cal));
                sb.append("</li>\n");
            }
            sb.append("</ul>\n");
            sb.append("</div>\n");
        }
        catch (ProviderException ex) {
            log.info((Object)"Cannot get archive", (Throwable)ex);
            sb.append("Cannot get archive: " + ex.getMessage());
        }
        return sb.toString();
    }

    private SortedSet collectMonths(WikiEngine engine, String page) throws ProviderException {
        ArchiveComparator comp = new ArchiveComparator();
        TreeSet<Calendar> res = new TreeSet<Calendar>(comp);
        WeblogPlugin pl = new WeblogPlugin();
        List blogEntries = pl.findBlogEntries(engine.getPageManager(), page, new Date(0L), new Date());
        Iterator i = blogEntries.iterator();
        while (i.hasNext()) {
            WikiPage p = (WikiPage)i.next();
            Date d = p.getLastModified();
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            res.add(cal);
        }
        return res;
    }

    private String getMonthLink(Calendar day) {
        String result;
        SimpleDateFormat monthfmt = new SimpleDateFormat("MMMM");
        if (this.m_monthUrlFormat == null) {
            result = monthfmt.format(day.getTime());
        } else {
            Calendar cal = (Calendar)day.clone();
            int firstDay = cal.getActualMinimum(5);
            int lastDay = cal.getActualMaximum(5);
            cal.set(5, lastDay);
            String url = this.m_monthUrlFormat.format(cal.getTime());
            url = TextUtil.replaceString(url, "%d", Integer.toString(lastDay - firstDay + 1));
            result = "<a href=\"" + url + "\">" + monthfmt.format(cal.getTime()) + "</a>";
        }
        return result;
    }

    private static class ArchiveComparator
    implements Comparator {
        private ArchiveComparator() {
        }

        public int compare(Object a2, Object b2) {
            if (a2 == null || b2 == null || !(a2 instanceof Calendar) || !(b2 instanceof Calendar)) {
                throw new ClassCastException("Invalid calendar supplied for comparison.");
            }
            Calendar ca = (Calendar)a2;
            Calendar cb = (Calendar)b2;
            if (ca.get(1) == cb.get(1) && ca.get(2) == cb.get(2)) {
                return 0;
            }
            return cb.getTime().before(ca.getTime()) ? 1 : -1;
        }
    }
}

