/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.preferences;

import com.ecyrd.jspwiki.PropertyReader;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.util.HttpUtil;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.json.JSONObject;

public class Preferences
extends HashMap {
    private static final long serialVersionUID = 1L;
    public static final String SESSIONPREFS = "prefs";

    public static void setupPreferences(PageContext pageContext) {
        HttpSession session = pageContext.getSession();
        if (session.getAttribute(SESSIONPREFS) == null) {
            Preferences.reloadPreferences(pageContext);
        }
    }

    public static void reloadPreferences(PageContext pageContext) {
        Preferences prefs = new Preferences();
        Properties props = PropertyReader.loadWebAppProps(pageContext.getServletContext());
        prefs.put("SkinName", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.skinname", "PlainVanilla"));
        prefs.put("DateFormat", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.dateformat", "dd-MMM-yyyy HH:mm"));
        prefs.put("TimeZone", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.timezone", TimeZone.getDefault().getID()));
        prefs.put("orientation", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.orientation", "fav-left"));
        prefs.put("editor", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.editor", "plain"));
        Preferences.parseJSONPreferences((HttpServletRequest)pageContext.getRequest(), prefs);
        pageContext.getSession().setAttribute(SESSIONPREFS, (Object)prefs);
    }

    private static void parseJSONPreferences(HttpServletRequest request, Preferences prefs) {
        String prefVal = TextUtil.urlDecodeUTF8(HttpUtil.retrieveCookieValue(request, "JSPWikiUserPrefs"));
        if (prefVal != null) {
            try {
                JSONObject jo = new JSONObject(prefVal);
                Iterator i = jo.keys();
                while (i.hasNext()) {
                    String key = TextUtil.replaceEntities((String)i.next());
                    prefs.put(key, jo.getString(key));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static String getPreference(WikiContext wikiContext, String name) {
        Preferences prefs = (Preferences)wikiContext.getHttpRequest().getSession().getAttribute(SESSIONPREFS);
        if (prefs != null) {
            return (String)prefs.get(name);
        }
        return null;
    }

    public static String getPreference(PageContext pageContext, String name) {
        Preferences prefs = (Preferences)pageContext.getSession().getAttribute(SESSIONPREFS);
        if (prefs != null) {
            return (String)prefs.get(name);
        }
        return null;
    }
}

