/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiAttachmentProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CachingAttachmentProvider
implements WikiAttachmentProvider {
    private static final Logger log = Logger.getLogger((Class)CachingAttachmentProvider.class);
    private WikiAttachmentProvider m_provider;
    private Cache m_cache;
    private long m_cacheMisses = 0L;
    private long m_cacheHits = 0L;
    public static final String DIR_EXTENSION = "-att";
    public static final String PROP_STORAGEDIR = "jspwiki.basicAttachmentProvider.storageDir";
    private int m_refreshPeriod = 600;

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        log.debug((Object)"Initing CachingAttachmentProvider");
        this.m_cache = new Cache(true, false, true);
        String classname = WikiEngine.getRequiredProperty(properties, "jspwiki.attachmentProvider");
        try {
            Class providerclass = ClassUtil.findClass("com.ecyrd.jspwiki.providers", classname);
            this.m_provider = (WikiAttachmentProvider)providerclass.newInstance();
            log.debug((Object)("Initializing real provider class " + this.m_provider));
            this.m_provider.initialize(engine, properties);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("no provider class");
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("faulty provider class");
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("illegal provider class");
        }
    }

    public void putAttachmentData(Attachment att, InputStream data) throws ProviderException, IOException {
        this.m_provider.putAttachmentData(att, data);
        this.m_cache.flushEntry(att.getParentName());
    }

    public InputStream getAttachmentData(Attachment att) throws ProviderException, IOException {
        return this.m_provider.getAttachmentData(att);
    }

    public Collection listAttachments(WikiPage page) throws ProviderException {
        log.debug((Object)("Listing attachments for " + page));
        try {
            Collection c = (Collection)this.m_cache.getFromCache(page.getName(), this.m_refreshPeriod);
            if (c != null) {
                log.debug((Object)("LIST from cache, " + page.getName() + ", size=" + c.size()));
                ++this.m_cacheHits;
                return this.cloneCollection(c);
            }
            log.debug((Object)("list NOT in cache, " + page.getName()));
            this.refresh(page);
        }
        catch (NeedsRefreshException nre) {
            try {
                Collection c = this.refresh(page);
                return this.cloneCollection(c);
            }
            catch (Exception ex) {
                log.warn((Object)"Provider failed, returning cached content", (Throwable)ex);
                this.m_cache.cancelUpdate(page.getName());
                return (Collection)nre.getCacheContent();
            }
        }
        return new ArrayList();
    }

    private Collection cloneCollection(Collection c) {
        ArrayList list = new ArrayList();
        list.addAll(c);
        return list;
    }

    public Collection findAttachments(QueryItem[] query) {
        return this.m_provider.findAttachments(query);
    }

    public List listAllChanged(Date timestamp) throws ProviderException {
        return this.m_provider.listAllChanged(timestamp);
    }

    private Attachment findAttachmentFromCollection(Collection c, String name) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Attachment att = (Attachment)i.next();
            if (!name.equals(att.getFileName())) continue;
            return att;
        }
        return null;
    }

    private final Collection refresh(WikiPage page) throws ProviderException {
        ++this.m_cacheMisses;
        Collection c = this.m_provider.listAttachments(page);
        this.m_cache.putInCache(page.getName(), (Object)c);
        return c;
    }

    public Attachment getAttachmentInfo(WikiPage page, String name, int version) throws ProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting attachments for " + page + ", name=" + name + ", version=" + version));
        }
        if (version != -1) {
            log.debug((Object)"...we don't cache old versions");
            return this.m_provider.getAttachmentInfo(page, name, version);
        }
        try {
            Collection c = (Collection)this.m_cache.getFromCache(page.getName(), this.m_refreshPeriod);
            if (c == null) {
                log.debug((Object)"...wasn't in the cache");
                c = this.refresh(page);
                if (c == null) {
                    return null;
                }
            } else {
                log.debug((Object)"...FOUND in the cache");
                ++this.m_cacheHits;
            }
            return this.findAttachmentFromCollection(c, name);
        }
        catch (NeedsRefreshException nre) {
            log.debug((Object)"...needs refresh");
            Collection c = null;
            try {
                c = this.refresh(page);
            }
            catch (Exception ex) {
                log.warn((Object)"Provider failed, returning cached content", (Throwable)ex);
                this.m_cache.cancelUpdate(page.getName());
                c = (Collection)nre.getCacheContent();
            }
            if (c != null) {
                return this.findAttachmentFromCollection(c, name);
            }
            return null;
        }
    }

    public List getVersionHistory(Attachment att) {
        return this.m_provider.getVersionHistory(att);
    }

    public void deleteVersion(Attachment att) throws ProviderException {
        this.m_cache.putInCache(att.getParentName(), null);
        this.m_provider.deleteVersion(att);
    }

    public void deleteAttachment(Attachment att) throws ProviderException {
        this.m_cache.putInCache(att.getParentName(), null);
        this.m_provider.deleteAttachment(att);
    }

    public synchronized String getProviderInfo() {
        return "Real provider: " + this.m_provider.getClass().getName() + ".  Cache misses: " + this.m_cacheMisses + ".  Cache hits: " + this.m_cacheHits;
    }

    public WikiAttachmentProvider getRealProvider() {
        return this.m_provider;
    }

    public void moveAttachmentsForPage(String oldParent, String newParent) throws ProviderException {
        this.m_provider.moveAttachmentsForPage(oldParent, newParent);
        this.m_cache.putInCache(newParent, null);
        this.m_cache.putInCache(oldParent, null);
    }
}

