/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.AbstractFileProvider;
import com.ecyrd.jspwiki.providers.NoSuchVersionException;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.VersioningProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class VersioningFileProvider
extends AbstractFileProvider
implements VersioningProvider {
    private static final Logger log = Logger.getLogger((Class)VersioningFileProvider.class);
    public static final String PAGEDIR = "OLD";
    public static final String PROPERTYFILE = "page.properties";
    private CachedProperties m_cachedProperties;

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        super.initialize(engine, properties);
    }

    private File findOldPageDir(String page) {
        if (page == null) {
            throw new InternalWikiException("Page may NOT be null in the provider!");
        }
        File oldpages = new File(this.getPageDirectory(), PAGEDIR);
        return new File(oldpages, this.mangleName(page));
    }

    private int findLatestVersion(String page) throws ProviderException {
        int version = -1;
        try {
            Properties props = this.getPageProperties(page);
            Iterator<Object> i = props.keySet().iterator();
            while (i.hasNext()) {
                int cutpoint;
                String key = (String)i.next();
                if (!key.endsWith(".author") || (cutpoint = key.indexOf(46)) <= 0) continue;
                String pageNum = key.substring(0, cutpoint);
                try {
                    int res = Integer.parseInt(pageNum);
                    if (res <= version) continue;
                    version = res;
                }
                catch (NumberFormatException e) {}
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to figure out latest version - dying...", (Throwable)e);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPageProperties(String page) throws IOException {
        File propertyFile = new File(this.findOldPageDir(page), PROPERTYFILE);
        if (propertyFile.exists()) {
            long lastModified = propertyFile.lastModified();
            CachedProperties cp = this.m_cachedProperties;
            if (cp != null && cp.m_page.equals(page) && cp.m_lastModified == lastModified) {
                return cp.m_props;
            }
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(propertyFile));
                Properties props = new Properties();
                props.load(in);
                cp = new CachedProperties();
                cp.m_page = page;
                cp.m_lastModified = lastModified;
                cp.m_props = props;
                this.m_cachedProperties = cp;
                Properties properties = props;
                return properties;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putPageProperties(String page, Properties properties) throws IOException {
        File propertyFile = new File(this.findOldPageDir(page), PROPERTYFILE);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(propertyFile);
            properties.store(out, " JSPWiki page properties for " + page + ". DO NOT MODIFY!");
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    private int realVersion(String page, int requestedVersion) throws NoSuchVersionException, ProviderException {
        if (requestedVersion == -1) {
            return -1;
        }
        int latest = this.findLatestVersion(page);
        if (requestedVersion == latest || requestedVersion == 1 && latest == -1) {
            return -1;
        }
        if (requestedVersion <= 0 || requestedVersion > latest) {
            throw new NoSuchVersionException("Requested version " + requestedVersion + ", but latest is " + latest);
        }
        return requestedVersion;
    }

    public synchronized String getPageText(String page, int version) throws ProviderException {
        File dir = this.findOldPageDir(page);
        if ((version = this.realVersion(page, version)) == -1) {
            return super.getPageText(page, -1);
        }
        File pageFile = new File(dir, "" + version + ".txt");
        if (!pageFile.exists()) {
            throw new NoSuchVersionException("Version " + version + "does not exist.");
        }
        return this.readFile(pageFile);
    }

    private String readFile(File pagedata) throws ProviderException {
        String result = null;
        FileInputStream in = null;
        if (pagedata.exists()) {
            if (pagedata.canRead()) {
                try {
                    in = new FileInputStream(pagedata);
                    result = FileUtil.readContents(in, this.m_encoding);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to read", (Throwable)e);
                    throw new ProviderException("I/O error: " + e.getMessage());
                }
                finally {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (Exception e) {
                        log.fatal((Object)"Closing failed", (Throwable)e);
                    }
                }
            }
            log.warn((Object)("Failed to read page from '" + pagedata.getAbsolutePath() + "', possibly a permissions problem"));
            throw new ProviderException("I cannot read the requested page.");
        }
        log.info((Object)"New page");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putPageText(WikiPage page, String text) throws ProviderException {
        File pageDir = this.findOldPageDir(page.getName());
        if (!pageDir.exists()) {
            pageDir.mkdirs();
        }
        int latest = this.findLatestVersion(page.getName());
        try {
            int versionNumber;
            File oldFile = this.findPage(page.getName());
            int n = versionNumber = latest > 0 ? latest : 1;
            if (oldFile != null && oldFile.exists()) {
                BufferedInputStream in = null;
                OutputStream out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(oldFile));
                    File pageFile = new File(pageDir, Integer.toString(versionNumber) + ".txt");
                    out = new BufferedOutputStream(new FileOutputStream(pageFile));
                    FileUtil.copyContents(in, out);
                    pageFile.setLastModified(oldFile.lastModified());
                    ++versionNumber;
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
            }
            super.putPageText(page, text);
            Properties props = this.getPageProperties(page.getName());
            props.setProperty(versionNumber + ".author", page.getAuthor() != null ? page.getAuthor() : "unknown");
            String changeNote = (String)page.getAttribute("changenote");
            if (changeNote != null) {
                props.setProperty(versionNumber + ".changenote", changeNote);
            }
            this.putPageProperties(page.getName(), props);
        }
        catch (IOException e) {
            log.error((Object)"Saving failed", (Throwable)e);
            throw new ProviderException("Could not save page text: " + e.getMessage());
        }
    }

    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        int realVersion;
        int latest = this.findLatestVersion(page);
        WikiPage p = null;
        if (version == -1 || version == latest || version == 1 && latest == -1) {
            realVersion = latest >= 0 ? latest : 1;
            p = super.getPageInfo(page, -1);
            if (p != null) {
                p.setVersion(realVersion);
            }
        } else {
            realVersion = version;
            File dir = this.findOldPageDir(page);
            if (!dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File file = new File(dir, version + ".txt");
            if (file.exists()) {
                p = new WikiPage(this.m_engine, page);
                p.setLastModified(new Date(file.lastModified()));
                p.setVersion(version);
            }
        }
        if (p != null) {
            try {
                String changenote;
                Properties props = this.getPageProperties(page);
                String author = props.getProperty(realVersion + ".author");
                if (author != null) {
                    p.setAuthor(author);
                }
                if ((changenote = props.getProperty(realVersion + ".changenote")) != null) {
                    p.setAttribute("changenote", changenote);
                }
            }
            catch (IOException e) {
                log.error((Object)("Cannot get author for page" + page + ": "), (Throwable)e);
            }
        }
        return p;
    }

    public boolean pageExists(String pageName, int version) {
        File dir = this.findOldPageDir(pageName);
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File file = new File(dir, version + ".txt");
        return file.exists();
    }

    public List getVersionHistory(String page) throws ProviderException {
        int latest;
        ArrayList<WikiPage> list = new ArrayList<WikiPage>();
        for (int i = latest = this.findLatestVersion(page); i > 0; --i) {
            WikiPage info = this.getPageInfo(page, i);
            if (info == null) continue;
            list.add(info);
        }
        return list;
    }

    public void deletePage(String page) throws ProviderException {
        super.deletePage(page);
        File dir = this.findOldPageDir(page);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles(new AbstractFileProvider.WikiFileFilter());
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
            File propfile = new File(dir, PROPERTYFILE);
            if (propfile.exists()) {
                propfile.delete();
            }
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(String page, int version) throws ProviderException {
        File dir = this.findOldPageDir(page);
        int latest = this.findLatestVersion(page);
        if (version == -1 || version == latest || version == 1 && latest == -1) {
            try {
                Properties props = this.getPageProperties(page);
                props.remove((latest > 0 ? latest : 1) + ".author");
                this.putPageProperties(page, props);
            }
            catch (IOException e) {
                log.error((Object)"Unable to modify page properties", (Throwable)e);
                throw new ProviderException("Could not modify page properties");
            }
            super.deleteVersion(page, -1);
            latest = this.findLatestVersion(page);
            File pageDir = this.findOldPageDir(page);
            File previousFile = new File(pageDir, Integer.toString(latest) + ".txt");
            InputStream in = null;
            OutputStream out = null;
            try {
                if (previousFile.exists()) {
                    in = new BufferedInputStream(new FileInputStream(previousFile));
                    File pageFile = this.findPage(page);
                    out = new BufferedOutputStream(new FileOutputStream(pageFile));
                    FileUtil.copyContents(in, out);
                    pageFile.setLastModified(previousFile.lastModified());
                }
            }
            catch (IOException e) {
                log.fatal((Object)"Something wrong with the page directory - you may have just lost data!", (Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    log.error((Object)"Closing failed", (Throwable)ex);
                }
            }
            return;
        }
        File pageFile = new File(dir, "" + version + ".txt");
        if (pageFile.exists()) {
            if (!pageFile.delete()) {
                log.error((Object)"Unable to delete page.");
            }
        } else {
            throw new NoSuchVersionException("Page " + page + ", version=" + version);
        }
    }

    public Collection getAllPages() throws ProviderException {
        Collection pages = super.getAllPages();
        ArrayList<WikiPage> returnedPages = new ArrayList<WikiPage>();
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            WikiPage page = (WikiPage)i.next();
            WikiPage info = this.getPageInfo(page.getName(), -1);
            returnedPages.add(info);
        }
        return returnedPages;
    }

    public String getProviderInfo() {
        return "";
    }

    public void movePage(String from, String to) throws ProviderException {
        File fromFile = this.findPage(from);
        File toFile = this.findPage(to);
        fromFile.renameTo(toFile);
        File fromOldDir = this.findOldPageDir(from);
        File toOldDir = this.findOldPageDir(to);
        fromOldDir.renameTo(toOldDir);
    }

    private static class CachedProperties {
        String m_page;
        Properties m_props;
        long m_lastModified;

        private CachedProperties() {
        }
    }
}

