/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.rpc.json;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import com.ecyrd.jspwiki.rpc.RPCCallable;
import com.ecyrd.jspwiki.rpc.RPCManager;
import com.ecyrd.jspwiki.ui.TemplateManager;
import com.metaparadigm.jsonrpc.InvocationCallback;
import com.metaparadigm.jsonrpc.JSONRPCBridge;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public final class JSONRPCManager
extends RPCManager {
    private static final String JSONRPCBRIDGE = "JSONRPCBridge";
    private static HashMap c_globalObjects = new HashMap();
    static /* synthetic */ Class class$com$ecyrd$jspwiki$rpc$json$JSONRPCManager$WikiJSONAccessor;

    private JSONRPCManager() {
    }

    public static String emitJSONCall(WikiContext context, RPCCallable c, String function, String params) {
        StringBuffer sb = new StringBuffer();
        sb.append("<script>");
        sb.append("var result = jsonrpc." + JSONRPCManager.getId(c) + "." + function + "(" + params + ");\r\n");
        sb.append("document.write(result);\r\n");
        sb.append("</script>");
        return sb.toString();
    }

    private static JSONRPCBridge getBridge(WikiContext context) {
        HttpSession hs;
        JSONRPCBridge bridge = null;
        HttpServletRequest req = context.getHttpRequest();
        if (req != null && (hs = req.getSession()) != null && (bridge = (JSONRPCBridge)hs.getAttribute(JSONRPCBRIDGE)) == null) {
            bridge = new JSONRPCBridge();
            hs.setAttribute(JSONRPCBRIDGE, (Object)bridge);
        }
        if (bridge == null) {
            bridge = JSONRPCBridge.getGlobalBridge();
        }
        bridge.setDebug(false);
        return bridge;
    }

    public static String registerJSONObject(WikiContext context, RPCCallable c) {
        String id = JSONRPCManager.getId(c);
        JSONRPCManager.getBridge(context).registerObject((Object)id, (Object)c);
        JSONRPCManager.requestJSON(context);
        return id;
    }

    public static void requestJSON(WikiContext context) {
        TemplateManager.addResourceRequest(context, "script", context.getURL(WikiContext.NONE, "scripts/json-rpc/jsonrpc.js"));
        String jsonurl = context.getURL(WikiContext.NONE, "JSON-RPC");
        TemplateManager.addResourceRequest(context, "jsfunction", "jsonrpc = new JSONRpcClient(\"" + jsonurl + "\");");
        JSONRPCManager.getBridge(context).registerCallback((InvocationCallback)new WikiJSONAccessor(), HttpServletRequest.class);
    }

    public static void registerGlobalObject(String id, RPCCallable object) {
        JSONRPCManager.registerGlobalObject(id, object, PagePermission.VIEW);
    }

    public static void registerGlobalObject(String id, RPCCallable object, Permission perm) {
        CallbackContainer cc = new CallbackContainer();
        cc.m_permission = perm;
        cc.m_id = id;
        cc.m_object = object;
        c_globalObjects.put(id, cc);
    }

    public static void sessionCreated(HttpSession session) {
        JSONRPCBridge bridge = (JSONRPCBridge)session.getAttribute(JSONRPCBRIDGE);
        if (bridge == null) {
            bridge = new JSONRPCBridge();
            session.setAttribute(JSONRPCBRIDGE, (Object)bridge);
        }
        WikiJSONAccessor acc = new WikiJSONAccessor();
        bridge.registerCallback((InvocationCallback)acc, HttpServletRequest.class);
        Iterator i = c_globalObjects.values().iterator();
        while (i.hasNext()) {
            CallbackContainer cc = (CallbackContainer)i.next();
            bridge.registerObject((Object)cc.m_id, (Object)cc.m_object);
        }
    }

    private static class CallbackContainer {
        String m_id;
        RPCCallable m_object;
        Permission m_permission;

        private CallbackContainer() {
        }
    }

    static class WikiJSONAccessor
    implements InvocationCallback {
        private static final long serialVersionUID = 1L;
        private static final Logger log = Logger.getLogger((Class)(class$com$ecyrd$jspwiki$rpc$json$JSONRPCManager$WikiJSONAccessor == null ? (class$com$ecyrd$jspwiki$rpc$json$JSONRPCManager$WikiJSONAccessor = JSONRPCManager.class$("com.ecyrd.jspwiki.rpc.json.JSONRPCManager$WikiJSONAccessor")) : class$com$ecyrd$jspwiki$rpc$json$JSONRPCManager$WikiJSONAccessor));

        public void postInvoke(Object context, Object instance, Method method, Object result) throws Exception {
        }

        public void preInvoke(Object context, Object instance, Method method, Object[] arguments) throws Exception {
            if (context instanceof HttpServletRequest) {
                boolean canDo = false;
                HttpServletRequest req = (HttpServletRequest)context;
                WikiEngine e = WikiEngine.getInstance(req.getSession().getServletContext(), null);
                Iterator i = c_globalObjects.values().iterator();
                while (i.hasNext()) {
                    CallbackContainer cc = (CallbackContainer)i.next();
                    if (cc.m_object != instance) continue;
                    canDo = e.getAuthorizationManager().checkPermission(WikiSession.getWikiSession(e, req), cc.m_permission);
                    break;
                }
                if (canDo) {
                    return;
                }
            }
            log.debug((Object)("Failed JSON permission check: " + instance));
            throw new WikiSecurityException("No permission to access this AJAX method!");
        }
    }
}

