/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.rss;

import com.ecyrd.jspwiki.Release;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.rss.Entry;
import com.ecyrd.jspwiki.rss.Feed;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AtomFeed
extends Feed {
    private Namespace m_atomNameSpace = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
    public static final String RFC3339FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZ";

    public AtomFeed(WikiContext c) {
        super(c);
    }

    private String getFeedID() {
        return this.m_wikiContext.getEngine().getBaseURL();
    }

    private String getEntryID(Entry e) {
        return e.getURL();
    }

    private Collection getItems() {
        ArrayList<Element> list = new ArrayList<Element>();
        WikiEngine engine = this.m_wikiContext.getEngine();
        ServletContext servletContext = null;
        if (this.m_wikiContext.getHttpRequest() != null) {
            servletContext = this.m_wikiContext.getHttpRequest().getSession().getServletContext();
        }
        Iterator i = this.m_entries.iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            WikiPage p = e.getPage();
            Element entryEl = this.getElement("entry");
            entryEl.addContent((Content)this.getElement("id").setText(this.getEntryID(e)));
            entryEl.addContent((Content)this.getElement("title").setAttribute("type", "html").setText(e.getTitle()));
            entryEl.addContent((Content)this.getElement("updated").setText(DateFormatUtils.formatUTC((Date)p.getLastModified(), (String)RFC3339FORMAT)));
            entryEl.addContent((Content)this.getElement("author").addContent((Content)this.getElement("name").setText(e.getAuthor())));
            entryEl.addContent((Content)this.getElement("link").setAttribute("rel", "alternate").setAttribute("href", e.getURL()));
            entryEl.addContent((Content)this.getElement("content").setAttribute("type", "html").setText(e.getContent()));
            if (engine.getAttachmentManager().hasAttachments(p) && servletContext != null) {
                try {
                    Collection c = engine.getAttachmentManager().listAttachments(p);
                    Iterator a2 = c.iterator();
                    while (a2.hasNext()) {
                        Attachment att = (Attachment)a2.next();
                        Element attEl = this.getElement("link");
                        attEl.setAttribute("rel", "enclosure");
                        attEl.setAttribute("href", engine.getURL(WikiContext.ATTACH, att.getName(), null, true));
                        attEl.setAttribute("length", Long.toString(att.getSize()));
                        attEl.setAttribute("type", this.getMimeType(servletContext, att.getFileName()));
                        entryEl.addContent((Content)attEl);
                    }
                }
                catch (ProviderException ex) {
                    // empty catch block
                }
            }
            list.add(entryEl);
        }
        return list;
    }

    public String getString() {
        Element root = this.getElement("feed");
        WikiEngine engine = this.m_wikiContext.getEngine();
        Date lastModified = new Date(0L);
        Iterator i = this.m_entries.iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            if (!e.getPage().getLastModified().after(lastModified)) continue;
            lastModified = e.getPage().getLastModified();
        }
        root.addContent((Content)this.getElement("title").setText(this.getChannelTitle()));
        root.addContent((Content)this.getElement("id").setText(this.getFeedID()));
        root.addContent((Content)this.getElement("updated").setText(DateFormatUtils.formatUTC((Date)lastModified, (String)RFC3339FORMAT)));
        root.addContent((Content)this.getElement("link").setAttribute("href", engine.getBaseURL()));
        root.addContent((Content)this.getElement("generator").setText("JSPWiki " + Release.VERSTR));
        String rssFeedURL = engine.getURL(WikiContext.NONE, "rss.jsp", "page=" + engine.encodeName(this.m_wikiContext.getPage().getName()) + "&mode=" + this.m_mode + "&type=atom", true);
        Element self = this.getElement("link").setAttribute("rel", "self");
        self.setAttribute("href", rssFeedURL);
        root.addContent((Content)self);
        root.addContent(this.getItems());
        XMLOutputter output = new XMLOutputter();
        output.setFormat(Format.getPrettyFormat());
        try {
            StringWriter res = new StringWriter();
            output.output(root, (Writer)res);
            return res.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private final Element getElement(String name) {
        return new Element(name, this.m_atomNameSpace);
    }
}

