/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.rss;

import com.ecyrd.jspwiki.Release;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.rss.Entry;
import com.ecyrd.jspwiki.rss.Feed;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RSS20Feed
extends Feed {
    public RSS20Feed(WikiContext context) {
        super(context);
    }

    private List getItems() {
        ArrayList<Element> list = new ArrayList<Element>();
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
        WikiEngine engine = this.m_wikiContext.getEngine();
        ServletContext servletContext = null;
        if (this.m_wikiContext.getHttpRequest() != null) {
            servletContext = this.m_wikiContext.getHttpRequest().getSession().getServletContext();
        }
        Iterator i = this.m_entries.iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            WikiPage p = e.getPage();
            String url = e.getURL();
            Element item = new Element("item");
            item.addContent((Content)new Element("link").setText(url));
            item.addContent((Content)new Element("title").setText(e.getTitle()));
            item.addContent((Content)new Element("description").setText(e.getContent()));
            if (engine.getAttachmentManager().hasAttachments(p) && servletContext != null) {
                try {
                    Collection c = engine.getAttachmentManager().listAttachments(p);
                    Iterator a2 = c.iterator();
                    while (a2.hasNext()) {
                        Attachment att = (Attachment)a2.next();
                        Element attEl = new Element("enclosure");
                        attEl.setAttribute("url", engine.getURL(WikiContext.ATTACH, att.getName(), null, true));
                        attEl.setAttribute("length", Long.toString(att.getSize()));
                        attEl.setAttribute("type", this.getMimeType(servletContext, att.getFileName()));
                        item.addContent((Content)attEl);
                    }
                }
                catch (ProviderException ex) {
                    // empty catch block
                }
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(p.getLastModified());
            cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(p.getLastModified()) ? cal.get(16) : 0)));
            item.addContent((Content)new Element("pubDate").setText(fmt.format(cal.getTime())));
            list.add(item);
        }
        return list;
    }

    public String getString() {
        WikiEngine engine = this.m_wikiContext.getEngine();
        Element root = new Element("rss");
        root.setAttribute("version", "2.0");
        Element channel = new Element("channel");
        root.addContent((Content)channel);
        channel.addContent((Content)new Element("title").setText(this.getChannelTitle()));
        channel.addContent((Content)new Element("link").setText(engine.getBaseURL()));
        channel.addContent((Content)new Element("description").setText(this.getChannelDescription()));
        channel.addContent((Content)new Element("language").setText(this.getChannelLanguage()));
        channel.addContent((Content)new Element("generator").setText("JSPWiki " + Release.VERSTR));
        String mail = engine.getVariable(this.m_wikiContext, "jspwiki.rss.author.email");
        if (mail != null) {
            String editor = engine.getVariable(this.m_wikiContext, "jspwiki.rss.author");
            if (editor != null) {
                mail = mail + " (" + editor + ")";
            }
            channel.addContent((Content)new Element("managingEditor").setText(mail));
        }
        channel.addContent((Collection)this.getItems());
        XMLOutputter output = new XMLOutputter();
        output.setFormat(Format.getPrettyFormat());
        try {
            StringWriter res = new StringWriter();
            output.output(root, (Writer)res);
            return res.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

