/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.search;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.SearchMatcher;
import com.ecyrd.jspwiki.SearchResult;
import com.ecyrd.jspwiki.SearchResultComparator;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.search.SearchProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class BasicSearchProvider
implements SearchProvider {
    private static final Logger log = Logger.getLogger((Class)BasicSearchProvider.class);
    private WikiEngine m_engine;

    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException, IOException {
        this.m_engine = engine;
    }

    public void pageRemoved(WikiPage page) {
    }

    public void reindexPage(WikiPage page) {
    }

    public QueryItem[] parseQuery(String query) {
        StringTokenizer st = new StringTokenizer(query, " \t,");
        QueryItem[] items = new QueryItem[st.countTokens()];
        int word = 0;
        log.debug((Object)("Expecting " + items.length + " items"));
        while (st.hasMoreTokens()) {
            log.debug((Object)("Item " + word));
            String token = st.nextToken().toLowerCase();
            items[word] = new QueryItem();
            switch (token.charAt(0)) {
                case '+': {
                    items[word].type = 1;
                    token = token.substring(1);
                    log.debug((Object)("Required word: " + token));
                    break;
                }
                case '-': {
                    items[word].type = -1;
                    token = token.substring(1);
                    log.debug((Object)("Forbidden word: " + token));
                    break;
                }
                default: {
                    items[word].type = 0;
                    log.debug((Object)("Requested word: " + token));
                }
            }
            items[word++].word = token;
        }
        return items;
    }

    private String attachmentNames(WikiPage page, String separator) {
        if (this.m_engine.getAttachmentManager().hasAttachments(page)) {
            Collection attachments;
            try {
                attachments = this.m_engine.getAttachmentManager().listAttachments(page);
            }
            catch (ProviderException e) {
                log.error((Object)"Unable to get attachments for page", (Throwable)e);
                return "";
            }
            StringBuffer attachmentNames = new StringBuffer();
            Iterator it = attachments.iterator();
            while (it.hasNext()) {
                Attachment att = (Attachment)it.next();
                attachmentNames.append(att.getName());
                if (!it.hasNext()) continue;
                attachmentNames.append(separator);
            }
            return attachmentNames.toString();
        }
        return "";
    }

    private Collection findPages(QueryItem[] query) {
        TreeSet<SearchResult> res = new TreeSet<SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(this.m_engine, query);
        Collection allPages = null;
        try {
            allPages = this.m_engine.getPageManager().getAllPages();
        }
        catch (ProviderException pe) {
            log.error((Object)"Unable to retrieve page list", (Throwable)pe);
            return null;
        }
        Iterator it = allPages.iterator();
        while (it.hasNext()) {
            try {
                String pageContent;
                String pageName;
                SearchResult comparison;
                WikiPage page = (WikiPage)it.next();
                if (page == null || (comparison = matcher.matchPageContent(pageName = page.getName(), pageContent = this.m_engine.getPageManager().getPageText(pageName, -1) + this.attachmentNames(page, " "))) == null) continue;
                res.add(comparison);
            }
            catch (ProviderException pe) {
                log.error((Object)"Unable to retrieve page from cache", (Throwable)pe);
            }
            catch (IOException ioe) {
                log.error((Object)"Failed to search page", (Throwable)ioe);
            }
        }
        return res;
    }

    public Collection findPages(String query) {
        return this.findPages(this.parseQuery(query));
    }

    public String getProviderInfo() {
        return "BasicSearchProvider";
    }
}

