/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.tags.WikiTagBase;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;

public class BreadcrumbsTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logger.getLogger((Class)BreadcrumbsTag.class);
    private static final String BREADCRUMBTRAIL_KEY = "breadCrumbTrail";
    private int m_maxQueueSize = 11;
    private String m_separator = ", ";

    public void initTag() {
        super.initTag();
        this.m_maxQueueSize = 11;
        this.m_separator = ", ";
    }

    public int getMaxpages() {
        return this.m_maxQueueSize;
    }

    public void setMaxpages(int maxpages) {
        this.m_maxQueueSize = maxpages + 1;
    }

    public String getSeparator() {
        return this.m_separator;
    }

    public void setSeparator(String separator) {
        this.m_separator = separator;
    }

    public int doWikiStartTag() throws IOException {
        HttpSession session = this.pageContext.getSession();
        FixedQueue trail = (FixedQueue)session.getAttribute(BREADCRUMBTRAIL_KEY);
        String page = this.m_wikiContext.getPage().getName();
        if (trail == null) {
            trail = new FixedQueue(this.m_maxQueueSize);
        }
        if (this.m_wikiContext.getRequestContext().equals(WikiContext.VIEW)) {
            if (trail.isEmpty()) {
                trail.pushItem(page);
            } else {
                if (!((String)trail.getLast()).equals(page)) {
                    trail.pushItem(page);
                    log.debug((Object)("added page: " + page));
                }
                log.debug((Object)"didn't add page because of refresh");
            }
        }
        session.setAttribute(BREADCRUMBTRAIL_KEY, (Object)trail);
        JspWriter out = this.pageContext.getOut();
        int queueSize = trail.size();
        String linkclass = "wikipage";
        String curPage = null;
        for (int i = 0; i < queueSize - 1; ++i) {
            curPage = (String)trail.get(i);
            out.print("<a class=\"" + linkclass + "\" href=\"" + this.m_wikiContext.getViewURL(curPage) + "\">" + curPage + "</a>");
            if (i >= queueSize - 2) continue;
            out.print(this.m_separator);
        }
        return 0;
    }

    public static class FixedQueue
    extends LinkedList
    implements Serializable {
        private int m_size;
        private static final long serialVersionUID = 0L;

        FixedQueue(int size) {
            this.m_size = size;
        }

        Object pushItem(Object o) {
            this.add(o);
            if (this.size() > this.m_size) {
                return this.removeFirst();
            }
            return null;
        }
    }
}

