/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.log4j.Logger;

public abstract class WikiTagBase
extends TagSupport
implements TryCatchFinally {
    public static final String ATTR_CONTEXT = "jspwiki.context";
    static Logger log = Logger.getLogger((Class)WikiTagBase.class);
    protected WikiContext m_wikiContext;

    public void setPageContext(PageContext arg0) {
        super.setPageContext(arg0);
        this.initTag();
    }

    public void initTag() {
        this.m_wikiContext = null;
    }

    public int doStartTag() throws JspException {
        try {
            this.m_wikiContext = (WikiContext)this.pageContext.getAttribute(ATTR_CONTEXT, 2);
            if (this.m_wikiContext == null) {
                throw new JspException("WikiContext may not be NULL - serious internal problem!");
            }
            return this.doWikiStartTag();
        }
        catch (Exception e) {
            log.error((Object)"Tag failed", (Throwable)e);
            throw new JspException("Tag failed, check logs: " + e.getMessage());
        }
    }

    public abstract int doWikiStartTag() throws Exception;

    public int doEndTag() throws JspException {
        return 6;
    }

    public void doCatch(Throwable arg0) throws Throwable {
    }

    public void doFinally() {
        this.m_wikiContext = null;
    }

    public void setId(String id) {
        super.setId(TextUtil.replaceEntities(id));
    }
}

