/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.auth.GroupPrincipal;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.ui.AbstractCommand;
import com.ecyrd.jspwiki.ui.Command;
import com.ecyrd.jspwiki.ui.GroupCommand;
import com.ecyrd.jspwiki.ui.PageCommand;
import com.ecyrd.jspwiki.ui.RedirectCommand;
import com.ecyrd.jspwiki.ui.WikiCommand;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public final class CommandResolver {
    private static final String PROP_SPECIALPAGE = "jspwiki.specialPage.";
    private static final Map CONTEXTS = new HashMap();
    private static final Map JSPS = new HashMap();
    private final Logger m_log = Logger.getLogger((Class)CommandResolver.class);
    private final WikiEngine m_engine;
    private final boolean m_matchEnglishPlurals;
    private final Map m_specialPages;

    public CommandResolver(WikiEngine engine, Properties properties) {
        this.m_engine = engine;
        this.m_specialPages = new HashMap();
        Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(PROP_SPECIALPAGE)) continue;
            String specialPage = key.substring(PROP_SPECIALPAGE.length());
            String jsp = (String)entry.getValue();
            if (specialPage == null || jsp == null) continue;
            specialPage = specialPage.trim();
            Command command = (Command)JSPS.get(jsp = jsp.trim());
            if (command == null) {
                Command redirect = RedirectCommand.REDIRECT;
                command = redirect.targetedCommand(jsp);
            }
            this.m_specialPages.put(specialPage, command);
        }
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty(properties, "jspwiki.translatorReader.matchEnglishPlurals", true);
    }

    public static Command findCommand(String context) {
        Command command = (Command)CONTEXTS.get(context);
        if (command == null) {
            throw new IllegalArgumentException("Unsupported wiki context: " + context + ".");
        }
        return command;
    }

    public final Command findCommand(HttpServletRequest request, String defaultContext) {
        WikiPage page;
        if (request == null) {
            return CommandResolver.findCommand(defaultContext);
        }
        Command command = null;
        String pageName = this.extractPageFromParameter(defaultContext, request);
        if (pageName != null) {
            command = (AbstractCommand)this.m_specialPages.get(pageName);
        }
        if (command == null && (command = this.extractCommandFromPath(request)) == null && (command = (AbstractCommand)CONTEXTS.get(defaultContext)) == null) {
            throw new IllegalArgumentException("Wiki context " + defaultContext + " is illegal.");
        }
        if (PageCommand.VIEW.equals(command) && pageName == null) {
            pageName = this.m_engine.getFrontPage();
        }
        if (command instanceof PageCommand && pageName != null && (page = this.resolvePage(request, pageName)) != null) {
            return command.targetedCommand(page);
        }
        String wiki = this.m_engine.getApplicationName();
        if (WikiCommand.CREATE_GROUP.equals(command)) {
            return WikiCommand.CREATE_GROUP.targetedCommand(wiki);
        }
        if (command instanceof GroupCommand) {
            String groupName = request.getParameter("group");
            if ((groupName = TextUtil.replaceEntities(groupName)) != null && groupName.length() > 0) {
                GroupPrincipal group = new GroupPrincipal(groupName);
                return command.targetedCommand(group);
            }
        }
        return command;
    }

    public final String getFinalPageName(String page) throws ProviderException {
        boolean isThere = this.simplePageExists(page);
        String finalName = page;
        if (!isThere && this.m_matchEnglishPlurals) {
            finalName = page.endsWith("s") ? page.substring(0, page.length() - 1) : finalName + "s";
            isThere = this.simplePageExists(finalName);
        }
        if (!isThere && !(isThere = this.simplePageExists(finalName = MarkupParser.wikifyLink(page))) && this.m_matchEnglishPlurals) {
            finalName = finalName.endsWith("s") ? finalName.substring(0, finalName.length() - 1) : finalName + "s";
            isThere = this.simplePageExists(finalName);
        }
        return isThere ? finalName : null;
    }

    public final String getSpecialPageReference(String page) {
        Command command = (Command)this.m_specialPages.get(page);
        if (command != null) {
            return this.m_engine.getURLConstructor().makeURL(command.getRequestContext(), command.getURLPattern(), true, null);
        }
        return null;
    }

    protected final Command extractCommandFromPath(HttpServletRequest request) {
        int questionMark;
        String jsp = request.getServletPath();
        int hashMark = jsp.indexOf(35);
        if (hashMark != -1) {
            jsp = jsp.substring(0, hashMark);
        }
        if ((questionMark = jsp.indexOf(63)) != -1) {
            jsp = jsp.substring(0, questionMark);
        }
        if (jsp.startsWith("/")) {
            jsp = jsp.substring(1);
        }
        Iterator i = this.m_specialPages.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Command specialCommand = (Command)entry.getValue();
            if (!specialCommand.getJSP().equals(jsp)) continue;
            return specialCommand;
        }
        if (jsp.length() > 0 && JSPS.containsKey(jsp)) {
            return (Command)JSPS.get(jsp);
        }
        return null;
    }

    protected final String extractPageFromParameter(String requestContext, HttpServletRequest request) {
        block5: {
            try {
                String page = this.m_engine.getURLConstructor().parsePage(requestContext, request, this.m_engine.getContentEncoding());
                if (page == null) break block5;
                try {
                    String finalPage = this.getFinalPageName(page);
                    if (finalPage != null) {
                        page = finalPage;
                    }
                }
                catch (ProviderException e) {
                    // empty catch block
                }
                return page;
            }
            catch (IOException e) {
                this.m_log.error((Object)"Unable to create context", (Throwable)e);
                throw new InternalWikiException("Big internal booboo, please check logs.");
            }
        }
        return null;
    }

    protected final WikiPage resolvePage(HttpServletRequest request, String page) {
        WikiPage wikipage;
        int version = -1;
        String rev = request.getParameter("version");
        if (rev != null) {
            version = Integer.parseInt(rev);
        }
        if ((wikipage = this.m_engine.getPage(page, version)) == null) {
            page = MarkupParser.cleanLink(page);
            wikipage = new WikiPage(this.m_engine, page);
        }
        return wikipage;
    }

    protected final boolean simplePageExists(String page) throws ProviderException {
        if (this.m_specialPages.containsKey(page)) {
            return true;
        }
        return this.m_engine.getPageManager().pageExists(page);
    }

    static {
        Command[] commands = AbstractCommand.allCommands();
        for (int i = 0; i < commands.length; ++i) {
            JSPS.put(commands[i].getJSP(), commands[i]);
            CONTEXTS.put(commands[i].getRequestContext(), commands[i]);
        }
    }
}

