/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.NoSuchVariableException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.modules.ModuleManager;
import com.ecyrd.jspwiki.modules.WikiModuleInfo;
import com.ecyrd.jspwiki.preferences.Preferences;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class EditorManager
extends ModuleManager {
    public static final String PROP_EDITORTYPE = "jspwiki.editor";
    public static final String PARA_EDITOR = "editor";
    public static final String EDITOR_PLAIN = "plain";
    public static final String EDITOR_PREVIEW = "preview";
    public static final String REQ_EDITEDTEXT = "_editedtext";
    public static final String ATTR_EDITEDTEXT = "_editedtext";
    private Map m_editors;
    private static Logger log = Logger.getLogger((Class)EditorManager.class);

    public EditorManager(WikiEngine engine) {
        super(engine);
    }

    public void initialize(Properties props) {
        this.registerEditors();
    }

    private void registerEditors() {
        log.info((Object)"Registering editor modules");
        this.m_editors = new HashMap();
        SAXBuilder builder = new SAXBuilder();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("ini/jspwiki_module.xml");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    log.debug((Object)("Processing XML: " + resource));
                    Document doc = builder.build(resource);
                    List plugins = XPath.selectNodes((Object)doc, (String)"/modules/editor");
                    Iterator i = plugins.iterator();
                    while (i.hasNext()) {
                        Element pluginEl = (Element)i.next();
                        String name = pluginEl.getAttributeValue("name");
                        WikiEditorInfo info = WikiEditorInfo.newInstance(name, pluginEl);
                        if (this.checkCompatibility(info)) {
                            this.m_editors.put(name, info);
                            log.debug((Object)("Registered editor " + name));
                            continue;
                        }
                        log.info((Object)("Editor '" + name + "' not compatible with this version of JSPWiki."));
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Couldn't load ini/jspwiki_module.xml resources: " + resource), (Throwable)e);
                }
                catch (JDOMException e) {
                    log.error((Object)"Error parsing XML for plugin: ini/jspwiki_module.xml");
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Couldn't load all ini/jspwiki_module.xml resources", (Throwable)e);
        }
    }

    public String getEditorName(WikiContext context) {
        if (context.getRequestContext().equals(WikiContext.PREVIEW)) {
            return EDITOR_PREVIEW;
        }
        String editor = null;
        editor = Preferences.getPreference(context, PARA_EDITOR);
        if (editor == null) {
            try {
                editor = this.m_engine.getVariableManager().getValue(context, PROP_EDITORTYPE);
            }
            catch (NoSuchVariableException e) {
                // empty catch block
            }
        }
        if (editor != null) {
            String[] editorlist = this.getEditorList();
            editor = editor.trim();
            for (int i = 0; i < editorlist.length; ++i) {
                if (!editorlist[i].equalsIgnoreCase(editor)) continue;
                return editorlist[i];
            }
        }
        return EDITOR_PLAIN;
    }

    public String[] getEditorList() {
        String[] editors = new String[this.m_editors.size()];
        Set keys = this.m_editors.keySet();
        return keys.toArray(editors);
    }

    public String getEditorPath(WikiContext context) {
        String path = null;
        String editor = this.getEditorName(context);
        WikiEditorInfo ed = (WikiEditorInfo)this.m_editors.get(editor);
        path = ed != null ? ed.getPath() : "editors/" + editor + ".jsp";
        return path;
    }

    public static String getEditedText(PageContext ctx) {
        String usertext = ctx.getRequest().getParameter("_editedtext");
        if (usertext == null) {
            usertext = (String)ctx.findAttribute("_editedtext");
        }
        return usertext;
    }

    public Collection modules() {
        ArrayList ls = new ArrayList();
        ls.addAll(this.m_editors.values());
        return ls;
    }

    private static final class WikiEditorInfo
    extends WikiModuleInfo {
        private String m_path;

        protected static WikiEditorInfo newInstance(String name, Element el) {
            if (name == null || name.length() == 0) {
                return null;
            }
            WikiEditorInfo info = new WikiEditorInfo(name);
            info.initializeFromXML(el);
            return info;
        }

        protected void initializeFromXML(Element el) {
            super.initializeFromXML(el);
            this.m_path = el.getChildText("path");
        }

        private WikiEditorInfo(String name) {
            super(name);
        }

        public String getPath() {
            return this.m_path;
        }
    }
}

