/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.WikiSession;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InputValidator {
    public static final int STANDARD = 0;
    public static final int EMAIL = 1;
    public static final int ID = 2;
    protected static final Pattern EMAIL_PATTERN = Pattern.compile("^[0-9a-zA-Z-_\\.\\+]+@([0-9a-zA-Z-_]+\\.)+[a-zA-Z]+$");
    protected static final Pattern UNSAFE_PATTERN = Pattern.compile("[\\x00\\r\\n\\x0f\"':<>;&@\\xff{}\\$%\\\\]");
    protected static final Pattern ID_PATTERN = Pattern.compile("[\\x00\\r\\n\\x0f\"'<>;&\\xff{}]");
    private final String m_form;
    private final WikiSession m_session;

    public InputValidator(String form, WikiSession session) {
        this.m_form = form;
        this.m_session = session;
    }

    public final boolean validateNotNull(String input2, String label) {
        return this.validateNotNull(input2, label, 0);
    }

    public final boolean validateNotNull(String input2, String label, int type) {
        if (InputValidator.isBlank(input2)) {
            ResourceBundle rb = ResourceBundle.getBundle("CoreResources", this.m_session.getLocale());
            Object[] args = new Object[]{label};
            this.m_session.addMessage(this.m_form, MessageFormat.format(rb.getString("validate.cantbenull"), args));
            return false;
        }
        return this.validate(input2, label, type) && !InputValidator.isBlank(input2);
    }

    public final boolean validate(String input2, String label, int type) {
        if (InputValidator.isBlank(input2)) {
            return true;
        }
        ResourceBundle rb = ResourceBundle.getBundle("CoreResources", this.m_session.getLocale());
        switch (type) {
            case 0: {
                boolean valid;
                Matcher matcher = UNSAFE_PATTERN.matcher(input2);
                boolean bl = valid = !matcher.find();
                if (!valid) {
                    Object[] args = new Object[]{label, "&quot;&#39;&lt;&gt;;&amp;\\@{}%$"};
                    this.m_session.addMessage(this.m_form, MessageFormat.format(rb.getString("validate.unsafechars"), args));
                }
                return valid;
            }
            case 1: {
                Matcher matcher = EMAIL_PATTERN.matcher(input2);
                boolean valid = matcher.matches();
                if (!valid) {
                    Object[] args = new Object[]{label};
                    this.m_session.addMessage(this.m_form, MessageFormat.format(rb.getString("validate.invalidemail"), args));
                }
                return valid;
            }
            case 2: {
                boolean valid;
                Matcher matcher = ID_PATTERN.matcher(input2);
                boolean bl = valid = !matcher.find();
                if (!valid) {
                    Object[] args = new Object[]{label, "&quot;&#39;&lt;&gt;;&amp;{}"};
                    this.m_session.addMessage(this.m_form, MessageFormat.format(rb.getString("validate.unsafechars"), args));
                }
                return valid;
            }
        }
        throw new IllegalArgumentException("Invalid input type.");
    }

    public static final boolean isBlank(String input2) {
        return input2 == null || input2.trim().length() < 1;
    }
}

