/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.modules.ModuleManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TemplateManager
extends ModuleManager {
    private static final String SKIN_DIRECTORY = "skins";
    public static final String RESOURCE_JSFUNCTION = "jsfunction";
    public static final String RESOURCE_JSLOCALIZEDSTRINGS = "jslocalizedstrings";
    public static final String RESOURCE_STYLESHEET = "stylesheet";
    public static final String RESOURCE_SCRIPT = "script";
    public static final String RESOURCE_INLINECSS = "inlinecss";
    public static final String DIRECTORY = "templates";
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String PROPERTYFILE = "template.properties";
    public static final String RESOURCE_INCLUDES = "jspwiki.resourceincludes";
    protected static final Logger log = Logger.getLogger((Class)TemplateManager.class);
    public static final String RESOURCE_HTTPHEADER = "httpheader";

    public TemplateManager(WikiEngine engine, Properties properties) {
        super(engine);
    }

    public boolean templateExists(String templateName) {
        ServletContext context = this.m_engine.getServletContext();
        InputStream in = context.getResourceAsStream(TemplateManager.getPath(templateName) + "ViewTemplate.jsp");
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private static String findResource(ServletContext sContext, String name) {
        InputStream is = sContext.getResourceAsStream(name);
        if (is == null) {
            String defname = TemplateManager.makeFullJSPName(DEFAULT_TEMPLATE, TemplateManager.removeTemplatePart(name));
            is = sContext.getResourceAsStream(defname);
            name = is != null ? defname : null;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return name;
    }

    private static String findResource(ServletContext sContext, String template, String name) {
        if (name.charAt(0) == '/') {
            return TemplateManager.findResource(sContext, name);
        }
        String fullname = TemplateManager.makeFullJSPName(template, name);
        return TemplateManager.findResource(sContext, fullname);
    }

    public String findJSP(PageContext pageContext, String name) {
        ServletContext sContext = pageContext.getServletContext();
        return TemplateManager.findResource(sContext, name);
    }

    private static final String removeTemplatePart(String name) {
        int idx = name.indexOf(47);
        if (idx != -1 && (idx = name.indexOf(47, idx)) != -1) {
            return name.substring(idx + 1);
        }
        return name;
    }

    private static final String makeFullJSPName(String template, String name) {
        return "/templates/" + template + "/" + name;
    }

    public String findJSP(PageContext pageContext, String template, String name) {
        if (name == null || template == null) {
            log.fatal((Object)("findJSP() was asked to find a null template or name (" + template + "," + name + ")." + " JSP page '" + ((HttpServletRequest)pageContext.getRequest()).getRequestURI() + "'"));
            throw new InternalWikiException("Illegal arguments to findJSP(); please check logs.");
        }
        return TemplateManager.findResource(pageContext.getServletContext(), template, name);
    }

    public String findResource(WikiContext ctx, String template, String name) {
        if (this.m_engine.getServletContext() != null) {
            return TemplateManager.findResource(this.m_engine.getServletContext(), template, name);
        }
        return TemplateManager.getPath(template) + "/" + name;
    }

    private static final String getPath(String template) {
        return "/templates/" + template + "/";
    }

    public Set listSkins(PageContext pageContext, String template) {
        String place = TemplateManager.makeFullJSPName(template, SKIN_DIRECTORY);
        ServletContext sContext = pageContext.getServletContext();
        Set skinSet = sContext.getResourcePaths(place);
        TreeSet<String> resultSet = new TreeSet<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listings skins from " + place));
        }
        if (skinSet != null) {
            String[] skins = new String[]{};
            skins = skinSet.toArray(skins);
            for (int i = 0; i < skins.length; ++i) {
                String[] s = StringUtils.split((String)skins[i], (String)"/");
                if (s.length <= 2 || !skins[i].endsWith("/")) continue;
                String skinName = s[s.length - 1];
                resultSet.add(skinName);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("...adding skin '" + skinName + "'"));
            }
        }
        return resultSet;
    }

    public static String getMarker(WikiContext context, String type) {
        if (type.equals(RESOURCE_JSLOCALIZEDSTRINGS)) {
            return TemplateManager.getJSLocalizedStrings(context);
        }
        if (type.equals(RESOURCE_JSFUNCTION)) {
            return "/* INCLUDERESOURCES (" + type + ") */";
        }
        return "<!-- INCLUDERESOURCES (" + type + ") -->";
    }

    private static String getJSLocalizedStrings(WikiContext context) {
        StringBuffer sb = new StringBuffer();
        sb.append("var LocalizedStrings = {\n");
        ResourceBundle rb = context.getBundle("templates.default");
        boolean first = true;
        Enumeration<String> en = rb.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!key.startsWith("javascript")) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",\n");
            }
            sb.append("\"" + key + "\":\"" + rb.getString(key) + "\"");
        }
        sb.append("\n};\n");
        return sb.toString();
    }

    public static void addResourceRequest(WikiContext ctx, String type, String resource) {
        Vector<String> resources;
        HashMap resourcemap = (HashMap)ctx.getVariable(RESOURCE_INCLUDES);
        if (resourcemap == null) {
            resourcemap = new HashMap();
        }
        if ((resources = (Vector<String>)resourcemap.get(type)) == null) {
            resources = new Vector<String>();
        }
        String resourceString = null;
        if (type.equals(RESOURCE_SCRIPT)) {
            resourceString = "<script type='text/javascript' src='" + resource + "'></script>";
        } else if (type.equals(RESOURCE_STYLESHEET)) {
            resourceString = "<link rel='stylesheet' type='text/css' href='" + resource + "' />";
        } else if (type.equals(RESOURCE_INLINECSS)) {
            resourceString = "<style type='text/css'>\n" + resource + "\n</style>\n";
        } else if (type.equals(RESOURCE_JSFUNCTION)) {
            resourceString = resource;
        } else if (type.equals(RESOURCE_HTTPHEADER)) {
            resourceString = resource;
        }
        if (resourceString != null) {
            resources.add(resourceString);
        }
        log.debug((Object)("Request to add a resource: " + resourceString));
        resourcemap.put(type, resources);
        ctx.setVariable(RESOURCE_INCLUDES, resourcemap);
    }

    public static String[] getResourceRequests(WikiContext ctx, String type) {
        HashMap hm = (HashMap)ctx.getVariable(RESOURCE_INCLUDES);
        if (hm == null) {
            return new String[0];
        }
        Vector resources = (Vector)hm.get(type);
        if (resources == null) {
            return new String[0];
        }
        String[] res = new String[resources.size()];
        return resources.toArray(res);
    }

    public static String[] getResourceTypes(WikiContext ctx) {
        HashMap hm;
        String[] res = new String[]{};
        if (ctx != null && (hm = (HashMap)ctx.getVariable(RESOURCE_INCLUDES)) != null) {
            Set keys = hm.keySet();
            res = keys.toArray(res);
        }
        return res;
    }

    public Collection modules() {
        return new ArrayList();
    }
}

