/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiPageEvent;
import com.ecyrd.jspwiki.ui.TemplateManager;
import com.ecyrd.jspwiki.ui.WikiServletFilter;
import com.ecyrd.jspwiki.url.DefaultURLConstructor;
import com.ecyrd.jspwiki.util.WatchDog;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.log4j.NDC;

public class WikiJSPFilter
extends WikiServletFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        WatchDog w = this.m_engine.getCurrentWatchDog();
        try {
            NDC.push((String)(this.m_engine.getApplicationName() + ":" + ((HttpServletRequest)request).getRequestURI()));
            w.enterState("Filtering for URL " + ((HttpServletRequest)request).getRequestURI(), 90);
            MyServletResponseWrapper responseWrapper = new MyServletResponseWrapper((HttpServletResponse)response);
            String pagename = DefaultURLConstructor.parsePageFromURL((HttpServletRequest)request, response.getCharacterEncoding());
            this.fireEvent(24, pagename);
            super.doFilter(request, (ServletResponse)responseWrapper, chain);
            try {
                w.enterState("Delivering response", 30);
                WikiContext wikiContext = this.getWikiContext(request);
                String r = this.filter(wikiContext, (HttpServletResponse)responseWrapper);
                response.getWriter().write(r);
                if (wikiContext != null) {
                    wikiContext.getWikiSession().clearMessages();
                }
                this.fireEvent(25, pagename);
            }
            finally {
                w.exitState();
            }
        }
        finally {
            w.exitState();
            NDC.pop();
            NDC.remove();
        }
    }

    private String filter(WikiContext wikiContext, HttpServletResponse response) {
        String string = response.toString();
        if (wikiContext != null) {
            String[] resourceTypes = TemplateManager.getResourceTypes(wikiContext);
            for (int i = 0; i < resourceTypes.length; ++i) {
                string = this.insertResources(wikiContext, string, resourceTypes[i]);
            }
            String[] headers = TemplateManager.getResourceRequests(wikiContext, "httpheader");
            for (int i = 0; i < headers.length; ++i) {
                String key = headers[i];
                String value = "";
                int split = headers[i].indexOf(58);
                if (split > 0 && split < headers[i].length() - 1) {
                    key = headers[i].substring(0, split);
                    value = headers[i].substring(split + 1);
                }
                response.addHeader(key.trim(), value.trim());
            }
        }
        return string;
    }

    private String insertResources(WikiContext wikiContext, String string, String type) {
        if (wikiContext == null) {
            return string;
        }
        String marker = TemplateManager.getMarker(wikiContext, type);
        int idx = string.indexOf(marker);
        if (idx == -1) {
            return string;
        }
        log.debug((Object)"...Inserting...");
        String[] resources = TemplateManager.getResourceRequests(wikiContext, type);
        StringBuffer concat = new StringBuffer(resources.length * 40);
        for (int i = 0; i < resources.length; ++i) {
            log.debug((Object)("...:::" + resources[i]));
            concat.append(resources[i]);
        }
        string = TextUtil.replaceString(string, idx, idx + marker.length(), concat.toString());
        return string;
    }

    protected final void fireEvent(int type, String pagename) {
        if (WikiEventManager.isListening(this.m_engine)) {
            WikiEventManager.fireEvent(this.m_engine, new WikiPageEvent(this.m_engine, type, pagename));
        }
    }

    private static class MyServletResponseWrapper
    extends HttpServletResponseWrapper {
        private CharArrayWriter m_output = new CharArrayWriter(4096);
        private static final int INIT_BUFFER_SIZE = 4096;

        public MyServletResponseWrapper(HttpServletResponse r) {
            super(r);
        }

        public PrintWriter getWriter() {
            return new PrintWriter(this.m_output);
        }

        public ServletOutputStream getOutputStream() {
            return new MyServletOutputStream(this.m_output);
        }

        public String toString() {
            return this.m_output.toString();
        }

        class MyServletOutputStream
        extends ServletOutputStream {
            CharArrayWriter m_buffer;

            public MyServletOutputStream(CharArrayWriter aCharArrayWriter) {
                this.m_buffer = aCharArrayWriter;
            }

            public void write(int aInt) {
                this.m_buffer.write(aInt);
            }
        }
    }
}

