/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class WikiServletFilter
implements Filter {
    protected static final Logger log = Logger.getLogger((Class)WikiServletFilter.class);
    protected WikiEngine m_engine = null;

    public void init(FilterConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        this.m_engine = WikiEngine.getInstance(context, null);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (chain == null) {
            throw new ServletException("FilterChain is null, even if it should not be.  Please report this to the jspwiki development team.");
        }
        if (this.m_engine == null) {
            PrintWriter out = response.getWriter();
            out.print("<html><head><title>Fatal problem with JSPWiki</title></head>");
            out.print("<body>");
            out.print("<h1>JSPWiki has not been started</h1>");
            out.print("<p>JSPWiki is not running.  This is probably due to a configuration error in your jspwiki.properties file, ");
            out.print("or a problem with your servlet container.  Please double-check everything before issuing a bug report ");
            out.print("at jspwiki.org.</p>");
            out.print("<p>We apologize for the inconvenience.  No, really, we do.  We're trying to ");
            out.print("JSPWiki as easy as we can, but there is only so much we have time to test ");
            out.print("platforms.</p>");
            out.print("</body>");
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        httpRequest.setCharacterEncoding(this.m_engine.getContentEncoding());
        try {
            NDC.push((String)(this.m_engine.getApplicationName() + ":" + httpRequest.getRequestURL()));
            chain.doFilter(request, response);
        }
        finally {
            NDC.pop();
            NDC.remove();
        }
    }

    protected WikiContext getWikiContext(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        WikiContext ctx = (WikiContext)httpRequest.getAttribute("jspwiki.context");
        return ctx;
    }
}

