/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui.admin.beans;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.search.SearchManager;
import com.ecyrd.jspwiki.ui.admin.SimpleAdminBean;
import com.ecyrd.jspwiki.ui.progress.ProgressItem;
import com.ecyrd.jspwiki.util.WikiBackgroundThread;
import java.util.Collection;
import java.util.Iterator;
import javax.management.NotCompliantMBeanException;
import org.apache.log4j.Logger;

public class SearchManagerBean
extends SimpleAdminBean {
    private static final String PROGRESS_ID = "searchmanagerbean.reindexer";
    public static final String[] METHODS = new String[]{"reload"};
    private static Logger log = Logger.getLogger((Class)SearchManagerBean.class);
    private WikiBackgroundThread m_updater;

    public SearchManagerBean(WikiEngine engine) throws NotCompliantMBeanException {
        this.initialize(engine);
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public String[] getMethodNames() {
        return METHODS;
    }

    public String getTitle() {
        return "Search manager";
    }

    public synchronized void reload() {
        if (this.m_updater == null) {
            this.m_updater = new WikiBackgroundThread(this.m_engine, 0){
                int m_count;
                int m_max;

                public void startupTask() throws Exception {
                    super.startupTask();
                    this.setName("Reindexer started");
                }

                public void backgroundTask() throws Exception {
                    Collection allPages = SearchManagerBean.this.m_engine.getPageManager().getAllPages();
                    SearchManager mgr = SearchManagerBean.this.m_engine.getSearchManager();
                    this.m_max = allPages.size();
                    ProgressItem pi = new ProgressItem(){

                        public int getProgress() {
                            return 100 * m_count / m_max;
                        }
                    };
                    SearchManagerBean.this.m_engine.getProgressManager().startProgress(pi, SearchManagerBean.PROGRESS_ID);
                    Iterator i = allPages.iterator();
                    while (i.hasNext()) {
                        WikiPage page = (WikiPage)i.next();
                        mgr.reindexPage(page);
                        ++this.m_count;
                    }
                    SearchManagerBean.this.m_engine.getProgressManager().stopProgress(SearchManagerBean.PROGRESS_ID);
                    this.shutdown();
                    SearchManagerBean.this.m_updater = null;
                }
            };
            this.m_updater.start();
        }
    }

    public int getType() {
        return 1;
    }

    public String doGet(WikiContext context) {
        if (this.m_updater != null) {
            return "Update already in progress (" + context.getEngine().getProgressManager().getProgress(PROGRESS_ID) + "%)";
        }
        return "<input type='submit' id='searchmanagerbean-reload' name='searchmanagerbean-reload' value='Force index reload'/><div class='description'>Forces JSPWiki search engine to reindex all pages.  Use this if you think some pages are not being found even if they should.</div>";
    }

    public String doPost(WikiContext context) {
        String val = context.getHttpParameter("searchmanagerbean-reload");
        if (val != null) {
            this.reload();
            context.getWikiSession().addMessage("Started reload of all indexed pages...");
            return "";
        }
        return this.doGet(context);
    }
}

