/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui.progress;

import com.ecyrd.jspwiki.rpc.RPCCallable;
import com.ecyrd.jspwiki.rpc.json.JSONRPCManager;
import com.ecyrd.jspwiki.ui.progress.ProgressItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.safehaus.uuid.UUIDGenerator;

public class ProgressManager {
    private Map m_progressingTasks = new HashMap();
    public static final String JSON_PROGRESSTRACKER = "progressTracker";
    private static Logger log = Logger.getLogger((Class)ProgressManager.class);

    public ProgressManager() {
        JSONRPCManager.registerGlobalObject(JSON_PROGRESSTRACKER, new JSONTracker());
    }

    public String getNewProgressIdentifier() {
        return UUIDGenerator.getInstance().generateRandomBasedUUID().toString();
    }

    public void startProgress(ProgressItem pi, String id) {
        log.debug((Object)("Adding " + id + " to progress queue"));
        this.m_progressingTasks.put(id, pi);
        pi.setState(1);
    }

    public void stopProgress(String id) {
        log.debug((Object)("Removed " + id + " from progress queue"));
        ProgressItem pi = (ProgressItem)this.m_progressingTasks.remove(id);
        if (pi != null) {
            pi.setState(2);
        }
    }

    public int getProgress(String id) throws IllegalArgumentException {
        ProgressItem pi = (ProgressItem)this.m_progressingTasks.get(id);
        if (pi != null) {
            return pi.getProgress();
        }
        throw new IllegalArgumentException("No such id was found");
    }

    public class JSONTracker
    implements RPCCallable {
        public int getProgress(String progressId) {
            return ProgressManager.this.getProgress(progressId);
        }
    }
}

