/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.util;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public final class MailUtil {
    private static final String JAVA_COMP_ENV = "java:comp/env";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static boolean c_useJndi = true;
    public static final String PROP_MAIL_AUTH = "mail.smtp.auth";
    protected static final Logger log = Logger.getLogger((Class)MailUtil.class);
    protected static final String DEFAULT_MAIL_JNDI_NAME = "mail/Session";
    protected static final String DEFAULT_MAIL_HOST = "localhost";
    protected static final String DEFAULT_MAIL_PORT = "25";
    protected static final String DEFAULT_MAIL_TIMEOUT = "5000";
    protected static final String DEFAULT_SENDER = "jspwiki@localhost";
    protected static final String PROP_MAIL_JNDI_NAME = "jspwiki.mail.jndiname";
    protected static final String PROP_MAIL_HOST = "mail.smtp.host";
    protected static final String PROP_MAIL_PORT = "mail.smtp.port";
    protected static final String PROP_MAIL_ACCOUNT = "mail.smtp.account";
    protected static final String PROP_MAIL_PASSWORD = "mail.smtp.password";
    protected static final String PROP_MAIL_TIMEOUT = "mail.smtp.timeout";
    protected static final String PROP_MAIL_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    protected static final String PROP_MAIL_TRANSPORT = "smtp";
    protected static final String PROP_MAIL_SENDER = "mail.from";
    protected static final String PROP_MAIL_STARTTLS = "mail.smtp.starttls.enable";

    private MailUtil() {
    }

    public static void sendMessage(WikiEngine engine, String to, String subject, String content) throws AddressException, MessagingException {
        String from = engine.getWikiProperties().getProperty(PROP_MAIL_SENDER, DEFAULT_SENDER).trim();
        MailUtil.sendMessage(engine, to, from, subject, content);
    }

    public static void sendMessage(WikiEngine engine, String to, String from, String subject, String content) throws MessagingException {
        Properties props = engine.getWikiProperties();
        String jndiName = props.getProperty(PROP_MAIL_JNDI_NAME, DEFAULT_MAIL_JNDI_NAME).trim();
        Session session = null;
        if (c_useJndi) {
            try {
                session = MailUtil.getJNDIMailSession(jndiName);
                c_useJndi = false;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        if (session == null) {
            session = MailUtil.getStandaloneMailSession(props);
        }
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            msg.setSubject(subject);
            msg.setText(content, "UTF-8");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            if (log.isInfoEnabled()) {
                log.info((Object)("Sent e-mail to=" + to + ", subject=\"" + subject + "\", jndi=" + (c_useJndi ? TRUE : FALSE)));
            }
        }
        catch (MessagingException e) {
            log.error((Object)e);
            throw e;
        }
    }

    protected static Session getStandaloneMailSession(Properties props) {
        String host = props.getProperty(PROP_MAIL_HOST, DEFAULT_MAIL_HOST);
        String port = props.getProperty(PROP_MAIL_PORT, DEFAULT_MAIL_PORT);
        String account = props.getProperty(PROP_MAIL_ACCOUNT);
        String password = props.getProperty(PROP_MAIL_PASSWORD);
        boolean starttls = TextUtil.getBooleanProperty(props, PROP_MAIL_STARTTLS, true);
        boolean useAuthentication = account != null && account.length() > 0;
        Properties mailProps = new Properties();
        mailProps.put(PROP_MAIL_HOST, host);
        mailProps.put(PROP_MAIL_PORT, port);
        mailProps.put(PROP_MAIL_TIMEOUT, DEFAULT_MAIL_TIMEOUT);
        mailProps.put(PROP_MAIL_CONNECTION_TIMEOUT, DEFAULT_MAIL_TIMEOUT);
        mailProps.put(PROP_MAIL_STARTTLS, starttls ? TRUE : FALSE);
        Session session = null;
        if (useAuthentication) {
            mailProps.put(PROP_MAIL_AUTH, TRUE);
            SmtpAuthenticator auth = new SmtpAuthenticator(account, password);
            session = Session.getInstance((Properties)mailProps, (Authenticator)auth);
        } else {
            session = Session.getInstance((Properties)mailProps);
        }
        if (log.isDebugEnabled()) {
            String mailServer = host + ":" + port + ", auth=" + (useAuthentication ? TRUE : FALSE);
            log.debug((Object)("JavaMail session obtained from standalone mail factory: " + mailServer));
        }
        return session;
    }

    protected static Session getJNDIMailSession(String jndiName) throws NamingException {
        Session session = null;
        try {
            InitialContext initCtx = new InitialContext();
            Context ctx = (Context)initCtx.lookup(JAVA_COMP_ENV);
            session = (Session)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            log.warn((Object)("JavaMail initialization error: " + e.getMessage()));
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JavaMail session obtained from JNDI mail factory: " + jndiName));
        }
        return session;
    }

    protected static class SmtpAuthenticator
    extends Authenticator {
        private static final String BLANK = "";
        private final String m_pass;
        private final String m_login;

        public SmtpAuthenticator(String login, String pass) {
            this.m_login = login == null ? BLANK : login;
            this.m_pass = pass == null ? BLANK : pass;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            if (BLANK.equals(this.m_pass)) {
                return null;
            }
            return new PasswordAuthentication(this.m_login, this.m_pass);
        }
    }
}

