/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.util;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.VersioningFileProvider;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;

public class ProviderConverter {
    private String m_rcsSourceDir;
    private static final String[] WINDOWS_DEVICE_NAMES = new String[]{"con", "prn", "nul", "aux", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9"};

    protected void setRCSSourceDir(String dir) {
        this.m_rcsSourceDir = dir;
    }

    protected String mangleName(String pagename) {
        pagename = TextUtil.urlEncode(pagename, "UTF-8");
        pagename = TextUtil.replaceString(pagename, "/", "%2F");
        if (SystemUtils.IS_OS_WINDOWS) {
            String pn = pagename.toLowerCase();
            for (int i = 0; i < WINDOWS_DEVICE_NAMES.length; ++i) {
                if (!WINDOWS_DEVICE_NAMES[i].equals(pn)) continue;
                pagename = "$$$" + pagename;
            }
        }
        return pagename;
    }

    protected void convert() throws WikiException, IOException {
        Properties props = new Properties();
        props.setProperty("jspwiki.applicationName", "JSPWikiConvert");
        props.setProperty("jspwiki.fileSystemProvider.pageDir", this.m_rcsSourceDir);
        props.setProperty("jspwiki.pageProvider", "RCSFileProvider");
        props.setProperty("jspwiki.usePageCache", "false");
        props.setProperty("log4j.appender.outlog", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.outlog.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("jspwiki.useLucene", "false");
        props.setProperty("log4j.rootCategory", "INFO,outlog");
        WikiEngine engine = new WikiEngine(props);
        WikiPageProvider sourceProvider = engine.getPageManager().getProvider();
        File tmpDir = new File(SystemUtils.JAVA_IO_TMPDIR, "converter-tmp");
        props.setProperty("jspwiki.fileSystemProvider.pageDir", tmpDir.getAbsolutePath());
        VersioningFileProvider destProvider = new VersioningFileProvider();
        destProvider.initialize(engine, props);
        Collection allPages = sourceProvider.getAllPages();
        int idx = 1;
        Iterator i = allPages.iterator();
        while (i.hasNext()) {
            WikiPage pv;
            WikiPage p = (WikiPage)i.next();
            System.out.println("Converting page: " + p.getName() + " (" + idx + "/" + allPages.size() + ")");
            List pageHistory = engine.getVersionHistory(p.getName());
            Iterator v = pageHistory.listIterator(pageHistory.size());
            while (v.hasPrevious()) {
                pv = (WikiPage)v.previous();
                String text = engine.getPureText(pv.getName(), pv.getVersion());
                destProvider.putPageText(pv, text);
            }
            v = pageHistory.iterator();
            while (v.hasNext()) {
                pv = (WikiPage)v.next();
                File f = new File(tmpDir, "OLD");
                f = new File(f, this.mangleName(pv.getName()));
                f = new File(f, pv.getVersion() + ".txt");
                System.out.println("   Setting old version " + pv.getVersion() + " to date " + pv.getLastModified());
                f.setLastModified(pv.getLastModified().getTime());
            }
            ++idx;
        }
        tmpDir.delete();
    }

    public static void main(String[] args) throws Exception {
        ProviderConverter c = new ProviderConverter();
        c.setRCSSourceDir(args[0]);
        c.convert();
    }
}

