/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.util;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.util.Watchable;
import com.ecyrd.jspwiki.util.WikiBackgroundThread;
import java.lang.ref.WeakReference;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public final class WatchDog {
    private Watchable m_watchable;
    private Stack m_stateStack = new Stack();
    private boolean m_enabled = true;
    private WikiEngine m_engine;
    private static Logger log = Logger.getLogger((String)WatchDog.class.getName());
    private static HashMap c_kennel = new HashMap();
    private static WikiBackgroundThread c_watcherThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WatchDog getCurrentWatchDog(WikiEngine engine) {
        Thread t = Thread.currentThread();
        WatchDog wd = null;
        WeakReference<WatchDog> w = (WeakReference<WatchDog>)c_kennel.get(new Integer(t.hashCode()));
        if (w != null) {
            wd = (WatchDog)w.get();
        }
        if (w == null || wd == null) {
            wd = new WatchDog(engine, t);
            w = new WeakReference<WatchDog>(wd);
            HashMap hashMap = c_kennel;
            synchronized (hashMap) {
                c_kennel.put(new Integer(t.hashCode()), w);
            }
        }
        return wd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchDog(WikiEngine engine, Watchable watch) {
        this.m_engine = engine;
        this.m_watchable = watch;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (c_watcherThread == null) {
                c_watcherThread = new WatchDogThread(engine);
                c_watcherThread.start();
            }
        }
    }

    public WatchDog(WikiEngine engine, Thread thread) {
        this(engine, new ThreadWrapper(thread));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scrub() {
        if (c_kennel == null) {
            return;
        }
        HashMap hashMap = c_kennel;
        synchronized (hashMap) {
            Iterator i = c_kennel.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                WeakReference w = (WeakReference)e.getValue();
                if (w.get() != null) continue;
                c_kennel.remove(e.getKey());
                WatchDog.scrub();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.m_enabled) {
                this.m_enabled = true;
                c_watcherThread = new WatchDogThread(this.m_engine);
                c_watcherThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.m_enabled) {
                this.m_enabled = false;
                c_watcherThread.shutdown();
                c_watcherThread = null;
            }
        }
    }

    public void enterState(String state) {
        this.enterState(state, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterState(String state, int expectedCompletionTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.m_watchable.getName() + ": Entering state " + state + ", expected completion in " + expectedCompletionTime + " s"));
        }
        Stack stack = this.m_stateStack;
        synchronized (stack) {
            State st = new State(state, expectedCompletionTime);
            this.m_stateStack.push(st);
        }
    }

    public void exitState() {
        this.exitState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitState(String state) {
        try {
            Stack stack = this.m_stateStack;
            synchronized (stack) {
                State st = (State)this.m_stateStack.peek();
                if (state == null || st.getState().equals(state)) {
                    this.m_stateStack.pop();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.m_watchable.getName() + ": Exiting state " + st.getState()));
                    }
                } else {
                    log.error((Object)"exitState() called before enterState()");
                }
            }
        }
        catch (EmptyStackException e) {
            log.error((Object)"Stack is empty!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking watchdog '" + this.m_watchable.getName() + "'"));
        }
        Stack stack = this.m_stateStack;
        synchronized (stack) {
            try {
                State st = (State)this.m_stateStack.peek();
                long now = System.currentTimeMillis();
                if (now > st.getExpiryTime()) {
                    log.info((Object)("Watchable '" + this.m_watchable.getName() + "' exceeded timeout in state '" + st.getState() + "' by " + (now - st.getExpiryTime()) / 1000L + " seconds"));
                    this.m_watchable.timeoutExceeded(st.getState());
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Stack stack = this.m_stateStack;
        synchronized (stack) {
            String state = "Idle";
            try {
                State st = (State)this.m_stateStack.peek();
                state = st.getState();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            return "WatchDog state=" + state;
        }
    }

    private static class ThreadWrapper
    implements Watchable {
        private Thread m_thread;

        public ThreadWrapper(Thread thread) {
            this.m_thread = thread;
        }

        public void timeoutExceeded(String state) {
        }

        public String getName() {
            return this.m_thread.getName();
        }

        public boolean isAlive() {
            return this.m_thread.isAlive();
        }
    }

    private static class State {
        protected String m_state;
        protected long m_enterTime;
        protected long m_expiryTime;

        protected State(String state, int expiry) {
            this.m_state = state;
            this.m_enterTime = System.currentTimeMillis();
            this.m_expiryTime = this.m_enterTime + (long)expiry * 1000L;
        }

        protected String getState() {
            return this.m_state;
        }

        protected long getExpiryTime() {
            return this.m_expiryTime;
        }
    }

    private static class WatchDogThread
    extends WikiBackgroundThread {
        private static final int CHECK_INTERVAL = 30;

        public WatchDogThread(WikiEngine engine) {
            super(engine, 30);
            this.setName("WatchDog for '" + engine.getApplicationName() + "'");
        }

        public void startupTask() {
        }

        public void shutdownTask() {
            WatchDog.scrub();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void backgroundTask() throws Exception {
            HashMap hashMap = c_kennel;
            synchronized (hashMap) {
                Iterator i = c_kennel.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    WeakReference wr = (WeakReference)entry.getValue();
                    WatchDog w = (WatchDog)wr.get();
                    if (w == null) continue;
                    if (w.m_watchable != null && w.m_watchable.isAlive()) {
                        w.check();
                        continue;
                    }
                    c_kennel.remove(entry.getKey());
                    break;
                }
            }
            WatchDog.scrub();
        }
    }
}

