/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.workflow;

import com.ecyrd.jspwiki.workflow.NoSuchOutcomeException;

public final class Outcome {
    public static final Outcome STEP_COMPLETE = new Outcome("outcome.step.complete", true);
    public static final Outcome STEP_ABORT = new Outcome("outcome.step.abort", true);
    public static final Outcome STEP_CONTINUE = new Outcome("outcome.step.continue", false);
    public static final Outcome DECISION_ACKNOWLEDGE = new Outcome("outcome.decision.acknowledge", true);
    public static final Outcome DECISION_APPROVE = new Outcome("outcome.decision.approve", true);
    public static final Outcome DECISION_DENY = new Outcome("outcome.decision.deny", true);
    public static final Outcome DECISION_HOLD = new Outcome("outcome.decision.hold", false);
    public static final Outcome DECISION_REASSIGN = new Outcome("outcome.decision.reassign", false);
    private static final Outcome[] OUTCOMES = new Outcome[]{STEP_COMPLETE, STEP_ABORT, STEP_CONTINUE, DECISION_ACKNOWLEDGE, DECISION_APPROVE, DECISION_DENY, DECISION_HOLD, DECISION_REASSIGN};
    private final String m_key;
    private final boolean m_completion;

    private Outcome(String key, boolean completion) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        this.m_key = key;
        this.m_completion = completion;
    }

    public boolean isCompletion() {
        return this.m_completion;
    }

    public String getMessageKey() {
        return this.m_key;
    }

    public int hashCode() {
        return this.m_key.hashCode() * (this.m_completion ? 1 : 2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Outcome)) {
            return false;
        }
        return this.m_key.equals(((Outcome)obj).getMessageKey());
    }

    public static Outcome forName(String key) throws NoSuchOutcomeException {
        if (key != null) {
            for (int i = 0; i < OUTCOMES.length; ++i) {
                if (!Outcome.OUTCOMES[i].m_key.equals(key)) continue;
                return OUTCOMES[i];
            }
        }
        throw new NoSuchOutcomeException("Outcome " + key + " not found.");
    }

    public String toString() {
        return "[Outcome:" + this.m_key + "]";
    }
}

