/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.workflow;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.workflow.Fact;
import com.ecyrd.jspwiki.workflow.Outcome;
import com.ecyrd.jspwiki.workflow.SimpleDecision;
import com.ecyrd.jspwiki.workflow.SimpleNotification;
import com.ecyrd.jspwiki.workflow.Task;
import com.ecyrd.jspwiki.workflow.Workflow;
import com.ecyrd.jspwiki.workflow.WorkflowManager;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public final class WorkflowBuilder {
    private static final Map BUILDERS = new HashMap();
    private final WikiEngine m_engine;

    private WorkflowBuilder(WikiEngine engine) {
        this.m_engine = engine;
    }

    public static WorkflowBuilder getBuilder(WikiEngine engine) {
        WorkflowBuilder builder = (WorkflowBuilder)BUILDERS.get(engine);
        if (builder == null) {
            builder = new WorkflowBuilder(engine);
            BUILDERS.put(engine, builder);
        }
        return builder;
    }

    public Workflow buildApprovalWorkflow(Principal submitter, String workflowApproverKey, Task prepTask, String decisionKey, Fact[] facts, Task completionTask, String rejectedMessageKey) throws WikiException {
        WorkflowManager mgr = this.m_engine.getWorkflowManager();
        Workflow workflow = new Workflow(workflowApproverKey, submitter);
        boolean decisionRequired = mgr.requiresApproval(workflowApproverKey);
        if (decisionRequired) {
            Principal approverPrincipal = mgr.getApprover(workflowApproverKey);
            SimpleDecision decision = new SimpleDecision(workflow, decisionKey, approverPrincipal);
            if (facts != null) {
                for (int i = 0; i < facts.length; ++i) {
                    decision.addFact(facts[i]);
                }
                if (facts.length > 0) {
                    workflow.addMessageArgument(facts[0].getValue());
                }
            }
            if (rejectedMessageKey != null) {
                SimpleNotification rejectNotification = new SimpleNotification(workflow, rejectedMessageKey, submitter);
                decision.addSuccessor(Outcome.DECISION_DENY, rejectNotification);
            }
            decision.addSuccessor(Outcome.DECISION_APPROVE, completionTask);
            if (prepTask == null) {
                workflow.setFirstStep(decision);
            } else {
                workflow.setFirstStep(prepTask);
                prepTask.addSuccessor(Outcome.STEP_COMPLETE, decision);
            }
        } else if (prepTask == null) {
            workflow.setFirstStep(completionTask);
        } else {
            workflow.setFirstStep(prepTask);
            prepTask.addSuccessor(Outcome.STEP_COMPLETE, completionTask);
        }
        if (prepTask != null) {
            prepTask.setWorkflow(workflow);
        }
        completionTask.setWorkflow(workflow);
        return workflow;
    }
}

