/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.workflow;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.acl.UnresolvedPrincipal;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WorkflowEvent;
import com.ecyrd.jspwiki.workflow.DecisionQueue;
import com.ecyrd.jspwiki.workflow.Workflow;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WorkflowManager
implements WikiEventListener {
    private final DecisionQueue m_queue = new DecisionQueue();
    private final Set m_workflows = new HashSet();
    private final Map m_approvers = new HashMap();
    private final List m_completed = new ArrayList();
    protected static final String PROPERTY_APPROVER_PREFIX = "jspwiki.approver.";
    private WikiEngine m_engine = null;
    private volatile int m_next = 1;

    public void start(Workflow workflow) throws WikiException {
        this.m_workflows.add(workflow);
        workflow.setWorkflowManager(this);
        workflow.setId(this.nextId());
        workflow.start();
    }

    public Collection getWorkflows() {
        return new HashSet(this.m_workflows);
    }

    public List getCompletedWorkflows() {
        return new ArrayList(this.m_completed);
    }

    public void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String approver;
            String key;
            String prop = (String)it.next();
            if (!prop.startsWith(PROPERTY_APPROVER_PREFIX) || (key = prop.substring(PROPERTY_APPROVER_PREFIX.length())) == null || key.length() <= 0 || (approver = props.getProperty(prop)) == null || approver.length() <= 0) continue;
            this.m_approvers.put(key, new UnresolvedPrincipal(approver));
        }
    }

    public boolean requiresApproval(String messageKey) {
        return this.m_approvers.containsKey(messageKey);
    }

    public Principal getApprover(String messageKey) throws WikiException {
        Principal approver = (Principal)this.m_approvers.get(messageKey);
        if (approver == null) {
            throw new WikiException("Workflow '" + messageKey + "' does not require approval.");
        }
        if (approver instanceof UnresolvedPrincipal) {
            String name = approver.getName();
            approver = this.m_engine.getAuthorizationManager().resolvePrincipal(name);
            if (approver instanceof UnresolvedPrincipal) {
                throw new WikiException("Workflow approver '" + name + "' cannot not be resolved.");
            }
            this.m_approvers.put(messageKey, approver);
        }
        return approver;
    }

    protected WikiEngine getEngine() {
        if (this.m_engine == null) {
            throw new IllegalStateException("WikiEngine cannot be null; please initialize WorkflowManager first.");
        }
        return this.m_engine;
    }

    public DecisionQueue getDecisionQueue() {
        return this.m_queue;
    }

    private synchronized int nextId() {
        int current = this.m_next++;
        return current;
    }

    public Collection getOwnerWorkflows(WikiSession session) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        if (session.isAuthenticated()) {
            Principal[] sessionPrincipals = session.getPrincipals();
            Iterator it = this.m_workflows.iterator();
            block0: while (it.hasNext()) {
                Workflow w = (Workflow)it.next();
                Principal owner = w.getOwner();
                for (int i = 0; i < sessionPrincipals.length; ++i) {
                    if (!((Object)sessionPrincipals[i]).equals(owner)) continue;
                    workflows.add(w);
                    continue block0;
                }
            }
        }
        return workflows;
    }

    public void actionPerformed(WikiEvent event) {
        if (event instanceof WorkflowEvent) {
            Workflow workflow = (Workflow)event.getSource();
            switch (event.getType()) {
                case 50: {
                    this.remove(workflow);
                    break;
                }
                case 40: {
                    this.remove(workflow);
                    break;
                }
                case 0: {
                    this.add(workflow);
                    break;
                }
            }
        }
    }

    protected synchronized void add(Workflow workflow) {
        if (workflow.getWorkflowManager() == null) {
            workflow.setWorkflowManager(this);
        }
        if (workflow.getId() == 0) {
            workflow.setId(this.nextId());
        }
        this.m_workflows.add(workflow);
    }

    protected synchronized void remove(Workflow workflow) {
        if (this.m_workflows.contains(workflow)) {
            this.m_workflows.remove(workflow);
            this.m_completed.add(workflow);
        }
    }
}

