/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.xmlrpc;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.auth.AuthorizationManager;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import com.ecyrd.jspwiki.auth.permissions.WikiPermission;
import com.ecyrd.jspwiki.xmlrpc.WikiRPCHandler;
import java.security.Permission;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.xmlrpc.AuthenticationFailed;

public abstract class AbstractRPCHandler
implements WikiRPCHandler {
    public static final int ERR_NOPAGE = 1;
    public static final int ERR_NOPERMISSION = 2;
    public static final String LINK_LOCAL = "local";
    public static final String LINK_EXTERNAL = "external";
    public static final String LINK_INLINE = "inline";
    protected WikiEngine m_engine;
    protected WikiContext m_context;
    public static final int RPC_VERSION = 1;

    public void initialize(WikiContext context) {
        this.m_context = context;
        this.m_engine = context.getEngine();
    }

    protected abstract Hashtable encodeWikiPage(WikiPage var1);

    public Vector getRecentChanges(Date since) {
        this.checkPermission(PagePermission.VIEW);
        Collection pages = this.m_engine.getRecentChanges();
        Vector<Hashtable> result = new Vector<Hashtable>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(since);
        cal.add(14, cal.get(15) + (cal.getTimeZone().inDaylightTime(since) ? cal.get(16) : 0));
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            WikiPage page = (WikiPage)i.next();
            if (!page.getLastModified().after(cal.getTime())) continue;
            result.add(this.encodeWikiPage(page));
        }
        return result;
    }

    protected void checkPermission(Permission perm) {
        AuthorizationManager mgr = this.m_engine.getAuthorizationManager();
        if (mgr.checkPermission(this.m_context.getWikiSession(), perm)) {
            return;
        }
        throw new AuthenticationFailed("You have no access to this resource, o master");
    }

    public int getRPCVersionSupported() {
        this.checkPermission(WikiPermission.LOGIN);
        return 1;
    }
}

