/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.xmlrpc;

import com.ecyrd.jspwiki.PageTimeComparator;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.plugin.WeblogEntryPlugin;
import com.ecyrd.jspwiki.plugin.WeblogPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.xmlrpc.WikiRPCHandler;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;

public class MetaWeblogHandler
implements WikiRPCHandler {
    Logger log = Logger.getLogger((Class)MetaWeblogHandler.class);
    private WikiEngine m_engine;

    public void initialize(WikiContext context) {
        this.m_engine = context.getEngine();
    }

    private void checkPermissions(WikiPage page, String username, String password, String permission) throws XmlRpcException {
    }

    public Hashtable getCategories(String blogid, String username, String password) throws XmlRpcException {
        WikiPage page = this.m_engine.getPage(blogid);
        this.checkPermissions(page, username, password, "view");
        Hashtable ht = new Hashtable();
        return ht;
    }

    private String getURL(String page) {
        return this.m_engine.getURL(WikiContext.VIEW, page, null, true);
    }

    private Hashtable makeEntry(WikiPage page) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        WikiPage firstVersion = this.m_engine.getPage(page.getName(), 1);
        ht.put("dateCreated", firstVersion.getLastModified());
        ht.put("link", this.getURL(page.getName()));
        ht.put("permaLink", this.getURL(page.getName()));
        ht.put("postid", page.getName());
        ht.put("userid", page.getAuthor());
        String pageText = this.m_engine.getText(page.getName());
        String title = "";
        int firstLine = pageText.indexOf(10);
        if (firstLine > 0) {
            title = pageText.substring(0, firstLine);
        }
        if (title.trim().length() == 0) {
            title = page.getName();
        }
        while (title.startsWith("!")) {
            title = title.substring(1);
        }
        ht.put("title", title);
        ht.put("description", pageText);
        return ht;
    }

    public Hashtable getRecentPosts(String blogid, String username, String password, int numberOfPosts) throws XmlRpcException {
        Hashtable<String, Hashtable> result = new Hashtable<String, Hashtable>();
        this.log.info((Object)"metaWeblog.getRecentPosts() called");
        WikiPage page = this.m_engine.getPage(blogid);
        this.checkPermissions(page, username, password, "view");
        try {
            WeblogPlugin plugin = new WeblogPlugin();
            List changed = plugin.findBlogEntries(this.m_engine.getPageManager(), blogid, new Date(0L), new Date());
            Collections.sort(changed, new PageTimeComparator());
            Iterator i = changed.iterator();
            for (int items = 0; i.hasNext() && items < numberOfPosts; ++items) {
                WikiPage p = (WikiPage)i.next();
                result.put("entry", this.makeEntry(p));
            }
        }
        catch (ProviderException e) {
            this.log.error((Object)"Failed to list recent posts", (Throwable)e);
            throw new XmlRpcException(0, e.getMessage());
        }
        return result;
    }

    public String newPost(String blogid, String username, String password, Hashtable content, boolean publish) throws XmlRpcException {
        this.log.info((Object)"metaWeblog.newPost() called");
        WikiPage page = this.m_engine.getPage(blogid);
        this.checkPermissions(page, username, password, "create");
        try {
            WeblogEntryPlugin plugin = new WeblogEntryPlugin();
            String pageName = plugin.getNewEntryPage(this.m_engine, blogid);
            WikiPage entryPage = new WikiPage(this.m_engine, pageName);
            entryPage.setAuthor(username);
            WikiContext context = new WikiContext(this.m_engine, entryPage);
            StringBuffer text = new StringBuffer();
            text.append("!" + content.get("title"));
            text.append("\n\n");
            text.append(content.get("description"));
            this.log.debug((Object)("Writing entry: " + text));
            this.m_engine.saveText(context, text.toString());
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to create weblog entry", (Throwable)e);
            throw new XmlRpcException(0, "Failed to create weblog entry: " + e.getMessage());
        }
        return "";
    }

    public Hashtable newMediaObject(String blogid, String username, String password, Hashtable content) throws XmlRpcException {
        String url = "";
        this.log.info((Object)"metaWeblog.newMediaObject() called");
        WikiPage page = this.m_engine.getPage(blogid);
        this.checkPermissions(page, username, password, "upload");
        String name = (String)content.get("name");
        byte[] data = (byte[])content.get("bits");
        AttachmentManager attmgr = this.m_engine.getAttachmentManager();
        try {
            Attachment att = new Attachment(this.m_engine, blogid, name);
            att.setAuthor(username);
            attmgr.storeAttachment(att, new ByteArrayInputStream(data));
            url = this.m_engine.getURL(WikiContext.ATTACH, att.getName(), null, true);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to upload attachment", (Throwable)e);
            throw new XmlRpcException(0, "Failed to upload media object: " + e.getMessage());
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("url", url);
        return result;
    }

    boolean editPost(String postid, String username, String password, Hashtable content, boolean publish) throws XmlRpcException {
        this.log.info((Object)("metaWeblog.editPost(" + postid + ") called"));
        WikiPage page = this.m_engine.getPage(postid);
        this.checkPermissions(page, username, password, "edit");
        try {
            WikiPage entryPage = (WikiPage)page.clone();
            entryPage.setAuthor(username);
            WikiContext context = new WikiContext(this.m_engine, entryPage);
            StringBuffer text = new StringBuffer();
            text.append("!" + content.get("title"));
            text.append("\n\n");
            text.append(content.get("description"));
            this.log.debug((Object)("Updating entry: " + text));
            this.m_engine.saveText(context, text.toString());
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to create weblog entry", (Throwable)e);
            throw new XmlRpcException(0, "Failed to update weblog entry: " + e.getMessage());
        }
        return true;
    }

    Hashtable getPost(String postid, String username, String password) throws XmlRpcException {
        String wikiname = "FIXME";
        WikiPage page = this.m_engine.getPage(wikiname);
        this.checkPermissions(page, username, password, "view");
        return this.makeEntry(page);
    }
}

