/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.xmlrpc;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.xmlrpc.WikiRPCHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.ContextXmlRpcHandler;
import org.apache.xmlrpc.Invoker;
import org.apache.xmlrpc.XmlRpcContext;
import org.apache.xmlrpc.XmlRpcHandlerMapping;
import org.apache.xmlrpc.XmlRpcServer;

public class RPCServlet
extends HttpServlet {
    private static final long serialVersionUID = 3976735878410416180L;
    public static final String XMLRPC_PREFIX = "wiki";
    private WikiEngine m_engine;
    private XmlRpcServer m_xmlrpcServer = new XmlRpcServer();
    static Logger log = Logger.getLogger((Class)RPCServlet.class);

    public void initHandler(String prefix, String handlerName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> handlerClass = Class.forName(handlerName);
        this.m_xmlrpcServer.addHandler(prefix, (Object)new LocalHandler(handlerClass));
    }

    public void init(ServletConfig config) throws ServletException {
        this.m_engine = WikiEngine.getInstance(config);
        String handlerName = config.getInitParameter("handler");
        String prefix = config.getInitParameter("prefix");
        if (handlerName == null) {
            handlerName = "com.ecyrd.jspwiki.xmlrpc.RPCHandler";
        }
        if (prefix == null) {
            prefix = XMLRPC_PREFIX;
        }
        try {
            this.initHandler(prefix, handlerName);
            this.initHandler("metaWeblog", "com.ecyrd.jspwiki.xmlrpc.MetaWeblogHandler");
        }
        catch (Exception e) {
            log.fatal((Object)"Unable to start RPC interface: ", (Throwable)e);
            throw new ServletException("No RPC interface", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug((Object)"Received POST to RPCServlet");
        try {
            WikiContext ctx = this.m_engine.createContext(request, WikiContext.NONE);
            WikiXmlRpcContext xmlrpcContext = new WikiXmlRpcContext(this.m_xmlrpcServer.getHandlerMapping(), ctx);
            byte[] result = this.m_xmlrpcServer.execute((InputStream)request.getInputStream(), (XmlRpcContext)xmlrpcContext);
            response.setContentType("text/xml; charset=utf-8");
            response.setContentLength(result.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(result);
            out.flush();
        }
        catch (IOException e) {
            throw new ServletException("Failed to build RPC result", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug((Object)"Received HTTP GET to RPCServlet");
        try {
            String msg = "We do not support HTTP GET here.  Sorry.";
            response.setContentType("text/plain");
            response.setContentLength(msg.length());
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            writer.println(msg);
            writer.flush();
        }
        catch (IOException e) {
            throw new ServletException("Failed to build RPC result", (Throwable)e);
        }
    }

    private static class WikiXmlRpcContext
    implements XmlRpcContext {
        private XmlRpcHandlerMapping m_mapping;
        private WikiContext m_context;

        public WikiXmlRpcContext(XmlRpcHandlerMapping map, WikiContext ctx) {
            this.m_mapping = map;
            this.m_context = ctx;
        }

        public XmlRpcHandlerMapping getHandlerMapping() {
            return this.m_mapping;
        }

        public String getPassword() {
            return null;
        }

        public String getUserName() {
            return null;
        }

        public WikiContext getWikiContext() {
            return this.m_context;
        }
    }

    private class LocalHandler
    implements ContextXmlRpcHandler {
        private Class m_clazz;

        public LocalHandler(Class clazz) {
            this.m_clazz = clazz;
        }

        public Object execute(String method, Vector params, XmlRpcContext context) throws Exception {
            WikiRPCHandler rpchandler = (WikiRPCHandler)this.m_clazz.newInstance();
            rpchandler.initialize(((WikiXmlRpcContext)context).getWikiContext());
            Invoker invoker = new Invoker((Object)rpchandler);
            return invoker.execute(method, params);
        }
    }
}

