/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.management;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.apache.commons.lang.StringUtils;

public abstract class SimpleMBean
implements DynamicMBean {
    protected MBeanInfo m_beanInfo;

    private static Method findGetterSetter(Class clazz, String name, Class parm) {
        try {
            Class[] params = new Class[]{parm};
            Class[] emptyparms = new Class[]{};
            Method m = clazz.getDeclaredMethod(name, parm != null ? params : emptyparms);
            return m;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected SimpleMBean() throws NotCompliantMBeanException {
        String[] attlist = this.getAttributeNames();
        MBeanAttributeInfo[] attributes = null;
        if (attlist != null) {
            attributes = new MBeanAttributeInfo[attlist.length];
            for (int i = 0; i < attlist.length; ++i) {
                MBeanAttributeInfo info;
                String name = attlist[i];
                name = StringUtils.capitalize((String)name);
                Method getter = SimpleMBean.findGetterSetter(this.getClass(), "get" + name, null);
                if (getter == null) {
                    getter = SimpleMBean.findGetterSetter(this.getClass(), "is" + name, null);
                }
                Method setter = null;
                if (getter != null) {
                    setter = SimpleMBean.findGetterSetter(this.getClass(), "set" + name, getter.getReturnType());
                }
                Method descriptor = SimpleMBean.findGetterSetter(this.getClass(), "get" + name + "Description", null);
                String description = "";
                if (descriptor != null) {
                    try {
                        description = (String)descriptor.invoke((Object)this, (Object[])null);
                    }
                    catch (Exception e) {
                        description = "Exception: " + e.getMessage();
                    }
                }
                try {
                    info = new MBeanAttributeInfo(attlist[i], description, getter, setter);
                }
                catch (IntrospectionException e) {
                    throw new NotCompliantMBeanException(e.getMessage());
                }
                attributes[i] = info;
            }
        }
        String[] oplist = this.getMethodNames();
        MBeanOperationInfo[] operations = new MBeanOperationInfo[oplist.length];
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < oplist.length; ++i) {
            MBeanOperationInfo info;
            Method method = null;
            for (int m = 0; m < methods.length; ++m) {
                if (!methods[m].getName().equals(oplist[i])) continue;
                method = methods[m];
            }
            if (method == null) {
                throw new NotCompliantMBeanException("Class declares method " + oplist[i] + ", yet does not implement it!");
            }
            operations[i] = info = new MBeanOperationInfo(method.getName(), method);
        }
        MBeanConstructorInfo[] constructors = null;
        MBeanNotificationInfo[] notifications = null;
        this.m_beanInfo = new MBeanInfo(this.getClass().getName(), this.getDescription(), attributes, constructors, operations, notifications);
    }

    protected String getDescription() {
        return "";
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object res = null;
        try {
            String mname = "get" + StringUtils.capitalize((String)name);
            Method m = SimpleMBean.findGetterSetter(this.getClass(), mname, null);
            if (m == null) {
                throw new AttributeNotFoundException(name);
            }
            res = m.invoke((Object)this, (Object[])null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return res;
    }

    public AttributeList getAttributes(String[] arg0) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < arg0.length; ++i) {
            try {
                list.add(new Attribute(arg0[i], this.getAttribute(arg0[i])));
                continue;
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (MBeanException e) {
                e.printStackTrace();
                continue;
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public MBeanInfo getMBeanInfo() {
        return this.m_beanInfo;
    }

    public Object invoke(String arg0, Object[] arg1, String[] arg2) throws MBeanException, ReflectionException {
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(arg0)) continue;
            try {
                return methods[i].invoke((Object)this, arg1);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e, "Wrong arguments");
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e, "No access");
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e, "Wrong target");
            }
        }
        throw new ReflectionException(null, "There is no such method " + arg0);
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String mname = "set" + StringUtils.capitalize((String)attr.getName());
        Method m = SimpleMBean.findGetterSetter(this.getClass(), mname, attr.getValue().getClass());
        if (m == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        Object[] args = new Object[]{attr.getValue()};
        try {
            m.invoke((Object)this, args);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException("Faulty argument: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Cannot access attribute " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e, "Cannot invoke attribute " + e.getMessage());
        }
    }

    public AttributeList setAttributes(AttributeList arg0) {
        AttributeList result = new AttributeList();
        Iterator i = arg0.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            try {
                this.setAttribute(attr);
                result.add(attr);
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InvalidAttributeValueException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public abstract String[] getAttributeNames();

    public abstract String[] getMethodNames();
}

