/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext;

import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.RowSelectorEvent;
import com.icesoft.faces.component.ext.renderkit.TableRenderer;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class RowSelector
extends UIComponentBase {
    private Boolean value;
    private Boolean toggleOnClick;
    private Boolean multiple;
    private String mouseOverClass;
    private String selectedClass;
    private MethodBinding selectionListener;
    private MethodBinding selectionAction;
    private Integer clickedRow;
    public static final String COMPONENT_TYPE = "com.icesoft.faces.RowSelector";
    public static final String RENDERER_TYPE = "com.icesoft.faces.RowSelectorRenderer";
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.RowSelectorFamily";
    String styleClass;

    public RowSelector() {
        JavascriptContext.includeLib((String)JavascriptContext.ICE_EXTRAS, (FacesContext)this.getFacesContext());
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Boolean getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.value != null) {
            return this.value;
        }
        return Boolean.FALSE;
    }

    public void setValue(Boolean value) {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)value);
        } else {
            this.value = value;
        }
    }

    public Integer getClickedRow() {
        ValueBinding vb = this.getValueBinding("clickedRow");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        if (this.clickedRow != null) {
            return this.clickedRow;
        }
        return new Integer(-1);
    }

    public void setClickedRow(Integer clickedRow) {
        ValueBinding vb = this.getValueBinding("clickedRow");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)clickedRow);
        } else {
            this.clickedRow = clickedRow;
        }
    }

    public Boolean getMultiple() {
        ValueBinding vb = this.getValueBinding("multiple");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.multiple != null) {
            return this.multiple;
        }
        return Boolean.FALSE;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    public Boolean getToggleOnClick() {
        ValueBinding vb = this.getValueBinding("toggleOnClick");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.toggleOnClick != null) {
            return this.toggleOnClick;
        }
        return Boolean.TRUE;
    }

    public void setToggleOnClick(Boolean toggleOnClick) {
        this.toggleOnClick = toggleOnClick;
    }

    public String getMouseOverClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.mouseOverClass, "MouseOver", "mouseOverClass");
    }

    public void setMouseOverClass(String mouseOverClass) {
        this.mouseOverClass = mouseOverClass;
    }

    public String getSelectedClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.selectedClass, "Selected", "selectedClass");
    }

    public void setSelectedClass(String selectedClass) {
        this.selectedClass = selectedClass;
    }

    public MethodBinding getSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(MethodBinding selectionListener) {
        this.selectionListener = selectionListener;
    }

    public MethodBinding getSelectionAction() {
        return this.selectionAction;
    }

    public void setSelectionAction(MethodBinding selectionListener) {
        this.selectionAction = selectionListener;
    }

    public void processDecodes(FacesContext facesContext) {
        HtmlDataTable dataTable = RowSelector.getParentDataTable((UIComponent)this);
        String dataTableId = dataTable.getClientId(facesContext);
        String selectedRowsParameter = TableRenderer.getSelectedRowParameterName(dataTableId);
        String selectedRows = (String)facesContext.getExternalContext().getRequestParameterMap().get(selectedRowsParameter);
        if (selectedRows == null || selectedRows.trim().length() == 0) {
            return;
        }
        int rowIndex = dataTable.getRowIndex();
        StringTokenizer st = new StringTokenizer(selectedRows, ",");
        boolean rowClicked = false;
        while (st.hasMoreTokens()) {
            int row = Integer.parseInt(st.nextToken());
            if (row != rowIndex) continue;
            rowClicked = true;
            break;
        }
        RowSelector rowSelector = this;
        try {
            if (rowClicked) {
                boolean b = rowSelector.getValue();
                b = !b;
                rowSelector.setValue(new Boolean(b));
                this.setClickedRow(new Integer(rowIndex));
                if (rowSelector.getSelectionListener() != null) {
                    RowSelectorEvent evt = new RowSelectorEvent((UIComponent)rowSelector, rowIndex, b);
                    evt.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
                    rowSelector.queueEvent(evt);
                }
                if (rowSelector.getSelectionAction() != null) {
                    rowSelector.getSelectionAction().invoke(facesContext, null);
                }
            } else if (Boolean.FALSE.equals(rowSelector.getMultiple())) {
                rowSelector.setValue(Boolean.FALSE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static HtmlDataTable getParentDataTable(UIComponent uiComponenent) {
        UIComponent parentComp = uiComponenent.getParent();
        if (parentComp == null) {
            throw new RuntimeException("RowSelectorRenderer: decode. Could not find an Ice:dataTable as a parent componenent");
        }
        if (parentComp instanceof HtmlDataTable) {
            return (HtmlDataTable)parentComp;
        }
        return RowSelector.getParentDataTable(parentComp);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
    }

    public void broadcast(FacesEvent event) {
        super.broadcast(event);
        if (event instanceof RowSelectorEvent && this.selectionListener != null) {
            this.selectionListener.invoke(this.getFacesContext(), new Object[]{(RowSelectorEvent)event});
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[12];
        state[0] = super.saveState(context);
        state[1] = this.value;
        state[2] = this.multiple;
        state[3] = this.mouseOverClass;
        state[4] = this.selectedClass;
        state[5] = this.selectionListener;
        return state;
    }

    public void restoreState(FacesContext context, Object stateIn) {
        Object[] state = (Object[])stateIn;
        super.restoreState(context, state[0]);
        this.value = (Boolean)state[1];
        this.multiple = (Boolean)state[2];
        this.mouseOverClass = (String)state[3];
        this.selectedClass = (String)state[4];
        this.selectionListener = (MethodBinding)state[5];
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceRowSel", "styleClass");
    }
}

