/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.tree;

import com.icesoft.faces.component.InvalidComponentTypeException;
import com.icesoft.faces.component.tree.IceUserObject;
import com.icesoft.faces.component.tree.InvalidNavigationId;
import com.icesoft.faces.component.tree.MalformedTreeTagException;
import com.icesoft.faces.component.tree.Tree;
import com.icesoft.faces.component.tree.TreeNode;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.FormRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreeRenderer
extends DomBasicRenderer {
    public static final String PATH_DELIMITER = "-";

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (TreeRenderer.isStatic((UIComponent)uiComponent)) {
            return;
        }
        Tree treeComponent = (Tree)uiComponent;
        String expandNodeKey = CustomComponentUtils.getHiddenTreeExpandFieldName(uiComponent.getClientId(facesContext), CustomComponentUtils.getFormName(uiComponent, facesContext));
        String pathToExpandedNode = (String)facesContext.getExternalContext().getRequestParameterMap().get(expandNodeKey);
        if (pathToExpandedNode != null && !pathToExpandedNode.equalsIgnoreCase("")) {
            try {
                DefaultMutableTreeNode navigatedNode = treeComponent.getNodeAtPathsEnd(pathToExpandedNode);
                treeComponent.setNavigatedNode(navigatedNode);
                IceUserObject userObject = (IceUserObject)navigatedNode.getUserObject();
                if (userObject != null) {
                    treeComponent.setNavigationEventType(userObject.isExpanded() ? "collapse" : "expand");
                    userObject.setExpanded(!userObject.isExpanded());
                }
                ActionEvent actionEvent = new ActionEvent(uiComponent);
                uiComponent.queueEvent((FacesEvent)actionEvent);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidNavigationId("TreeRenderer.decode() NumberFormatException invalid tree navigation id", nfe);
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        this.validateParameters(facesContext, uiComponent, Tree.class);
        Tree treeComponent = (Tree)uiComponent;
        TreeModel treeModel = (TreeModel)uiComponent.getValueBinding("value").getValue(facesContext);
        if (treeComponent.getChildCount() != 1) {
            throw new MalformedTreeTagException("The tree tag requires a single child treeNode tag. Found [" + treeComponent.getChildCount() + "]");
        }
        if (treeModel == null) {
            return;
        }
        FormRenderer.addHiddenField((FacesContext)facesContext, (String)CustomComponentUtils.getHiddenTreeExpandFieldName(uiComponent.getClientId(facesContext), CustomComponentUtils.getFormName(uiComponent, facesContext)));
        FormRenderer.addHiddenField((FacesContext)facesContext, (String)CustomComponentUtils.getHiddenTreeActionFieldName(uiComponent.getClientId(facesContext), CustomComponentUtils.getFormName(uiComponent, facesContext)));
        if (!domContext.isInitialized()) {
            Element rootDOMNode = domContext.createRootElement("div");
            rootDOMNode.setAttribute("id", uiComponent.getClientId(facesContext));
        }
        Element rootDomNode = (Element)domContext.getRootNode();
        rootDomNode.setAttribute("class", treeComponent.getStyleClass());
        String style = treeComponent.getStyle();
        if (style != null && style.length() > 0) {
            rootDomNode.setAttribute("style", style);
        } else {
            rootDomNode.removeAttribute("style");
        }
        DOMContext.removeChildren((Node)rootDomNode);
        if (PassThruAttributeRenderer.passThruAttributeExists((UIComponent)uiComponent)) {
            PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, null);
        }
        domContext.startNode(facesContext, (UIComponent)treeComponent, (Node)rootDomNode);
        domContext.stepInto(uiComponent);
    }

    private boolean isHideRootNode(Tree treeComponent) {
        String hideRootNodeAttribute = (String)treeComponent.getAttributes().get("hideRootNode");
        return hideRootNodeAttribute != null && hideRootNodeAttribute.equalsIgnoreCase("true");
    }

    private boolean isHideNavigation(Tree treeComponent) {
        String hideNavAttr = (String)treeComponent.getAttributes().get("hideNavigation");
        return hideNavAttr != null && hideNavAttr.equalsIgnoreCase("true");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        TreeModel treeModel = (TreeModel)uiComponent.getValueBinding("value").getValue(facesContext);
        DefaultMutableTreeNode treeComponentRootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        Element rootNode = (Element)domContext.getRootNode();
        TreeNode treeNode = (TreeNode)((Object)uiComponent.getChildren().get(0));
        if (!(uiComponent instanceof Tree)) {
            throw new InvalidComponentTypeException("Expecting a Tree");
        }
        boolean hideRootNode = this.isHideRootNode((Tree)uiComponent);
        this.encodeParentAndChildNodes(facesContext, (Tree)uiComponent, (DefaultMutableTreeNode)treeModel.getRoot(), hideRootNode, rootNode, treeComponentRootNode, treeNode);
    }

    public void encodeParentAndChildNodes(FacesContext facesContext, Tree treeComponent, DefaultMutableTreeNode current, boolean hideCurrentNode, Element parentDOMNode, DefaultMutableTreeNode treeComponentRootNode, TreeNode treeNode) {
        String varAttribute;
        Map requestMap;
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)treeComponent);
        Element treeNodeDiv = domContext.createElement("div");
        if (!hideCurrentNode) {
            requestMap = facesContext.getExternalContext().getRequestMap();
            varAttribute = treeComponent.getVar();
            requestMap.put(varAttribute, current);
            domContext.setCursorParent((Node)parentDOMNode);
            treeNodeDiv.setAttribute("name", "treeNodeDiv");
            treeNodeDiv.setAttribute("class", treeComponent.getTreeRowStyleClass());
            parentDOMNode.appendChild(treeNodeDiv);
            domContext.setCursorParent((Node)treeNodeDiv);
            try {
                domContext.startNode(facesContext, (UIComponent)treeComponent, (Node)treeNodeDiv);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.encodeNode(facesContext, treeComponent, current, treeNodeDiv, domContext, treeComponentRootNode, treeNode, parentDOMNode);
        } else {
            requestMap = facesContext.getExternalContext().getRequestMap();
            varAttribute = treeComponent.getVar();
            requestMap.put(varAttribute, current);
            domContext.setCursorParent((Node)parentDOMNode);
            treeNodeDiv.setAttribute("name", "treeNodeDiv");
            treeNodeDiv.setAttribute("class", treeComponent.getTreeRowStyleClass());
            treeNodeDiv.setAttribute("id", treeComponent.getClientId(facesContext) + "-div-root");
            parentDOMNode.appendChild(treeNodeDiv);
            domContext.setCursorParent((Node)treeNodeDiv);
            try {
                domContext.startNode(facesContext, (UIComponent)treeComponent, (Node)treeNodeDiv);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        int childCount = current.getChildCount();
        if (childCount > 0 && ((IceUserObject)current.getUserObject()).isExpanded()) {
            Element childDiv = domContext.createElement("div");
            childDiv.setAttribute("name", "CHILD");
            childDiv.setAttribute("id", treeNodeDiv.getAttribute("id") + "-child");
            treeNodeDiv.appendChild(childDiv);
            try {
                domContext.startNode(facesContext, (UIComponent)treeComponent, (Node)childDiv);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            for (int i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode next = (DefaultMutableTreeNode)current.getChildAt(i);
                this.encodeParentAndChildNodes(facesContext, treeComponent, next, false, childDiv, treeComponentRootNode, treeNode);
            }
            try {
                domContext.endNode(facesContext, (UIComponent)treeComponent, (Node)childDiv);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void encodeNode(FacesContext facesContext, Tree treeComponent, DefaultMutableTreeNode currentNode, Element treeNodeDiv, DOMContext domContext, DefaultMutableTreeNode treeComponentRootNode, TreeNode treeNode, Element parentDOMNode) {
        String pathToCurrentRoot = TreeRenderer.getPathAsString(currentNode, treeComponentRootNode);
        boolean hideRootNode = this.isHideRootNode(treeComponent);
        boolean hideNavigation = this.isHideNavigation(treeComponent);
        treeNode.setMutable(currentNode);
        treeNode.setId("n-" + pathToCurrentRoot);
        treeNode.setParent((UIComponent)treeComponent);
        IceUserObject userObject = (IceUserObject)currentNode.getUserObject();
        boolean isBranchNode = !userObject.isLeaf();
        boolean isExpanded = userObject.isExpanded();
        boolean isLastChild = treeComponentRootNode.getLastLeaf() == currentNode;
        boolean isCollapsedAndFinalBranch = false;
        if (isBranchNode && !isExpanded) {
            isCollapsedAndFinalBranch = this.isCollapsedAndFinalBranch(currentNode);
        }
        int level = currentNode.getLevel();
        UIComponent myForm = TreeRenderer.findForm((UIComponent)treeComponent);
        String formId = myForm.getClientId(facesContext);
        if (hideRootNode) {
            --level;
        }
        for (int i = 0; i < level; ++i) {
            Element verticalLine = domContext.createElement("img");
            verticalLine.setAttribute("alt", "");
            DefaultMutableTreeNode parentNode = null;
            if (i > 0 || hideRootNode) {
                parentNode = (DefaultMutableTreeNode)currentNode.getParent();
                for (int j = 1; j < level - i; ++j) {
                    parentNode = (DefaultMutableTreeNode)parentNode.getParent();
                }
            }
            boolean renderBlank = false;
            if (null != parentNode && parentNode.getNextSibling() == null) {
                renderBlank = true;
            }
            if (renderBlank) {
                verticalLine.setAttribute("src", treeComponent.getLineBlankImage());
            } else if (i == 0 && !hideRootNode) {
                verticalLine.setAttribute("src", treeComponent.getLineBlankImage());
            } else if (isLastChild || isCollapsedAndFinalBranch) {
                verticalLine.setAttribute("src", treeComponent.getLineBottomImage());
            } else {
                verticalLine.setAttribute("src", treeComponent.getLineVerticalImage());
            }
            verticalLine.setAttribute("border", "0");
            treeNodeDiv.appendChild(verticalLine);
            try {
                domContext.startNode(facesContext, (UIComponent)treeComponent, (Node)verticalLine);
                domContext.endNode(facesContext, (UIComponent)treeComponent, (Node)verticalLine);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (isBranchNode && !hideNavigation) {
            Element navAnchor = domContext.createElement("a");
            navAnchor.setAttribute("href", "#");
            navAnchor.setAttribute("id", formId + ":" + pathToCurrentRoot);
            navAnchor.setAttribute("onfocus", "setFocus(this.id);");
            navAnchor.setAttribute("onblur", "setFocus('');");
            String hiddenFieldName = CustomComponentUtils.getHiddenTreeExpandFieldName(treeComponent.getClientId(facesContext), CustomComponentUtils.getFormName((UIComponent)treeComponent, facesContext));
            String onclickString = "document.forms['" + formId + "']['" + hiddenFieldName + "'].value=" + "'" + pathToCurrentRoot + "';" + "iceSubmitPartial(" + " document.forms['" + formId + "']," + " this,event); " + "return false;";
            navAnchor.setAttribute("onclick", onclickString);
            treeNodeDiv.appendChild(navAnchor);
            Element iconImage = domContext.createElement("img");
            if (currentNode.isRoot() && !isExpanded || hideRootNode && currentNode.getNextSibling() == null && currentNode == treeComponentRootNode.getFirstChild()) {
                iconImage.setAttribute("src", treeComponent.getNavOpenTopNoSiblingsImage());
            } else if (currentNode.isRoot() || hideRootNode && treeComponentRootNode.getFirstChild() == currentNode) {
                if (isExpanded) {
                    iconImage.setAttribute("src", treeComponent.getNavCloseTopNoSiblingsImage());
                } else {
                    iconImage.setAttribute("src", treeComponent.getNavOpenTopNoSiblingsImage());
                }
            } else if (currentNode.getNextSibling() == null && currentNode.getChildCount() > 0) {
                if (isExpanded) {
                    iconImage.setAttribute("src", treeComponent.getNavCloseBottomImage());
                } else {
                    iconImage.setAttribute("src", treeComponent.getNavOpenBottomImage());
                }
            } else if (isExpanded) {
                iconImage.setAttribute("src", treeComponent.getNavCloseMiddleImage());
            } else {
                iconImage.setAttribute("src", treeComponent.getNavOpenMiddleImage());
            }
            iconImage.setAttribute("border", "0");
            iconImage.setAttribute("alt", "");
            navAnchor.appendChild(iconImage);
            try {
                domContext.startNode(facesContext, (UIComponent)treeComponent, (Node)navAnchor);
                domContext.startNode(facesContext, (UIComponent)treeComponent, (Node)iconImage);
                domContext.endNode(facesContext, (UIComponent)treeComponent, (Node)iconImage);
                domContext.endNode(facesContext, (UIComponent)treeComponent, (Node)navAnchor);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            Element lineImage = domContext.createElement("img");
            treeNodeDiv.appendChild(lineImage);
            lineImage.setAttribute("border", "0");
            lineImage.setAttribute("alt", "");
            if (currentNode.getNextSibling() == null) {
                lineImage.setAttribute("src", treeComponent.getLineBottomImage());
            } else {
                lineImage.setAttribute("src", treeComponent.getLineMiddleImage());
            }
            try {
                domContext.startNode(facesContext, (UIComponent)treeComponent, (Node)lineImage);
                domContext.endNode(facesContext, (UIComponent)treeComponent, (Node)lineImage);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        String pathToNode = TreeRenderer.getPathAsString(currentNode, (DefaultMutableTreeNode)treeComponent.getModel().getRoot());
        treeNodeDiv.setAttribute("id", treeComponent.getClientId(facesContext) + "-div-" + pathToNode);
        try {
            TreeRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)treeNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            domContext.endNode(facesContext, (UIComponent)treeComponent, (Node)treeNodeDiv);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, Tree.class);
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        Element rootNode = (Element)domContext.getRootNode();
        Element imageLoaderDiv = domContext.createElement("div");
        imageLoaderDiv.setAttribute("id", "imageCache");
        imageLoaderDiv.setAttribute("style", "display:none;");
        rootNode.appendChild(imageLoaderDiv);
        Element tree_document = domContext.createElement("img");
        Element tree_line_blank = domContext.createElement("img");
        Element tree_line_vertical = domContext.createElement("img");
        Element tree_nav_middle_close = domContext.createElement("img");
        Element tree_nav_top_open = domContext.createElement("img");
        Element tree_folder_close = domContext.createElement("img");
        Element tree_line_last_node = domContext.createElement("img");
        Element tree_nav_bottom_close = domContext.createElement("img");
        Element tree_nav_middle_open = domContext.createElement("img");
        Element tree_nav_top_open_no_siblings = domContext.createElement("img");
        Element tree_folder_open = domContext.createElement("img");
        Element tree_line_middle_node = domContext.createElement("img");
        Element tree_nav_bottom_open = domContext.createElement("img");
        Element tree_nav_top_close = domContext.createElement("img");
        String appBase = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)"/xmlhttp/css/xp/css-images/");
        tree_document.setAttribute("src", appBase + "tree_document.gif");
        tree_line_blank.setAttribute("src", appBase + "tree_line_blank.gif");
        tree_line_vertical.setAttribute("src", appBase + "tree_line_vertical.gif");
        tree_nav_middle_close.setAttribute("src", appBase + "tree_nav_middle_close.gif");
        tree_nav_top_open.setAttribute("src", appBase + "tree_nav_top_open.gif");
        tree_folder_close.setAttribute("src", appBase + "tree_folder_close.gif");
        tree_line_last_node.setAttribute("src", appBase + "tree_line_last_node.gif");
        tree_nav_bottom_close.setAttribute("src", appBase + "tree_nav_bottom_close.gif");
        tree_nav_middle_open.setAttribute("src", appBase + "tree_nav_middle_open.gif");
        tree_nav_top_open_no_siblings.setAttribute("src", appBase + "tree_nav_top_open_no_siblings.gif");
        tree_folder_open.setAttribute("src", appBase + "tree_folder_open.gif");
        tree_line_middle_node.setAttribute("src", appBase + "tree_line_middle_node.gif");
        tree_nav_bottom_open.setAttribute("src", appBase + "tree_nav_bottom_open.gif");
        tree_nav_top_close.setAttribute("src", appBase + "tree_nav_top_close.gif");
        imageLoaderDiv.appendChild(tree_document);
        imageLoaderDiv.appendChild(tree_line_blank);
        imageLoaderDiv.appendChild(tree_line_vertical);
        imageLoaderDiv.appendChild(tree_nav_middle_close);
        imageLoaderDiv.appendChild(tree_nav_top_open);
        imageLoaderDiv.appendChild(tree_folder_close);
        imageLoaderDiv.appendChild(tree_line_last_node);
        imageLoaderDiv.appendChild(tree_nav_bottom_close);
        imageLoaderDiv.appendChild(tree_nav_middle_open);
        imageLoaderDiv.appendChild(tree_nav_top_open_no_siblings);
        imageLoaderDiv.appendChild(tree_folder_open);
        imageLoaderDiv.appendChild(tree_line_middle_node);
        imageLoaderDiv.appendChild(tree_nav_bottom_open);
        imageLoaderDiv.appendChild(tree_nav_top_close);
        domContext.endNode(facesContext, uiComponent, (Node)rootNode);
        domContext.stepOver();
    }

    private boolean isCollapsedAndFinalBranch(DefaultMutableTreeNode branch) {
        javax.swing.tree.TreeNode[] path = branch.getPath();
        int i = 0;
        while (i + 1 < path.length) {
            DefaultMutableTreeNode nextParent = (DefaultMutableTreeNode)path[i];
            DefaultMutableTreeNode nextChild = (DefaultMutableTreeNode)path[i + 1];
            if (nextParent.getLastChild() != nextChild) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getPathAsString(DefaultMutableTreeNode currentRoot, DefaultMutableTreeNode treeComponentRootNode) {
        if (currentRoot == treeComponentRootNode) {
            return "root";
        }
        StringBuffer convertedPath = new StringBuffer();
        javax.swing.tree.TreeNode[] path = currentRoot.getPath();
        int pathLength = path.length;
        javax.swing.tree.TreeNode parent = treeComponentRootNode;
        for (int i = 1; i < pathLength; ++i) {
            javax.swing.tree.TreeNode nextNodeInPath = path[i];
            int indexOfNextNodeInPath = parent.getIndex(nextNodeInPath);
            convertedPath.append(indexOfNextNodeInPath);
            if (i + 1 < pathLength) {
                convertedPath.append(PATH_DELIMITER);
            }
            parent = nextNodeInPath;
        }
        return convertedPath.toString();
    }
}

