/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BugCheckException;
import interbase.interclient.ErrorKey;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.RecvMessage;
import interbase.interclient.SQLException;

final class ArrayDescriptor {
    String columnName_ = null;
    String tableName_ = null;
    int elementDataType_ = 0;
    int elementIBDataType_ = 0;
    int elementScale_ = 0;
    int elementPrecision_ = 0;
    int elementLength_ = 0;
    int flags_ = 0;
    int dimensions_ = 0;
    int[][] dimensionBounds_ = null;
    static final int MAX_DIMENSIONS = 16;

    ArrayDescriptor(RecvMessage recvMessage) throws java.sql.SQLException {
        this.recv(recvMessage);
    }

    ArrayDescriptor() throws SQLException {
        this.dimensionBounds_ = new int[16][2];
    }

    private void recv(RecvMessage recvMessage) throws java.sql.SQLException {
        this.elementDataType_ = recvMessage.readUnsignedByte();
        this.elementScale_ = recvMessage.readUnsignedByte();
        this.elementPrecision_ = recvMessage.readUnsignedShort();
        this.elementLength_ = recvMessage.readUnsignedShort();
        this.dimensions_ = recvMessage.readUnsignedShort();
        this.dimensionBounds_ = new int[this.dimensions_][2];
        int n = 0;
        while (n < this.dimensions_) {
            this.dimensionBounds_[n][0] = recvMessage.readShort();
            this.dimensionBounds_[n][1] = recvMessage.readShort();
            ++n;
        }
        this.columnName_ = recvMessage.readLDSQLText();
        this.tableName_ = recvMessage.readLDSQLText();
        this.elementIBDataType_ = recvMessage.readUnsignedByte();
    }

    void send(MessageBufferOutputStream messageBufferOutputStream, int[][] nArray) throws java.sql.SQLException {
        if (nArray.length != this.dimensions_) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 137);
        }
        messageBufferOutputStream.writeByte(this.elementIBDataType_);
        messageBufferOutputStream.writeByte(this.elementScale_);
        messageBufferOutputStream.writeShort(this.elementLength_);
        messageBufferOutputStream.writeShort(this.dimensions_);
        int n = 0;
        while (n < this.dimensions_) {
            messageBufferOutputStream.writeShort(nArray[n][0]);
            messageBufferOutputStream.writeShort(nArray[n][1]);
            ++n;
        }
        messageBufferOutputStream.writeLDChars(this.columnName_);
        messageBufferOutputStream.writeLDChars(this.tableName_);
    }

    int[][] getDimensions() throws java.sql.SQLException {
        int[][] nArray = new int[this.dimensions_][2];
        int n = 0;
        while (n < this.dimensions_) {
            nArray[n][0] = this.dimensionBounds_[n][0];
            nArray[n][1] = this.dimensionBounds_[n][1];
            ++n;
        }
        return nArray;
    }

    boolean checkSliceBounds(int[][] nArray) throws java.sql.SQLException {
        if (nArray.length != this.dimensions_) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_slice__);
        }
        boolean bl = true;
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n][0] < this.dimensionBounds_[n][0] || nArray[n][0] > this.dimensionBounds_[n][1] || nArray[n][1] > this.dimensionBounds_[n][1] || nArray[n][1] < this.dimensionBounds_[n][0] || nArray[n][0] > nArray[n][1]) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_slice__);
            }
            if (nArray[n][0] != this.dimensionBounds_[n][0] || nArray[n][1] != this.dimensionBounds_[n][1]) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }
}

