/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.rewriter;

import org.portletbridge.UrlRewriter;
import org.portletbridge.UrlUtils;

public class DefaultUrlRewriter
implements UrlRewriter {
    private String currentUrl;
    private String currentProtocolHostPort;
    private String newBaseUrl;

    public DefaultUrlRewriter(String currentUrl, String newBaseUrl) {
        this.currentUrl = currentUrl;
        this.newBaseUrl = newBaseUrl;
        this.currentProtocolHostPort = UrlUtils.getProtocolHostPort(currentUrl);
    }

    public String rewrite(String url) {
        if (UrlUtils.isRelativeHttp(url)) {
            return url;
        }
        if (UrlUtils.isAbsoluteHttp(url)) {
            return UrlUtils.safeAppend(this.newBaseUrl, url);
        }
        if (UrlUtils.isFullHttp(url)) {
            if (this.currentProtocolHostPort != null) {
                if (url.startsWith(this.currentProtocolHostPort)) {
                    return UrlUtils.safeAppend(this.newBaseUrl, url.substring(this.currentProtocolHostPort.length()));
                }
                return url;
            }
            return url;
        }
        return url;
    }
}

