/*
 * Decompiled with CFR 0.152.
 */
package com.java2html;

import com.java2html.BadOptionException;
import com.java2html.Java2HTML;
import com.java2html.JavaDoc;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class Java2HTMLTask
extends Task {
    private Java2HTML java2HTML = new Java2HTML();
    private String[] javaSourceFileList = null;
    private Vector javaDocList = new Vector();
    private boolean failOnError = false;

    public void execute() throws BuildException {
        try {
            this.java2HTML.setJavaFileSource(this.javaSourceFileList);
            this.java2HTML.setJavaDoc(this.convertToArray(this.javaDocList));
            if (!this.java2HTML.buildJava2HTML() && this.failOnError) {
                throw new BuildException("Some Java files failed to convert to HTML");
            }
        }
        catch (Exception exception) {
            throw new BuildException("Java2HTML Build Problem:" + exception.getMessage(), (Throwable)exception);
        }
    }

    private JavaDoc[] convertToArray(Vector vector) {
        JavaDoc[] javaDocArray = new JavaDoc[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            javaDocArray[i] = (JavaDoc)vector.elementAt(i);
        }
        return javaDocArray;
    }

    public void setMarginSize(int n) {
        this.java2HTML.setMarginSize(n);
    }

    public void setTabSize(int n) {
        this.java2HTML.setTabSize(n);
    }

    public void setHeader(boolean bl) {
        this.java2HTML.setHeader(bl);
    }

    public void setSimple(boolean bl) {
        this.java2HTML.setSimple(bl);
    }

    public void setFooter(boolean bl) {
        this.java2HTML.setFooter(bl);
    }

    public void setTitle(String string) {
        this.java2HTML.setTitle(string);
    }

    public void addConfiguredFileSet(FileSet fileSet) {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
        directoryScanner.scan();
        String string = directoryScanner.getBasedir().getAbsolutePath() + File.separator;
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string + stringArray[i];
        }
        if (this.javaSourceFileList == null) {
            this.javaSourceFileList = stringArray;
        } else {
            String[] stringArray2 = new String[this.javaSourceFileList.length + stringArray.length];
            System.arraycopy(this.javaSourceFileList, 0, stringArray2, 0, this.javaSourceFileList.length);
            System.arraycopy(stringArray, 0, stringArray2, this.javaSourceFileList.length, stringArray.length);
            this.javaSourceFileList = stringArray2;
        }
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void addConfiguredJavaDoc(JavaDoc javaDoc) throws BuildException {
        try {
            javaDoc.validate();
        }
        catch (BadOptionException badOptionException) {
            throw new BuildException(badOptionException.getMessage());
        }
        this.javaDocList.addElement(javaDoc);
    }

    public void setDestination(File file) {
        System.out.println(file.getAbsolutePath());
        this.java2HTML.setDestination(file.getAbsolutePath());
    }
}

