/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public final class C3P0ConfigUtils {
    public static final String PROPS_FILE_RSRC_PATH = "/c3p0.properties";
    public static final String PROPS_FILE_PROP_PFX = "c3p0.";
    public static final int PROPS_FILE_PROP_PFX_LEN = 5;
    private static final String[] MISSPELL_PFXS = new String[]{"/c3pO", "/c3po", "/C3P0", "/C3PO"};
    static final MLogger logger = MLog.getLogger(C3P0ConfigUtils.class);

    public static HashMap extractHardcodedC3P0Defaults(boolean stringify) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        try {
            Method[] methods = C3P0Defaults.class.getMethods();
            int len = methods.length;
            for (int i = 0; i < len; ++i) {
                Method m = methods[i];
                int mods = m.getModifiers();
                if ((mods & 1) == 0 || (mods & 8) == 0 || m.getParameterTypes().length != 0) continue;
                if (stringify) {
                    Object val = m.invoke(null, null);
                    if (val == null) continue;
                    out.put(m.getName(), String.valueOf(val));
                    continue;
                }
                out.put(m.getName(), m.invoke(null, null));
            }
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, "Failed to extract hardcoded default config!?", e);
        }
        return out;
    }

    public static HashMap extractHardcodedC3P0Defaults() {
        return C3P0ConfigUtils.extractHardcodedC3P0Defaults(true);
    }

    public static HashMap extractC3P0PropertiesResources() {
        HashMap<String, String> out = new HashMap<String, String>();
        Properties props = C3P0ConfigUtils.findAllC3P0Properties();
        Iterator<Object> ii = props.keySet().iterator();
        while (ii.hasNext()) {
            String key = (String)ii.next();
            String val = (String)props.get(key);
            if (!key.startsWith(PROPS_FILE_PROP_PFX)) continue;
            out.put(key.substring(5).trim(), val.trim());
        }
        return out;
    }

    public static C3P0Config configFromFlatDefaults(HashMap flatDefaults) {
        NamedScope defaults = new NamedScope();
        defaults.props.putAll(flatDefaults);
        HashMap configNamesToNamedScopes = new HashMap();
        return new C3P0Config(defaults, configNamesToNamedScopes);
    }

    public static String getPropFileConfigProperty(String prop) {
        return MultiPropertiesConfig.readVmConfig().getProperty(prop);
    }

    private static Properties findResourceProperties() {
        return MultiPropertiesConfig.readVmConfig().getPropertiesByResourcePath(PROPS_FILE_RSRC_PATH);
    }

    private static Properties findAllC3P0Properties() {
        return MultiPropertiesConfig.readVmConfig().getPropertiesByPrefix("c3p0");
    }

    static Properties findAllC3P0SystemProperties() {
        Properties out = new Properties();
        SecurityException sampleExc = null;
        try {
            Iterator ii = C3P0Defaults.getKnownProperties().iterator();
            while (ii.hasNext()) {
                String key = (String)ii.next();
                String prefixedKey = PROPS_FILE_PROP_PFX + key;
                String value = System.getProperty(prefixedKey);
                if (value == null || value.trim().length() <= 0) continue;
                out.put(key, value);
            }
        }
        catch (SecurityException e) {
            sampleExc = e;
        }
        return out;
    }

    private C3P0ConfigUtils() {
    }

    static {
        if (logger.isLoggable(MLevel.WARNING) && C3P0ConfigUtils.class.getResource(PROPS_FILE_RSRC_PATH) == null) {
            for (int i = 0; i < MISSPELL_PFXS.length; ++i) {
                String test = MISSPELL_PFXS[i] + ".properties";
                if ((class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils == null ? C3P0ConfigUtils.class$("com.mchange.v2.c3p0.cfg.C3P0ConfigUtils") : class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils).getResource(MISSPELL_PFXS[i] + ".properties") == null) continue;
                logger.warning("POSSIBLY MISSPELLED c3p0.properties CONFIG RESOURCE FOUND. Please ensure the file name is c3p0.properties, all lower case, with the digit 0 (NOT the letter O) in c3p0. It should be placed  in the top level of c3p0's effective classpath.");
                break;
            }
        }
    }
}

